/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import org.jetbrains.android.actions.CreateResourceDirectoryAction;
import org.jetbrains.annotations.NotNull;

public class CreateXmlResourceSubdirPanel {
    private JPanel myDirectoriesPanel;
    private final CheckBoxList myDirectoriesList;
    private Map<String, JCheckBox> myCheckBoxes = Collections.emptyMap();
    private String[] myDirNames = ArrayUtil.EMPTY_STRING_ARRAY;
    private Project myProject;
    ResourceFolderType myFolderType;
    private Parent myParent;

    public CreateXmlResourceSubdirPanel(Project project, ResourceFolderType folderType, JPanel parentPanel, Parent parent) {
        this.myProject = project;
        this.myFolderType = folderType;
        this.myParent = parent;
        this.myDirectoriesPanel = parentPanel;
        this.myDirectoriesList = new CheckBoxList();
        this.setupDirectoriesPanel();
    }

    protected void setupDirectoriesPanel() {
        ToolbarDecorator decorator2 = ToolbarDecorator.createDecorator((JList)this.myDirectoriesList);
        decorator2.setEditAction(null);
        decorator2.disableUpDownActions();
        decorator2.setAddAction(button -> this.doAddNewDirectory());
        decorator2.setRemoveAction(button -> this.doDeleteDirectory());
        DumbAwareAction selectAll = new DumbAwareAction("Select All", null, PlatformIcons.SELECT_ALL_ICON){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                CreateXmlResourceSubdirPanel.this.doSelectAllDirs();
            }
        };
        decorator2.addExtraAction((AnAction)selectAll);
        DumbAwareAction unselectAll = new DumbAwareAction("Unselect All", null, PlatformIcons.UNSELECT_ALL_ICON){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                CreateXmlResourceSubdirPanel.this.doUnselectAllDirs();
            }
        };
        decorator2.addExtraAction((AnAction)unselectAll);
        this.myDirectoriesPanel.add(decorator2.createPanel());
        this.updateDirectories(true, this.myParent.getResourceDirectory());
    }

    private void doDeleteDirectory() {
        VirtualFile resourceDir = this.myParent.getResourceDirectory();
        if (resourceDir == null) {
            return;
        }
        int selectedIndex = this.myDirectoriesList.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        String selectedDirName = this.myDirNames[selectedIndex];
        VirtualFile selectedDir = resourceDir.findChild(selectedDirName);
        if (selectedDir == null) {
            return;
        }
        VirtualFileDeleteProvider provider = new VirtualFileDeleteProvider();
        provider.deleteElement(SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)this.myProject).add(CommonDataKeys.VIRTUAL_FILE_ARRAY, (Object)new VirtualFile[]{selectedDir}).build());
        this.updateDirectories(false, resourceDir);
    }

    private void doSelectAllDirs() {
        for (JCheckBox checkBox2 : this.myCheckBoxes.values()) {
            checkBox2.setSelected(true);
        }
        this.myDirectoriesList.repaint();
    }

    private void doUnselectAllDirs() {
        for (JCheckBox checkBox2 : this.myCheckBoxes.values()) {
            checkBox2.setSelected(false);
        }
        this.myDirectoriesList.repaint();
    }

    private void doAddNewDirectory() {
        PsiElement[] createdElements;
        VirtualFile resourceDir = this.myParent.getResourceDirectory();
        if (resourceDir == null) {
            return;
        }
        PsiDirectory psiResDir = PsiManager.getInstance((Project)this.myProject).findDirectory(resourceDir);
        if (psiResDir != null && (createdElements = new CreateResourceDirectoryAction(this.myFolderType).invokeDialog(this.myProject, psiResDir)).length > 0) {
            this.updateDirectories(false, resourceDir);
        }
    }

    public void updateDirectories(boolean updateFileCombo, VirtualFile resourceDir) {
        List directories = Collections.emptyList();
        if (resourceDir != null) {
            directories = IdeResourcesUtil.getResourceSubdirs(this.myFolderType, Collections.singleton(resourceDir));
            directories = ContainerUtil.sorted(directories, Comparator.comparing(VirtualFile::getName));
        }
        Map<String, JCheckBox> oldCheckBoxes = this.myCheckBoxes;
        int selectedIndex = this.myDirectoriesList.getSelectedIndex();
        String selectedDirName = selectedIndex >= 0 ? this.myDirNames[selectedIndex] : null;
        ArrayList<JCheckBox> checkBoxList = new ArrayList<JCheckBox>();
        this.myCheckBoxes = new HashMap<String, JCheckBox>();
        this.myDirNames = new String[directories.size()];
        int newSelectedIndex = -1;
        int i = 0;
        for (VirtualFile dir : directories) {
            String dirName = dir.getName();
            JCheckBox oldCheckBox = oldCheckBoxes.get(dirName);
            boolean selected = oldCheckBox != null && oldCheckBox.isSelected();
            JCheckBox checkBox2 = new JCheckBox(dirName, selected);
            checkBoxList.add(checkBox2);
            this.myCheckBoxes.put(dirName, checkBox2);
            this.myDirNames[i] = dirName;
            if (dirName.equals(selectedDirName)) {
                newSelectedIndex = i;
            }
            ++i;
        }
        String defaultFolderName = this.myFolderType.getName();
        JCheckBox noQualifierCheckBox = this.myCheckBoxes.get(defaultFolderName);
        if (noQualifierCheckBox == null) {
            noQualifierCheckBox = new JCheckBox(defaultFolderName);
            checkBoxList.add(0, noQualifierCheckBox);
            this.myCheckBoxes.put(defaultFolderName, noQualifierCheckBox);
            String[] newDirNames = new String[this.myDirNames.length + 1];
            newDirNames[0] = defaultFolderName;
            System.arraycopy(this.myDirNames, 0, newDirNames, 1, this.myDirNames.length);
            this.myDirNames = newDirNames;
        }
        noQualifierCheckBox.setSelected(true);
        this.myDirectoriesList.setModel((ListModel)new CollectionListModel(checkBoxList));
        if (newSelectedIndex >= 0) {
            this.myDirectoriesList.setSelectedIndex(newSelectedIndex);
        }
        if (updateFileCombo) {
            this.myParent.updateFilesCombo(directories);
        }
    }

    public void resetToDefault() {
        for (JCheckBox checkBox2 : this.myCheckBoxes.values()) {
            checkBox2.setSelected(false);
        }
        this.myCheckBoxes.get(this.myFolderType.getName()).setSelected(true);
        this.myDirectoriesList.repaint();
    }

    public void resetFromFile(@NotNull VirtualFile directory) {
        JCheckBox checkBox2 = this.myCheckBoxes.get(directory.getName());
        if (checkBox2 == null) {
            return;
        }
        for (JCheckBox checkBox1 : this.myCheckBoxes.values()) {
            checkBox1.setSelected(false);
        }
        checkBox2.setSelected(true);
    }

    public List<String> getDirNames() {
        ArrayList<String> selectedDirs = new ArrayList<String>();
        for (Map.Entry<String, JCheckBox> entry : this.myCheckBoxes.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            selectedDirs.add(entry.getKey());
        }
        return selectedDirs;
    }

    public static interface Parent {
        public VirtualFile getResourceDirectory();

        public void updateFilesCombo(List<VirtualFile> var1);
    }
}

