/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.sdklib.SdkVersionInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.xml.XmlElementDescriptorProvider;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DefinesXml;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.dom.DomElementXmlDescriptor;
import icons.StudioIcons;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AndroidXmlTagDescriptor;
import org.jetbrains.android.dom.drawable.CustomDrawableDomElement;
import org.jetbrains.android.dom.drawable.CustomDrawableElementDescriptor;
import org.jetbrains.android.dom.layout.DataBindingElement;
import org.jetbrains.android.dom.layout.LayoutElement;
import org.jetbrains.android.dom.layout.LayoutElementDescriptor;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.layout.LayoutViewElementDescriptor;
import org.jetbrains.android.dom.layout.View;
import org.jetbrains.android.dom.xml.AndroidXmlResourcesUtil;
import org.jetbrains.android.dom.xml.PreferenceElement;
import org.jetbrains.android.dom.xml.PreferenceElementDescriptor;
import org.jetbrains.android.facet.AndroidClassesForXmlUtilKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDomElementDescriptorProvider
implements XmlElementDescriptorProvider {
    private static final Map<String, Ref<Icon>> ourViewTagName2Icon = ContainerUtil.createSoftMap();

    @Nullable
    private static XmlElementDescriptor getDescriptor(@NotNull DomElement domElement, @NotNull XmlTag tag) {
        XmlElementDescriptor domDescriptor;
        XmlElementDescriptor parentDescriptor;
        AndroidFacet facet = AndroidFacet.getInstance((DomElement)domElement);
        if (facet == null) {
            return null;
        }
        DefinesXml definesXml = (DefinesXml)domElement.getAnnotation(DefinesXml.class);
        if (definesXml != null) {
            return new AndroidXmlTagDescriptor((XmlElementDescriptor)new DomElementXmlDescriptor(domElement));
        }
        PsiElement parent = tag.getParent();
        if (parent instanceof XmlTag && (parentDescriptor = ((XmlTag)parent).getDescriptor()) instanceof AndroidXmlTagDescriptor && (domDescriptor = parentDescriptor.getElementDescriptor(tag, (XmlTag)parent)) != null) {
            return new AndroidXmlTagDescriptor(domDescriptor);
        }
        return null;
    }

    public XmlElementDescriptor getDescriptor(XmlTag tag) {
        DomElement element;
        DomInvocationHandler handler2 = DomManagerImpl.getDomManager((Project)tag.getProject()).getDomHandler((XmlElement)tag);
        DomElement domElement = element = handler2 != null ? handler2.getProxy() : null;
        if (element instanceof LayoutElement) {
            return AndroidDomElementDescriptorProvider.createLayoutElementDescriptor((LayoutElement)element, tag);
        }
        if (element instanceof PreferenceElement) {
            return AndroidDomElementDescriptorProvider.createPreferenceElementDescriptor((PreferenceElement)element, tag);
        }
        if (element instanceof DataBindingElement) {
            return null;
        }
        if (element instanceof CustomDrawableDomElement) {
            return AndroidDomElementDescriptorProvider.createDrawableElementDescriptor((CustomDrawableDomElement)element, tag);
        }
        if (element instanceof AndroidDomElement) {
            return AndroidDomElementDescriptorProvider.getDescriptor(element, tag);
        }
        return null;
    }

    @Nullable
    public static PreferenceElementDescriptor createPreferenceElementDescriptor(@NotNull PreferenceElement element, @NotNull XmlTag tag) {
        AndroidFacet facet = AndroidFacet.getInstance((DomElement)element);
        if (facet == null) {
            return null;
        }
        String baseClass = AndroidXmlResourcesUtil.PreferenceSource.getPreferencesSource(tag, facet).getQualifiedBaseClass();
        String baseGroupClass = AndroidXmlResourcesUtil.PreferenceSource.getPreferencesSource(tag, facet).getQualifiedGroupClass();
        PsiClass preferenceClass = AndroidClassesForXmlUtilKt.findClassValidInXMLByName(facet, tag.getName(), baseClass);
        return new PreferenceElementDescriptor(preferenceClass, (XmlElementDescriptor)new DomElementXmlDescriptor((DomElement)element), baseGroupClass);
    }

    @Nullable
    public static CustomDrawableElementDescriptor createDrawableElementDescriptor(@NotNull CustomDrawableDomElement element, @NotNull XmlTag tag) {
        AndroidFacet facet = AndroidFacet.getInstance((DomElement)element);
        if (facet == null) {
            return null;
        }
        PsiClass preferenceClass = AndroidClassesForXmlUtilKt.findClassValidInXMLByName(facet, tag.getName(), "android.graphics.drawable.Drawable");
        return new CustomDrawableElementDescriptor(preferenceClass, (XmlElementDescriptor)new DomElementXmlDescriptor((DomElement)element));
    }

    @Nullable
    public static LayoutElementDescriptor createLayoutElementDescriptor(@NotNull LayoutElement element, @NotNull XmlTag tag) {
        if (element instanceof View) {
            PsiClass viewClass = (PsiClass)((View)element).getViewClass().getValue();
            return new LayoutViewElementDescriptor(viewClass, (View)element);
        }
        if (element instanceof LayoutViewElement) {
            AndroidFacet facet = AndroidFacet.getInstance((DomElement)element);
            if (facet == null) {
                return null;
            }
            PsiClass viewClass = AndroidClassesForXmlUtilKt.findViewValidInXMLByName(facet, tag.getName());
            return new LayoutViewElementDescriptor(viewClass, (LayoutViewElement)element);
        }
        return new LayoutElementDescriptor((XmlElementDescriptor)new DomElementXmlDescriptor((DomElement)element));
    }

    @Nullable
    public static Icon getIconForViewTag(@NotNull String tagName) {
        return AndroidDomElementDescriptorProvider.getIconForView(tagName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Icon getIconForView(@NotNull String keyName) {
        Map<String, Ref<Icon>> map2 = ourViewTagName2Icon;
        synchronized (map2) {
            Ref iconRef;
            if (ourViewTagName2Icon.isEmpty()) {
                Map<String, Icon> map3 = AndroidDomElementDescriptorProvider.getInitialViewTagName2IconMap();
                for (Map.Entry<String, Icon> entry : map3.entrySet()) {
                    ourViewTagName2Icon.put(entry.getKey(), (Ref<Icon>)Ref.create((Object)entry.getValue()));
                }
            }
            if ((iconRef = ourViewTagName2Icon.get(keyName)) == null) {
                Icon icon;
                try {
                    icon = (Icon)StudioIcons.LayoutEditor.Palette.class.getField(AndroidDomElementDescriptorProvider.convertToPaletteIconName(keyName)).get(null);
                }
                catch (Exception ex) {
                    icon = null;
                }
                iconRef = Ref.create(icon);
                ourViewTagName2Icon.put(keyName, (Ref<Icon>)iconRef);
            }
            return (Icon)iconRef.get();
        }
    }

    @NotNull
    private static String convertToPaletteIconName(@NotNull String tagName) {
        return StringUtil.toUpperCase((String)SdkVersionInfo.camelCaseToUnderlines((String)tagName));
    }

    @NotNull
    private static Map<String, Icon> getInitialViewTagName2IconMap() {
        HashMap<String, Icon> map2 = new HashMap<String, Icon>();
        map2.put("ActionMenuView", StudioIcons.LayoutEditor.Palette.LINEAR_LAYOUT_HORZ);
        map2.put("ContentFrameLayout", StudioIcons.LayoutEditor.Palette.FRAME_LAYOUT);
        map2.put("FitWindowsLinearLayout", StudioIcons.LayoutEditor.Palette.LINEAR_LAYOUT_HORZ);
        map2.put("FragmentContainerView", StudioIcons.LayoutEditor.Palette.FRAME_LAYOUT);
        map2.put("ImageFilterButton", StudioIcons.LayoutEditor.Palette.IMAGE_BUTTON);
        map2.put("ImageFilterView", StudioIcons.LayoutEditor.Palette.IMAGE_VIEW);
        map2.put("LinearLayout", StudioIcons.LayoutEditor.Palette.LINEAR_LAYOUT_HORZ);
        map2.put("MockView", StudioIcons.LayoutEditor.Palette.PLACEHOLDER);
        map2.put("MotionLayout", StudioIcons.LayoutEditor.Motion.MOTION_LAYOUT);
        map2.put("RecyclerViewImpl", StudioIcons.LayoutEditor.Palette.RECYCLER_VIEW);
        map2.put("SlidingTabIndicator", StudioIcons.LayoutEditor.Palette.LINEAR_LAYOUT_HORZ);
        map2.put("ViewPager2", StudioIcons.LayoutEditor.Palette.VIEW_PAGER);
        map2.put("ViewStubCompat", StudioIcons.LayoutEditor.Palette.VIEW_STUB);
        return map2;
    }
}

