/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.resources.ResourceFolderType;
import com.intellij.openapi.module.Module;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import java.util.EnumSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.CustomLogicResourceDomFileDescription;
import org.jetbrains.android.dom.FileDescriptionUtils;
import org.jetbrains.android.dom.MultipleKnownRootsResourceDomFileDescription;
import org.jetbrains.android.dom.ResourceFolderTypeDomFileDescription;
import org.jetbrains.android.dom.SingleRootResourceDomFileDescription;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u0019*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u0019B-\b\u0004\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fB)\b\u0014\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\u000eJ\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0014R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u0082\u0001\u0004\u001a\u001b\u001c\u001d\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/android/dom/AndroidResourceDomFileDescription;", "T", "Lcom/intellij/util/xml/DomElement;", "Lcom/intellij/util/xml/DomFileDescription;", "rootElementClass", "Ljava/lang/Class;", "rootTagName", "", "resourceFolderTypes", "Ljava/util/EnumSet;", "Lcom/android/resources/ResourceFolderType;", "<init>", "(Ljava/lang/Class;Ljava/lang/String;Ljava/util/EnumSet;)V", "resourceFolderType", "(Ljava/lang/Class;Ljava/lang/String;Lcom/android/resources/ResourceFolderType;)V", "getResourceFolderTypes", "()Ljava/util/EnumSet;", "isMyFile", "", "file", "Lcom/intellij/psi/xml/XmlFile;", "module", "Lcom/intellij/openapi/module/Module;", "initializeFileDescription", "", "Companion", "Lorg/jetbrains/android/dom/CustomLogicResourceDomFileDescription;", "Lorg/jetbrains/android/dom/MultipleKnownRootsResourceDomFileDescription;", "Lorg/jetbrains/android/dom/ResourceFolderTypeDomFileDescription;", "Lorg/jetbrains/android/dom/SingleRootResourceDomFileDescription;", "intellij.android.core"})
public abstract sealed class AndroidResourceDomFileDescription<T extends DomElement>
extends DomFileDescription<T>
permits CustomLogicResourceDomFileDescription, MultipleKnownRootsResourceDomFileDescription, ResourceFolderTypeDomFileDescription, SingleRootResourceDomFileDescription {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EnumSet<ResourceFolderType> resourceFolderTypes;

    private AndroidResourceDomFileDescription(Class<T> rootElementClass, String rootTagName, EnumSet<ResourceFolderType> resourceFolderTypes) {
        super(rootElementClass, rootTagName, new String[0]);
        EnumSet<ResourceFolderType> enumSet = EnumSet.copyOf(resourceFolderTypes);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"copyOf(...)");
        this.resourceFolderTypes = enumSet;
    }

    private AndroidResourceDomFileDescription(Class<T> rootElementClass, @NonNls String rootTagName, ResourceFolderType resourceFolderType) {
        EnumSet<Enum> enumSet = EnumSet.of((Enum)resourceFolderType);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
        this(rootElementClass, rootTagName, enumSet, null);
    }

    @NotNull
    public final EnumSet<ResourceFolderType> getResourceFolderTypes() {
        return this.resourceFolderTypes;
    }

    public boolean isMyFile(@NotNull XmlFile file, @Nullable Module module) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Iterator iterator2 = this.resourceFolderTypes.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            ResourceFolderType folderType = (ResourceFolderType)iterator3.next();
            Intrinsics.checkNotNull((Object)folderType);
            if (!Companion.isFileInResourceFolderType(file, folderType)) continue;
            return true;
        }
        return false;
    }

    protected void initializeFileDescription() {
        String[] stringArray = new String[]{"http://schemas.android.com/apk/res/android"};
        this.registerNamespacePolicy("android", stringArray);
        stringArray = new String[]{"http://schemas.android.com/apk/res-auto"};
        this.registerNamespacePolicy("app", stringArray);
        stringArray = new String[]{"http://schemas.android.com/tools"};
        this.registerNamespacePolicy("tools", stringArray);
    }

    @JvmStatic
    public static final boolean isFileInResourceFolderType(@NotNull XmlFile file, @NotNull ResourceFolderType folderType) {
        return Companion.isFileInResourceFolderType(file, folderType);
    }

    public /* synthetic */ AndroidResourceDomFileDescription(Class rootElementClass, String rootTagName, EnumSet resourceFolderTypes, DefaultConstructorMarker $constructor_marker) {
        this(rootElementClass, rootTagName, resourceFolderTypes);
    }

    public /* synthetic */ AndroidResourceDomFileDescription(Class rootElementClass, String rootTagName, ResourceFolderType resourceFolderType, DefaultConstructorMarker $constructor_marker) {
        this(rootElementClass, rootTagName, resourceFolderType);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/android/dom/AndroidResourceDomFileDescription$Companion;", "", "<init>", "()V", "isFileInResourceFolderType", "", "file", "Lcom/intellij/psi/xml/XmlFile;", "folderType", "Lcom/android/resources/ResourceFolderType;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isFileInResourceFolderType(@NotNull XmlFile file, @NotNull ResourceFolderType folderType) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
            return FileDescriptionUtils.isResourceOfTypeWithRootTag(file, folderType, SetsKt.emptySet());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

