/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlText;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.AndroidXmlTypedHandlerKt;
import org.jetbrains.android.dom.manifest.ManifestDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/android/dom/AndroidXmlTypedHandler;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "<init>", "()V", "charTyped", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "intellij.android.core"})
public final class AndroidXmlTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result charTyped(char charTyped, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!AndroidXmlTypedHandlerKt.access$isSupportedSymbol(charTyped) || !(file instanceof XmlFile)) {
            TypedHandlerDelegate.Result result2 = super.charTyped(charTyped, project, editor, file);
            Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"charTyped(...)");
            return result2;
        }
        AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, arg_0 -> AndroidXmlTypedHandler.charTyped$lambda$1(arg_0 -> AndroidXmlTypedHandler.charTyped$lambda$0(file, editor, arg_0), arg_0));
        return TypedHandlerDelegate.Result.STOP;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean charTyped$lambda$0(PsiFile $file, Editor $editor, PsiFile psiFile) {
        AndroidFacet androidFacet = AndroidFacet.getInstance((PsiElement)((PsiElement)$file));
        if (androidFacet == null) {
            return false;
        }
        AndroidFacet facet = androidFacet;
        PsiElement psiElement = psiFile.findElementAt($editor.getCaretModel().getOffset() - 1);
        if (psiElement == null) {
            return false;
        }
        PsiElement lastElement = psiElement;
        if (!AndroidXmlTypedHandlerKt.access$isSupportedSymbol(lastElement.getText().charAt(0))) return false;
        if (!(psiFile instanceof XmlFile)) return false;
        if (!ManifestDomFileDescription.isManifestFile((XmlFile)psiFile)) {
            VirtualFile virtualFile = ((XmlFile)psiFile).getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            if (!IdeResourcesUtil.isResourceFile(virtualFile, facet)) return false;
        }
        if (!(lastElement.getParent() instanceof XmlAttributeValue)) {
            if (!(lastElement.getParent() instanceof XmlText)) return false;
        }
        if (lastElement.getParent() instanceof XmlText) {
            if (IdeResourcesUtil.getFolderType(psiFile) != ResourceFolderType.VALUES) return false;
        }
        if (lastElement.getText().charAt(0) != '?') return true;
        if (IdeResourcesUtil.getFolderType(psiFile) != ResourceFolderType.LAYOUT) return false;
        return true;
    }

    private static final boolean charTyped$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

