/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.tools.idea.projectsystem.IdeaSourceProvider;
import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.dom.converters.CreateMissingJavaClassQuickFix;
import org.jetbrains.android.dom.converters.CreateMissingKotlinClassQuickFix;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B+\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H$R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\u001c\u001d\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/android/dom/converters/CreateMissingClassQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "destinationPackage", "Lcom/intellij/psi/PsiPackage;", "className", "", "module", "Lcom/intellij/openapi/module/Module;", "baseClassFqName", "<init>", "(Lcom/intellij/psi/PsiPackage;Ljava/lang/String;Lcom/intellij/openapi/module/Module;Ljava/lang/String;)V", "getClassName", "()Ljava/lang/String;", "getBaseClassFqName", "packagePointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "startInWriteAction", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "createClass", "Lcom/intellij/openapi/vfs/VirtualFile;", "directory", "Lcom/intellij/psi/PsiDirectory;", "Lorg/jetbrains/android/dom/converters/CreateMissingJavaClassQuickFix;", "Lorg/jetbrains/android/dom/converters/CreateMissingKotlinClassQuickFix;", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nCreateMissingClassQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateMissingClassQuickFix.kt\norg/jetbrains/android/dom/converters/CreateMissingClassQuickFix\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,174:1\n3829#2:175\n4344#2:176\n4345#2:180\n1761#3,3:177\n37#4:181\n36#4,3:182\n*S KotlinDebug\n*F\n+ 1 CreateMissingClassQuickFix.kt\norg/jetbrains/android/dom/converters/CreateMissingClassQuickFix\n*L\n140#1:175\n140#1:176\n140#1:180\n141#1:177,3\n155#1:181\n155#1:182,3\n*E\n"})
public abstract sealed class CreateMissingClassQuickFix
implements LocalQuickFix
permits CreateMissingJavaClassQuickFix, CreateMissingKotlinClassQuickFix {
    @NotNull
    private final String className;
    @NotNull
    private final Module module;
    @Nullable
    private final String baseClassFqName;
    @NotNull
    private final SmartPsiElementPointer<PsiPackage> packagePointer;

    private CreateMissingClassQuickFix(PsiPackage destinationPackage, String className, Module module, String baseClassFqName) {
        this.className = className;
        this.module = module;
        this.baseClassFqName = baseClassFqName;
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)destinationPackage.getProject()).createSmartPsiElementPointer((PsiElement)destinationPackage);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createSmartPsiElementPointer(...)");
        this.packagePointer = smartPsiElementPointer;
    }

    @NotNull
    protected final String getClassName() {
        return this.className;
    }

    @Nullable
    protected final String getBaseClassFqName() {
        return this.baseClassFqName;
    }

    public boolean startInWriteAction() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiDirectory psiDirectory;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiPackage psiPackage = (PsiPackage)this.packagePointer.getElement();
        if (psiPackage == null) {
            return;
        }
        PsiPackage destinationPackage = psiPackage;
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)this.module);
        if (androidFacet == null) {
            return;
        }
        AndroidFacet facet = androidFacet;
        IdeaSourceProvider sources = SourceProviderManager.Companion.getInstance(facet).getSources();
        List sourceDirs = CollectionsKt.distinct((Iterable)CollectionsKt.plus(sources.getJavaDirectories(), sources.getKotlinDirectories()));
        PsiDirectory[] psiDirectoryArray = destinationPackage.getDirectories();
        Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"getDirectories(...)");
        Object[] $this$filter$iv = psiDirectoryArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block10: {
                PsiDirectory packageDirectory = (PsiDirectory)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = sourceDirs;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        VirtualFile sourceDir = (VirtualFile)element$iv;
                        boolean bl3 = false;
                        if (!VfsUtilCore.isAncestor((VirtualFile)sourceDir, (VirtualFile)packageDirectory.getVirtualFile(), (boolean)true)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredPackageDirectories = (List)destination$iv$iv;
        switch (filteredPackageDirectories.size()) {
            case 0: {
                return;
            }
            case 1: {
                psiDirectory = (PsiDirectory)CollectionsKt.single((List)filteredPackageDirectories);
                break;
            }
            default: {
                Collection $this$toTypedArray$iv = filteredPackageDirectories;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                psiDirectory = DirectoryChooserUtil.selectDirectory((Project)destinationPackage.getProject(), (PsiDirectory[])thisCollection$iv.toArray(new PsiDirectory[0]), (PsiDirectory)((PsiDirectory)filteredPackageDirectories.get(0)), (String)"");
                if (psiDirectory != null) break;
                return;
            }
        }
        PsiDirectory directory = psiDirectory;
        VirtualFile createdFile = (VirtualFile)WriteCommandAction.runWriteCommandAction((Project)project, () -> CreateMissingClassQuickFix.applyFix$lambda$2(this, directory, project));
        OpenFileDescriptor fileDescriptor = new OpenFileDescriptor(project, createdFile);
        FileEditorManager.getInstance((Project)project).openEditor(fileDescriptor, true);
    }

    @NotNull
    protected abstract VirtualFile createClass(@NotNull PsiDirectory var1, @NotNull Project var2);

    private static final VirtualFile applyFix$lambda$2(CreateMissingClassQuickFix this$0, PsiDirectory $directory, Project $project) {
        Intrinsics.checkNotNull((Object)$directory);
        return this$0.createClass($directory, $project);
    }

    public /* synthetic */ CreateMissingClassQuickFix(PsiPackage destinationPackage, String className, Module module, String baseClassFqName, DefaultConstructorMarker $constructor_marker) {
        this(destinationPackage, className, module, baseClassFqName);
    }
}

