/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.tools.idea.databinding.index.BindingXmlData;
import com.android.tools.idea.databinding.index.BindingXmlIndex;
import com.android.tools.idea.databinding.index.ImportData;
import com.android.tools.idea.databinding.util.DataBindingUtil;
import com.android.tools.idea.lang.databinding.DataBindingLangUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.AndroidResolveScopeEnlarger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingConverter
extends ResolvingConverter<PsiElement>
implements CustomReferenceConverter<PsiElement> {
    @Nullable
    private static String getImport(@NotNull String importedShortName, @NotNull ConvertContext context) {
        BindingXmlIndex.Entry indexEntry = DataBindingConverter.getBindingIndexEntry(context);
        if (indexEntry == null) {
            return null;
        }
        return indexEntry.getData().resolveImport(importedShortName);
    }

    @NotNull
    public Collection<? extends PsiClass> getVariants(@NotNull ConvertContext context) {
        return Collections.emptyList();
    }

    @Nullable
    public PsiElement fromString(@Nullable @NonNls String type, @NotNull ConvertContext context) {
        if (type == null) {
            return null;
        }
        Module module = context.getModule();
        if (module == null) {
            return null;
        }
        BindingXmlIndex.Entry indexEntry = DataBindingConverter.getBindingIndexEntry(context);
        String qualifiedName = indexEntry == null ? type : DataBindingUtil.resolveImport(type, indexEntry.getData());
        Project project = context.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scope = DataBindingConverter.enlargeScope(module.getModuleWithDependenciesAndLibrariesScope(false), project, (PsiFile)context.getFile());
        if (!qualifiedName.isEmpty() && qualifiedName.indexOf(46) < 0) {
            if (Character.isLowerCase(qualifiedName.charAt(0))) {
                PsiPrimitiveType primitiveType = PsiJavaParserFacadeImpl.getPrimitiveType((String)qualifiedName);
                if (primitiveType != null) {
                    PsiClassType boxedType = primitiveType.getBoxedType(PsiManager.getInstance((Project)project), scope);
                    if (boxedType != null) {
                        return boxedType.resolve();
                    }
                    return null;
                }
            } else {
                PsiClass aClass = psiFacade.findClass("java.lang." + qualifiedName, scope);
                if (aClass != null) {
                    return aClass;
                }
            }
        }
        return psiFacade.findClass(qualifiedName, scope);
    }

    @Nullable
    public String toString(@Nullable PsiElement element, @NotNull ConvertContext context) {
        if (element instanceof PsiClass) {
            BindingXmlIndex.Entry indexEntry;
            String type = ((PsiClass)element).getQualifiedName();
            if (type != null && (indexEntry = DataBindingConverter.getBindingIndexEntry(context)) != null) {
                type = DataBindingConverter.unresolveImport(type, indexEntry.getData());
            }
            return type;
        }
        if (element instanceof PsiTypeElement) {
            return ((PsiTypeElement)element).getType().getCanonicalText();
        }
        return null;
    }

    private static String unresolveImport(@NotNull String className, @NotNull BindingXmlData layoutData) {
        List<String> segments = StringUtil.split((String)className, (String)".");
        if (!segments.isEmpty()) {
            String importedShortName = null;
            int maxMatchedSegments = 0;
            for (ImportData anImport : layoutData.getImports()) {
                String importedType = anImport.getType();
                int matchedSegments = DataBindingConverter.getNumberOfMatchedSegments(importedType, segments);
                if (matchedSegments <= maxMatchedSegments) continue;
                maxMatchedSegments = matchedSegments;
                importedShortName = anImport.getShortName();
            }
            if (maxMatchedSegments != 0) {
                segments = segments.subList(maxMatchedSegments - 1, segments.size());
                segments.set(0, importedShortName);
                return StringUtil.join(segments, (String)".");
            }
        }
        return className;
    }

    private static int getNumberOfMatchedSegments(String str, List<String> qName) {
        int offset = 0;
        for (int i = 0; i < qName.size(); ++i) {
            String segment = qName.get(i);
            int endOffset = offset + segment.length();
            if (!str.startsWith(segment, offset) || endOffset != str.length() && str.charAt(endOffset) != '.') {
                return i;
            }
            offset = endOffset + 1;
        }
        return qName.size();
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<PsiElement> value2, PsiElement element, ConvertContext context) {
        assert (element instanceof XmlAttributeValue);
        XmlAttributeValue attrValue = (XmlAttributeValue)element;
        String strValue = attrValue.getValue();
        ArrayList<PsiReference> result2 = new ArrayList<PsiReference>();
        int startOffset = attrValue.getValueTextRange().getStartOffset() - attrValue.getTextRange().getStartOffset();
        DataBindingConverter.createReferences(element, strValue, false, startOffset, context, result2);
        return result2.toArray(PsiReference.EMPTY_ARRAY);
    }

    protected static void createReferences(PsiElement element, String className, boolean resolveType, int startOffset, ConvertContext context, List<PsiReference> result2) {
        String packageName;
        String importedType;
        Module module = context.getModule();
        if (module == null) {
            return;
        }
        int offset = startOffset;
        List nameParts = StringUtil.split((String)className, (String)".");
        if (nameParts.isEmpty()) {
            return;
        }
        PsiReferenceBase rootReference = null;
        String rootName = (String)nameParts.get(0);
        String string = importedType = resolveType ? DataBindingConverter.getImport(rootName, context) : null;
        if (importedType != null) {
            TextRange range = new TextRange(offset, offset += rootName.length());
            rootReference = new AliasedReference(element, range, importedType, module);
        } else if (nameParts.size() == 1 && !rootName.isEmpty()) {
            if (Character.isLowerCase(rootName.charAt(0))) {
                PsiPrimitiveType primitive = PsiJavaParserFacadeImpl.getPrimitiveType((String)rootName);
                if (primitive != null) {
                    rootReference = new PsiReferenceBase.Immediate(element, true, element);
                }
            } else {
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)context.getProject()).findClass("java.lang." + rootName, GlobalSearchScope.moduleWithLibrariesScope((Module)module));
                if (psiClass != null) {
                    TextRange range = new TextRange(offset, offset += rootName.length());
                    rootReference = new ClassReference(element, range, (PsiElement)psiClass);
                }
            }
        }
        if (rootReference != null) {
            result2.add((PsiReference)rootReference);
            nameParts = ContainerUtil.prepend(nameParts.subList(1, nameParts.size()), (Object[])new String[]{rootReference.getCanonicalText()});
            ++offset;
        }
        int i = result2.size();
        while (i < nameParts.size() && !(packageName = (String)nameParts.get(i)).isEmpty()) {
            TextRange range = new TextRange(offset, offset += packageName.length());
            String qualifiedNameSoFar = String.join((CharSequence)".", nameParts.subList(0, i + 1));
            result2.add((PsiReference)new AliasedReference(element, range, qualifiedNameSoFar, module));
            ++i;
            ++offset;
        }
    }

    @Nullable
    protected static BindingXmlIndex.Entry getBindingIndexEntry(@NotNull ConvertContext context) {
        return DataBindingLangUtil.getBindingIndexEntry((PsiElement)context.getFile());
    }

    private static GlobalSearchScope enlargeScope(GlobalSearchScope scope, Project project, PsiFile psiFile) {
        SearchScope lightClassesScope = new AndroidResolveScopeEnlarger().getAdditionalResolveScope(psiFile.getVirtualFile(), project);
        if (lightClassesScope != null) {
            scope = scope.union(lightClassesScope);
        }
        return scope;
    }

    private static class AliasedReference
    extends PsiReferenceBase<PsiElement> {
        private final String myReferenceTo;
        private final Module myModule;

        AliasedReference(PsiElement referenceFrom, TextRange range, String referenceTo, Module module) {
            super(referenceFrom, range, true);
            this.myReferenceTo = referenceTo;
            this.myModule = module;
        }

        @Nullable
        public PsiElement resolve() {
            ResolveCache cache = ResolveCache.getInstance((Project)this.myElement.getProject());
            return (PsiElement)cache.resolveWithCaching((PsiReference)this, (psiReference, incompleteCode) -> this.resolveInner(), false, false);
        }

        private PsiElement resolveInner() {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myElement.getProject());
            PsiPackage aPackage = facade.findPackage(this.myReferenceTo);
            if (aPackage != null) {
                return aPackage;
            }
            Module module = this.myModule;
            GlobalSearchScope scope = module != null ? module.getModuleWithDependenciesAndLibrariesScope(false) : this.myElement.getResolveScope();
            PsiClass aClass = facade.findClass(this.myReferenceTo, scope = DataBindingConverter.enlargeScope(scope, this.myElement.getProject(), this.myElement.getContainingFile()));
            if (aClass != null) {
                return aClass;
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        @NotNull
        public String getCanonicalText() {
            return this.myReferenceTo;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element instanceof PsiClass) {
                PsiClass psiClass = (PsiClass)element;
                String newName = psiClass.getQualifiedName();
                return ElementManipulators.handleContentChange((PsiElement)this.myElement, (String)newName);
            }
            return super.bindToElement(element);
        }
    }

    private static class ClassReference
    extends PsiReferenceBase<PsiElement> {
        @NotNull
        private final PsiElement myResolveTo;

        ClassReference(@NotNull PsiElement element, @NotNull TextRange range, @NotNull PsiElement resolveTo) {
            super(element, range, true);
            this.myResolveTo = resolveTo;
        }

        @Nullable
        public PsiElement resolve() {
            ResolveCache cache = ResolveCache.getInstance((Project)this.myElement.getProject());
            return (PsiElement)cache.resolveWithCaching((PsiReference)this, (psiReference, incompleteCode) -> this.resolveInner(), false, false);
        }

        private PsiElement resolveInner() {
            return this.myResolveTo;
        }
    }
}

