/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.HashSet;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstrumentationTargetPackageConverter
extends Converter<String>
implements CustomReferenceConverter<String> {
    @Nullable
    public String fromString(@Nullable @NonNls String s, @NotNull ConvertContext context) {
        return s;
    }

    @Nullable
    public String toString(@Nullable String s, @NotNull ConvertContext context) {
        return s;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<String> value2, PsiElement element, ConvertContext context) {
        PsiReference[] psiReferenceArray;
        Module module = context.getModule();
        if (element != null && module != null) {
            PsiReference[] psiReferenceArray2 = new PsiReference[1];
            psiReferenceArray = psiReferenceArray2;
            psiReferenceArray2[0] = new MyReference(element, module);
        } else {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
        }
        return psiReferenceArray;
    }

    private static class MyReference
    extends PsiReferenceBase<PsiElement> {
        private final Module myModule;

        public MyReference(@NotNull PsiElement element, @NotNull Module module) {
            super(element, true);
            this.myModule = module;
        }

        @Nullable
        public PsiElement resolve() {
            return (PsiElement)ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)new ResolveCache.Resolver(){

                public PsiElement resolve(@NotNull PsiReference reference, boolean incompleteCode) {
                    return this.resolveInner();
                }
            }, false, false);
        }

        @Nullable
        private PsiElement resolveInner() {
            final String value2 = this.getValue();
            if (value2.isEmpty()) {
                return null;
            }
            final Ref result2 = Ref.create();
            this.processApkPackageAttrs(new Processor<GenericAttributeValue<String>>(){

                public boolean process(GenericAttributeValue<String> domValue) {
                    XmlAttributeValue xmlValue;
                    if (value2.equals(domValue.getValue()) && (xmlValue = domValue.getXmlAttributeValue()) != null) {
                        result2.set((Object)xmlValue);
                        return false;
                    }
                    return true;
                }
            });
            return (PsiElement)result2.get();
        }

        @NotNull
        public Object[] getVariants() {
            final HashSet result2 = new HashSet();
            this.processApkPackageAttrs(new Processor<GenericAttributeValue<String>>(){

                public boolean process(GenericAttributeValue<String> domValue) {
                    String value2 = (String)domValue.getValue();
                    if (value2 != null && !value2.isEmpty()) {
                        result2.add(value2);
                    }
                    return true;
                }
            });
            return ArrayUtil.toStringArray(result2);
        }

        private void processApkPackageAttrs(@NotNull Processor<GenericAttributeValue<String>> processor) {
            for (Module depModule : ModuleRootManager.getInstance((Module)this.myModule).getDependencies()) {
                GenericAttributeValue<String> packageAttr;
                Manifest manifest;
                AndroidFacet depFacet = AndroidFacet.getInstance((Module)depModule);
                if (depFacet == null || !((AndroidFacetConfiguration)depFacet.getConfiguration()).isAppProject() || (manifest = Manifest.getMainManifest(depFacet)) == null || (packageAttr = manifest.getPackage()) == null || processor.process(packageAttr)) continue;
                return;
            }
        }
    }
}

