/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.manifest;

import com.android.tools.idea.apk.viewer.ApkFileSystem;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.SourceProvidersKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.xml.DomFileDescription;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManifestDomFileDescription
extends DomFileDescription<Manifest> {
    public ManifestDomFileDescription() {
        super(Manifest.class, "manifest", new String[0]);
    }

    public boolean isMyFile(@NotNull XmlFile file, @Nullable Module module) {
        return module == null ? ManifestDomFileDescription.isManifestFile(file) : ManifestDomFileDescription.isManifestFile(file, module);
    }

    public static boolean isManifestFile(@NotNull XmlFile file) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        return ManifestDomFileDescription.isManifestFile(file, module);
    }

    public static boolean isManifestFile(@NotNull XmlFile file, @Nullable Module module) {
        AndroidFacet facet;
        if (module != null && !module.isDisposed() && (facet = AndroidFacet.getInstance((Module)module)) != null) {
            return ManifestDomFileDescription.isManifestFile(file, facet);
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        if (virtualFile.getFileSystem() instanceof ApkFileSystem || virtualFile instanceof LightVirtualFileBase) {
            return false;
        }
        return file.getName().equals("AndroidManifest.xml");
    }

    public static boolean isManifestFile(@NotNull XmlFile file, @NotNull AndroidFacet facet) {
        return file.getName().equals("AndroidManifest.xml") || AndroidModel.isRequired(facet) && file.getVirtualFile() != null && SourceProvidersKt.isManifestFile(facet, file.getVirtualFile());
    }

    protected void initializeFileDescription() {
        this.registerNamespacePolicy("android", new String[]{"http://schemas.android.com/apk/res/android"});
    }
}

