/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.navigation;

import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001a\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0003\u001a$\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\b0\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\b\u001a\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0010"}, d2={"extendsNavHostFragment", "", "psiClass", "Lcom/intellij/psi/PsiClass;", "module", "Lcom/intellij/openapi/module/Module;", "isNavHostFragment", "className", "", "getClass", "isInProject", "getClassesForTag", "", "tag", "dynamicModules", "", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nNavClassHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavClassHelper.kt\norg/jetbrains/android/dom/navigation/NavClassHelperKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,68:1\n1299#2,4:69\n1299#2,4:73\n488#3,7:77\n*S KotlinDebug\n*F\n+ 1 NavClassHelper.kt\norg/jetbrains/android/dom/navigation/NavClassHelperKt\n*L\n57#1:69,4\n60#1:73,4\n62#1:77,7\n*E\n"})
public final class NavClassHelperKt {
    public static final boolean extendsNavHostFragment(@NotNull PsiClass psiClass, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        PsiClass psiClass2 = NavClassHelperKt.getClass("androidx.navigation.fragment.NavHostFragment", module);
        if (psiClass2 == null) {
            return false;
        }
        PsiClass navHostClass = psiClass2;
        return psiClass.isInheritor(navHostClass, true);
    }

    public static final boolean isNavHostFragment(@NotNull String className, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (Intrinsics.areEqual((Object)className, (Object)"androidx.navigation.fragment.NavHostFragment")) {
            return true;
        }
        PsiClass psiClass = NavClassHelperKt.getClass(className, module);
        if (psiClass == null) {
            return false;
        }
        PsiClass psiClass2 = psiClass;
        return NavClassHelperKt.extendsNavHostFragment(psiClass2, module);
    }

    private static final PsiClass getClass(String className, Module module) {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
        if (javaPsiFacade == null) {
            return null;
        }
        JavaPsiFacade javaPsiFacade2 = javaPsiFacade;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"moduleWithDependenciesAndLibrariesScope(...)");
        GlobalSearchScope scope = globalSearchScope;
        return javaPsiFacade2.findClass(className, scope);
    }

    public static final boolean isInProject(@NotNull PsiClass $this$isInProject) {
        Intrinsics.checkNotNullParameter((Object)$this$isInProject, (String)"<this>");
        return ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)$this$isInProject)) != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<PsiClass, String> getClassesForTag(@NotNull Module module, @NotNull String tag) {
        void $this$associateWithTo$iv;
        String string;
        Map map2;
        Object t;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Map result2 = new LinkedHashMap();
        NavigationSchema navigationSchema = NavigationSchema.get(module);
        Intrinsics.checkNotNullExpressionValue((Object)navigationSchema, (String)"get(...)");
        NavigationSchema schema = navigationSchema;
        for (Module dynamicModule : NavClassHelperKt.dynamicModules(module)) {
            void $this$associateWithTo$iv2;
            GlobalSearchScope scope;
            Intrinsics.checkNotNullExpressionValue((Object)GlobalSearchScope.moduleWithDependenciesScope((Module)dynamicModule), (String)"moduleWithDependenciesScope(...)");
            List<PsiClass> list = schema.getProjectClassesForTag(tag, (SearchScope)scope);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getProjectClassesForTag(...)");
            Iterator iterator2 = list;
            Map destination$iv = result2;
            boolean $i$f$associateWithTo2 = false;
            for (Object element$iv : $this$associateWithTo$iv2) {
                PsiClass psiClass = (PsiClass)element$iv;
                t = element$iv;
                map2 = destination$iv;
                boolean bl = false;
                string = dynamicModule.getName();
                map2.put(t, string);
            }
        }
        List<PsiClass> list = schema.getProjectClassesForTag(tag);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getProjectClassesForTag(...)");
        Iterable iterable = list;
        Map destination$iv = result2;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv : $this$associateWithTo$iv) {
            PsiClass $i$f$associateWithTo2 = (PsiClass)element$iv;
            t = element$iv;
            map2 = destination$iv;
            boolean bl = false;
            string = null;
            map2.put(t, string);
        }
        Map $this$filterKeys$iv = result2;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            PsiClass it = (PsiClass)entry$iv.getKey();
            boolean bl = false;
            PsiModifierList psiModifierList = it.getModifierList();
            boolean bl2 = psiModifierList != null ? psiModifierList.hasModifierProperty("abstract") : false;
            if (!(!bl2)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    @NotNull
    public static final List<Module> dynamicModules(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return ProjectSystemUtil.getModuleSystem(module).getDynamicFeatureModules();
    }
}

