/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.navigation;

import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.tools.idea.AndroidPsiUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\n"}, d2={"getStartDestLayoutId", "", "navResourceId", "project", "Lcom/intellij/openapi/project/Project;", "resourceResolver", "Lcom/android/ide/common/resources/ResourceResolver;", "findStartDestination", "Lcom/intellij/psi/xml/XmlTag;", "root", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nNavXmlHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavXmlHelper.kt\norg/jetbrains/android/dom/navigation/NavXmlHelperKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1#2:75\n295#3,2:76\n*S KotlinDebug\n*F\n+ 1 NavXmlHelper.kt\norg/jetbrains/android/dom/navigation/NavXmlHelperKt\n*L\n67#1:76,2\n*E\n"})
public final class NavXmlHelperKt {
    @Nullable
    public static final String getStartDestLayoutId(@NotNull String navResourceId, @NotNull Project project, @NotNull ResourceResolver resourceResolver) {
        Intrinsics.checkNotNullParameter((Object)navResourceId, (String)"navResourceId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)resourceResolver, (String)"resourceResolver");
        if (!StringsKt.startsWith$default((String)navResourceId, (String)"@navigation/", (boolean)false, (int)2, null)) {
            return null;
        }
        Object object = resourceResolver.findResValue(navResourceId, false);
        if (object == null || (object = object.getValue()) == null) {
            return null;
        }
        Object fileName = object;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath((String)fileName);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely((Project)project, (VirtualFile)file);
        XmlFile xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
        if (xmlFile == null) {
            return null;
        }
        XmlFile psiFile2 = xmlFile;
        return (String)ApplicationManager.getApplication().runReadAction(() -> NavXmlHelperKt.getStartDestLayoutId$lambda$0(psiFile2));
    }

    private static final XmlTag findStartDestination(XmlTag root) {
        XmlTag current = root;
        while (true) {
            Object v5;
            block7: {
                String string;
                block9: {
                    block8: {
                        XmlTag xmlTag = current;
                        if (!Intrinsics.areEqual((Object)(xmlTag != null ? xmlTag.getName() : null), (Object)"navigation")) break;
                        string = current.getAttributeValue("startDestination", "http://schemas.android.com/apk/res-auto");
                        if (string == null) break block8;
                        String p0 = string;
                        boolean bl = false;
                        String string2 = ResourcesUtil.stripPrefixFromId((String)p0);
                        string = string2;
                        if (string2 != null) break block9;
                    }
                    return null;
                }
                String startDestId = string;
                PsiElement[] psiElementArray = current.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                Iterable $this$firstOrNull$iv = ArraysKt.filterIsInstance((Object[])psiElementArray, XmlTag.class);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String string3;
                    XmlTag it = (XmlTag)element$iv;
                    boolean bl = false;
                    if (it.getAttributeValue("id", "http://schemas.android.com/apk/res/android") != null) {
                        String p0;
                        boolean bl2 = false;
                        string3 = ResourcesUtil.stripPrefixFromId((String)p0);
                    } else {
                        string3 = null;
                    }
                    if (!Intrinsics.areEqual(string3, (Object)startDestId)) continue;
                    v5 = element$iv;
                    break block7;
                }
                v5 = null;
            }
            current = v5;
        }
        return current;
    }

    private static final String getStartDestLayoutId$lambda$0(XmlFile $psiFile) {
        XmlTag xmlTag = NavXmlHelperKt.findStartDestination($psiFile.getRootTag());
        return xmlTag != null ? xmlTag.getAttributeValue("layout", "http://schemas.android.com/tools") : null;
    }
}

