/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.exportSignedPackage;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.analytics.UsageTrackerUtils;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.SigningWizardEvent;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a&\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e\u001a\u000e\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0018\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0016"}, d2={"trackWizardOpen", "", "project", "Lcom/intellij/openapi/project/Project;", "trackWizardClosed", "trackWizardOkAction", "trackWizardGradleSigningFailed", "cause", "Lcom/google/wireless/android/sdk/stats/SigningWizardEvent$SigningWizardFailureCause;", "trackWizardIntellijSigningFailed", "trackWizardGradleSigning", "targetType", "Lcom/google/wireless/android/sdk/stats/SigningWizardEvent$SigningTargetType;", "numberOfModules", "", "numberOfVariants", "trackWizardIntellijSigning", "createEvent", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "kind", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$EventKind;", "createAndLog", "intellij.android.projectSystem.gradle"})
public final class SigningWizardUsageTrackerUtilsKt {
    public static final void trackWizardOpen(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SigningWizardUsageTrackerUtilsKt.createAndLog(project, AndroidStudioEvent.EventKind.SIGNING_WIZARD_OPEN);
    }

    public static final void trackWizardClosed(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SigningWizardUsageTrackerUtilsKt.createAndLog(project, AndroidStudioEvent.EventKind.SIGNING_WIZARD_CANCEL_ACTION);
    }

    public static final void trackWizardOkAction(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SigningWizardUsageTrackerUtilsKt.createAndLog(project, AndroidStudioEvent.EventKind.SIGNING_WIZARD_OK_ACTION);
    }

    public static final void trackWizardGradleSigningFailed(@NotNull Project project, @NotNull SigningWizardEvent.SigningWizardFailureCause cause) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        AndroidStudioEvent.Builder event = SigningWizardUsageTrackerUtilsKt.createEvent(project, AndroidStudioEvent.EventKind.SIGNING_WIZARD_GRADLE_SIGNING_FAILED).setSigningWizardEvent(SigningWizardEvent.newBuilder().setFailureCause(cause));
        Intrinsics.checkNotNull((Object)event);
        UsageTracker.log((AndroidStudioEvent.Builder)event);
    }

    public static final void trackWizardIntellijSigningFailed(@NotNull Project project, @NotNull SigningWizardEvent.SigningWizardFailureCause cause) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        AndroidStudioEvent.Builder event = SigningWizardUsageTrackerUtilsKt.createEvent(project, AndroidStudioEvent.EventKind.SIGNING_WIZARD_INTELLIJ_SIGNING_FAILED).setSigningWizardEvent(SigningWizardEvent.newBuilder().setFailureCause(cause));
        Intrinsics.checkNotNull((Object)event);
        UsageTracker.log((AndroidStudioEvent.Builder)event);
    }

    public static final void trackWizardGradleSigning(@NotNull Project project, @NotNull SigningWizardEvent.SigningTargetType targetType, int numberOfModules, int numberOfVariants) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        SigningWizardEvent.Builder signEvent = SigningWizardEvent.newBuilder().setTargetType(targetType).setNumberOfModules(numberOfModules).setNumberOfVariants(numberOfVariants);
        AndroidStudioEvent.Builder event = SigningWizardUsageTrackerUtilsKt.createEvent(project, AndroidStudioEvent.EventKind.SIGNING_WIZARD_GRADLE_SIGNING_SUCCEEDED).setSigningWizardEvent(signEvent);
        Intrinsics.checkNotNull((Object)event);
        UsageTracker.log((AndroidStudioEvent.Builder)event);
    }

    public static final void trackWizardIntellijSigning(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SigningWizardUsageTrackerUtilsKt.createAndLog(project, AndroidStudioEvent.EventKind.SIGNING_WIZARD_INTELLIJ_SIGNING_SUCCEEDED);
    }

    private static final AndroidStudioEvent.Builder createEvent(Project project, AndroidStudioEvent.EventKind kind) {
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PROJECT_SYSTEM).setKind(kind);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setKind(...)");
        return UsageTrackerUtils.withProjectId(builder, project);
    }

    private static final void createAndLog(Project project, AndroidStudioEvent.EventKind kind) {
        AndroidStudioEvent.Builder event = SigningWizardUsageTrackerUtilsKt.createEvent(project, kind);
        UsageTracker.log((AndroidStudioEvent.Builder)event);
    }
}

