/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.android.tools.idea.projectsystem.SourceProviders;
import com.android.tools.idea.res.AndroidProjectRootListener;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.Topic;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManagerToken;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\tH\u0016J\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\r8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/android/facet/ResourceFolderManager;", "Lcom/intellij/openapi/util/ModificationTracker;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/module/Module;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "generation", "", "getModificationCount", "folders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFolders", "()Ljava/util/List;", "primaryFolder", "getPrimaryFolder$annotations", "()V", "getPrimaryFolder", "()Lcom/intellij/openapi/vfs/VirtualFile;", "checkForChanges", "", "computeFolders", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "readFromFacetState", "Companion", "ResourceFolderListener", "intellij.android.core"})
public final class ResourceFolderManager
implements ModificationTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Module module;
    private volatile long generation;
    @NotNull
    private static final Key<List<VirtualFile>> FOLDERS_KEY;
    @NotNull
    private static final List<VirtualFile> emptyFolders;
    @JvmField
    @NotNull
    public static final Topic<ResourceFolderListener> EARLY_TOPIC;
    @JvmField
    @NotNull
    public static final Topic<ResourceFolderListener> TOPIC;

    public ResourceFolderManager(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.module = module;
        Project project = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        AndroidProjectRootListener.Companion.ensureSubscribed(project);
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    public long getModificationCount() {
        return this.generation;
    }

    @NotNull
    public final List<VirtualFile> getFolders() {
        AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((Module)this.module);
        if (androidFacet == null) {
            return emptyFolders;
        }
        AndroidFacet facet = androidFacet;
        List list = (List)facet.getUserData(FOLDERS_KEY);
        if (list == null) {
            Object object = facet.putUserDataIfAbsent(FOLDERS_KEY, this.computeFolders(facet));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"putUserDataIfAbsent(...)");
            list = (List)object;
        }
        return list;
    }

    @Nullable
    public final VirtualFile getPrimaryFolder() {
        return (VirtualFile)CollectionsKt.firstOrNull(this.getFolders());
    }

    @Deprecated(message="Instead of calling this, ask the user which resource folder should be used.")
    public static /* synthetic */ void getPrimaryFolder$annotations() {
    }

    public final void checkForChanges() {
        if (this.module.isDisposed()) {
            return;
        }
        AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((Module)this.module);
        if (androidFacet == null) {
            return;
        }
        AndroidFacet facet = androidFacet;
        List list = (List)facet.getUserData(FOLDERS_KEY);
        if (list == null) {
            return;
        }
        List before = list;
        facet.putUserData(FOLDERS_KEY, null);
        List<VirtualFile> after = this.getFolders();
        if (!Intrinsics.areEqual((Object)before, after)) {
            long l = this.generation;
            this.generation = l + 1L;
            ((ResourceFolderListener)this.module.getProject().getMessageBus().syncPublisher(EARLY_TOPIC)).foldersChanged(facet, after);
            ((ResourceFolderListener)this.module.getProject().getMessageBus().syncPublisher(TOPIC)).foldersChanged(facet, after);
        }
    }

    private final List<VirtualFile> computeFolders(AndroidFacet facet) {
        Object object;
        if (!AndroidModel.Companion.isRequired(facet)) {
            object = SourceProviderManager.Companion.getInstance(facet).getMainIdeaSourceProvider();
            if (object == null || (object = object.getResDirectories()) == null || (object = CollectionsKt.toList((Iterable)object)) == null) {
                object = CollectionsKt.emptyList();
            }
        } else {
            object = this.readFromFacetState(facet);
        }
        return object;
    }

    private final List<VirtualFile> readFromFacetState(AndroidFacet facet) {
        SourceProviders sourceProviderManager = SourceProviderManager.Companion.getInstance(facet);
        return ResourceFolderManagerToken.Companion.computeFoldersFromSourceProviders(sourceProviderManager, this.module);
    }

    @JvmStatic
    @NotNull
    public static final ResourceFolderManager getInstance(@NotNull AndroidFacet facet) {
        return Companion.getInstance(facet);
    }

    static {
        String string = Reflection.getOrCreateKotlinClass(ResourceFolderManager.class).getQualifiedName();
        if (string == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        Key key = Key.create((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        FOLDERS_KEY = key;
        emptyFolders = CollectionsKt.emptyList();
        String string3 = Reflection.getOrCreateKotlinClass(ResourceFolderManager.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string3);
        Topic topic = Topic.create((String)string3, ResourceFolderListener.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.NONE);
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"create(...)");
        EARLY_TOPIC = topic;
        String string4 = Reflection.getOrCreateKotlinClass(ResourceFolderManager.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string4);
        Topic topic2 = Topic.create((String)string4, ResourceFolderListener.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.NONE);
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"create(...)");
        TOPIC = topic2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007R-\u0010\u0004\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0007 \b*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u000f\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00110\u00110\u0010\u00a2\u0006\u0002\b\t8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0012\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00110\u00110\u0010\u00a2\u0006\u0002\b\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/android/facet/ResourceFolderManager$Companion;", "", "<init>", "()V", "FOLDERS_KEY", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "emptyFolders", "getInstance", "Lorg/jetbrains/android/facet/ResourceFolderManager;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "EARLY_TOPIC", "Lcom/intellij/util/messages/Topic;", "Lorg/jetbrains/android/facet/ResourceFolderManager$ResourceFolderListener;", "TOPIC", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ResourceFolderManager getInstance(@NotNull AndroidFacet facet) {
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            Object object = facet.getModule().getService(ResourceFolderManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (ResourceFolderManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H&\u00a8\u0006\t\u00c0\u0006\u0003"}, d2={"Lorg/jetbrains/android/facet/ResourceFolderManager$ResourceFolderListener;", "", "foldersChanged", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "folders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.android.core"})
    public static interface ResourceFolderListener {
        public void foldersChanged(@NotNull AndroidFacet var1, @NotNull List<? extends VirtualFile> var2);
    }
}

