/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.formatter;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.android.formatter.AndroidXmlCodeStyleSettings;
import org.jetbrains.android.formatter.ContextSpecificSettingsProviders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidXmlCodeStylePanel
extends CodeStyleAbstractPanel {
    private final JPanel myPanel = new JPanel(new BorderLayout());
    private final JBCheckBox myUseCustomSettings;
    private final List<MyFileSpecificPanel> myCodeStylePanels;
    private final JPanel myFileSpecificCodeStylesPanel;

    AndroidXmlCodeStylePanel(CodeStyleSettings currentSettings, CodeStyleSettings settings) {
        super((Language)XMLLanguage.INSTANCE, currentSettings, settings);
        this.myPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel centerPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.myPanel.add((Component)centerPanel, "Center");
        this.myUseCustomSettings = new JBCheckBox("Use custom formatting settings for Android XML files");
        this.myPanel.add((Component)this.myUseCustomSettings, "North");
        this.myCodeStylePanels = new ArrayList<MyFileSpecificPanel>();
        this.myCodeStylePanels.add(new ManifestCodeStylePanel());
        this.myCodeStylePanels.add(new LayoutCodeStylePanel());
        this.myCodeStylePanels.add(new ValueResourcesCodeStylePanel());
        this.myCodeStylePanels.add(new OtherCodeStylePanel());
        this.myFileSpecificCodeStylesPanel = new JPanel(new GridLayout((this.myCodeStylePanels.size() + 1) / 2, 2, 15, 0));
        centerPanel.add(this.myFileSpecificCodeStylesPanel);
        this.myUseCustomSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIUtil.setEnabled((Component)AndroidXmlCodeStylePanel.this.myFileSpecificCodeStylesPanel, (boolean)AndroidXmlCodeStylePanel.this.myUseCustomSettings.isSelected(), (boolean)true);
            }
        });
        for (MyFileSpecificPanel panel2 : this.myCodeStylePanels) {
            JPanel titledPanel = new JPanel(new BorderLayout());
            titledPanel.setBorder(IdeBorderFactory.createTitledBorder((String)panel2.getTitle()));
            titledPanel.add((Component)panel2, "Center");
            this.myFileSpecificCodeStylesPanel.add(titledPanel);
        }
    }

    protected int getRightMargin() {
        return 0;
    }

    @Nullable
    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        return null;
    }

    @NotNull
    protected FileType getFileType() {
        return XmlFileType.INSTANCE;
    }

    @Nullable
    protected String getPreviewText() {
        return null;
    }

    public void apply(CodeStyleSettings settings) {
        AndroidXmlCodeStyleSettings androidSettings = AndroidXmlCodeStyleSettings.getInstance(settings);
        androidSettings.USE_CUSTOM_SETTINGS = this.myUseCustomSettings.isSelected();
        for (MyFileSpecificPanel panel2 : this.myCodeStylePanels) {
            panel2.apply(androidSettings);
        }
    }

    public boolean isModified(CodeStyleSettings settings) {
        AndroidXmlCodeStyleSettings androidSettings = AndroidXmlCodeStyleSettings.getInstance(settings);
        if (androidSettings.USE_CUSTOM_SETTINGS != this.myUseCustomSettings.isSelected()) {
            return true;
        }
        for (MyFileSpecificPanel panel2 : this.myCodeStylePanels) {
            if (!panel2.isModified(androidSettings)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public JComponent getPanel() {
        return this.myPanel;
    }

    protected void resetImpl(CodeStyleSettings settings) {
        AndroidXmlCodeStyleSettings androidSettings = AndroidXmlCodeStyleSettings.getInstance(settings);
        this.myUseCustomSettings.setSelected(androidSettings.USE_CUSTOM_SETTINGS);
        UIUtil.setEnabled((Component)this.myFileSpecificCodeStylesPanel, (boolean)androidSettings.USE_CUSTOM_SETTINGS, (boolean)true);
        for (MyFileSpecificPanel panel2 : this.myCodeStylePanels) {
            panel2.resetImpl(androidSettings);
        }
    }

    public static class ManifestCodeStylePanel
    extends MyFileSpecificPanel<AndroidXmlCodeStyleSettings.ManifestSettings> {
        private final JBCheckBox myGroupTagsCheckBox;
        private JPanel myPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));

        public ManifestCodeStylePanel() {
            super("AndroidManifest.xml", ContextSpecificSettingsProviders.MANIFEST);
            this.myGroupTagsCheckBox = new JBCheckBox("Group tags with the same name");
            this.myPanel.add((Component)this.myGroupTagsCheckBox);
            this.init();
        }

        @Override
        @Nullable
        public JPanel getAdditionalOptionsPanel() {
            return this.myPanel;
        }

        @Override
        protected void apply(AndroidXmlCodeStyleSettings.ManifestSettings s) {
            super.apply(s);
            s.GROUP_TAGS_WITH_SAME_NAME = this.myGroupTagsCheckBox.isSelected();
        }

        @Override
        protected boolean isModified(AndroidXmlCodeStyleSettings.ManifestSettings s) {
            if (super.isModified(s)) {
                return true;
            }
            return s.GROUP_TAGS_WITH_SAME_NAME != this.myGroupTagsCheckBox.isSelected();
        }

        @Override
        protected void resetImpl(AndroidXmlCodeStyleSettings.ManifestSettings s) {
            super.resetImpl(s);
            this.myGroupTagsCheckBox.setSelected(s.GROUP_TAGS_WITH_SAME_NAME);
        }
    }

    private static class LayoutCodeStylePanel
    extends MyFileSpecificPanel<AndroidXmlCodeStyleSettings.LayoutSettings> {
        private JPanel myPanel;
        private JBCheckBox myInsertNewLineBeforeTagCheckBox;

        public LayoutCodeStylePanel() {
            super("Layout Files", ContextSpecificSettingsProviders.LAYOUT);
            this.setupUI();
            this.init();
        }

        @Override
        @Nullable
        public JPanel getAdditionalOptionsPanel() {
            return this.myPanel;
        }

        @Override
        protected boolean isModified(AndroidXmlCodeStyleSettings.LayoutSettings s) {
            if (super.isModified(s)) {
                return true;
            }
            return this.myInsertNewLineBeforeTagCheckBox.isSelected() != s.INSERT_BLANK_LINE_BEFORE_TAG;
        }

        @Override
        protected void resetImpl(AndroidXmlCodeStyleSettings.LayoutSettings s) {
            super.resetImpl(s);
            this.myInsertNewLineBeforeTagCheckBox.setSelected(s.INSERT_BLANK_LINE_BEFORE_TAG);
        }

        @Override
        protected void apply(AndroidXmlCodeStyleSettings.LayoutSettings s) {
            super.apply(s);
            s.INSERT_BLANK_LINE_BEFORE_TAG = this.myInsertNewLineBeforeTagCheckBox.isSelected();
        }

        private void setupUI() {
            this.myPanel = new JPanel();
            this.myPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
            this.myInsertNewLineBeforeTagCheckBox = new JBCheckBox();
            this.myInsertNewLineBeforeTagCheckBox.setText("Insert blank line before tag");
            this.myPanel.add((Component)this.myInsertNewLineBeforeTagCheckBox, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null, 0, false));
            Spacer spacer1 = new Spacer();
            this.myPanel.add((Component)spacer1, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        }
    }

    public static class ValueResourcesCodeStylePanel
    extends MyFileSpecificPanel<AndroidXmlCodeStyleSettings.ValueResourceFileSettings> {
        private final JBCheckBox myInsertLineBreaksAroundStyleCheckBox;
        private JPanel myPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));

        public ValueResourcesCodeStylePanel() {
            super("Value Resource Files and Selectors", ContextSpecificSettingsProviders.VALUE_RESOURCE_FILE);
            this.myInsertLineBreaksAroundStyleCheckBox = new JBCheckBox("Insert line breaks around style declaration");
            this.myPanel.add((Component)this.myInsertLineBreaksAroundStyleCheckBox);
            this.init();
            this.myInsertLineBreakBeforeFirstAttributeCheckBox.setVisible(false);
            this.myInsertLineBreakBeforeNamespaceDeclarationCheckBox.setVisible(false);
            this.myInsertLineBreakAfterLastAttributeCheckbox.setVisible(false);
        }

        @Override
        @Nullable
        public JPanel getAdditionalOptionsPanel() {
            return this.myPanel;
        }

        @Override
        protected void apply(AndroidXmlCodeStyleSettings.ValueResourceFileSettings s) {
            super.apply(s);
            s.INSERT_LINE_BREAKS_AROUND_STYLE = this.myInsertLineBreaksAroundStyleCheckBox.isSelected();
        }

        @Override
        protected boolean isModified(AndroidXmlCodeStyleSettings.ValueResourceFileSettings s) {
            if (super.isModified(s)) {
                return true;
            }
            return s.INSERT_LINE_BREAKS_AROUND_STYLE != this.myInsertLineBreaksAroundStyleCheckBox.isSelected();
        }

        @Override
        protected void resetImpl(AndroidXmlCodeStyleSettings.ValueResourceFileSettings s) {
            super.resetImpl(s);
            this.myInsertLineBreaksAroundStyleCheckBox.setSelected(s.INSERT_LINE_BREAKS_AROUND_STYLE);
        }
    }

    public static class OtherCodeStylePanel
    extends MyFileSpecificPanel<AndroidXmlCodeStyleSettings.OtherSettings> {
        public OtherCodeStylePanel() {
            super("Other XML resource files", ContextSpecificSettingsProviders.OTHER);
            this.init();
        }
    }

    public static abstract class MyFileSpecificPanel<T extends AndroidXmlCodeStyleSettings.MySettings>
    extends JPanel {
        private JPanel myPanel;
        private JPanel myAdditionalOptionsPanel;
        private JComboBox myWrapAttributesCombo;
        protected JBCheckBox myInsertLineBreakBeforeFirstAttributeCheckBox;
        protected JBCheckBox myInsertLineBreakBeforeNamespaceDeclarationCheckBox;
        protected JBCheckBox myInsertLineBreakAfterLastAttributeCheckbox;
        private final String myTitle;
        private final ContextSpecificSettingsProviders.Provider<T> mySettingsProvider;

        protected MyFileSpecificPanel(String title2, ContextSpecificSettingsProviders.Provider<T> provider) {
            this.setupUI();
            this.myTitle = title2;
            this.mySettingsProvider = provider;
            this.myInsertLineBreakBeforeFirstAttributeCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UIUtil.setEnabled((Component)myInsertLineBreakBeforeNamespaceDeclarationCheckBox, (boolean)myInsertLineBreakBeforeFirstAttributeCheckBox.isSelected(), (boolean)true);
                }
            });
        }

        protected void init() {
            JPanel panel2 = this.getAdditionalOptionsPanel();
            if (panel2 != null) {
                this.myAdditionalOptionsPanel.add((Component)panel2, "Center");
            } else {
                this.myAdditionalOptionsPanel.setVisible(false);
            }
            this.setLayout(new BorderLayout());
            this.add((Component)this.myPanel, "Center");
            AndroidXmlCodeStylePanel.fillWrappingCombo((JComboBox)this.myWrapAttributesCombo);
        }

        @Nullable
        public JPanel getAdditionalOptionsPanel() {
            return null;
        }

        public final void apply(AndroidXmlCodeStyleSettings settings) {
            this.apply(this.mySettingsProvider.getSettings(settings));
        }

        protected void apply(T s) {
            ((AndroidXmlCodeStyleSettings.MySettings)s).WRAP_ATTRIBUTES = CodeStyleSettings.WrapStyle.getId((CodeStyleSettings.WrapStyle)((CodeStyleSettings.WrapStyle)this.myWrapAttributesCombo.getSelectedItem()));
            ((AndroidXmlCodeStyleSettings.MySettings)s).INSERT_LINE_BREAK_BEFORE_FIRST_ATTRIBUTE = this.myInsertLineBreakBeforeFirstAttributeCheckBox.isSelected();
            ((AndroidXmlCodeStyleSettings.MySettings)s).INSERT_LINE_BREAK_BEFORE_NAMESPACE_DECLARATION = this.myInsertLineBreakBeforeNamespaceDeclarationCheckBox.isSelected();
            ((AndroidXmlCodeStyleSettings.MySettings)s).INSERT_LINE_BREAK_AFTER_LAST_ATTRIBUTE = this.myInsertLineBreakAfterLastAttributeCheckbox.isSelected();
        }

        public final boolean isModified(AndroidXmlCodeStyleSettings settings) {
            return this.isModified(this.mySettingsProvider.getSettings(settings));
        }

        protected boolean isModified(T s) {
            if (((AndroidXmlCodeStyleSettings.MySettings)s).WRAP_ATTRIBUTES != CodeStyleSettings.WrapStyle.getId((CodeStyleSettings.WrapStyle)((CodeStyleSettings.WrapStyle)this.myWrapAttributesCombo.getSelectedItem()))) {
                return true;
            }
            if (((AndroidXmlCodeStyleSettings.MySettings)s).INSERT_LINE_BREAK_BEFORE_FIRST_ATTRIBUTE != this.myInsertLineBreakBeforeFirstAttributeCheckBox.isSelected()) {
                return true;
            }
            if (((AndroidXmlCodeStyleSettings.MySettings)s).INSERT_LINE_BREAK_BEFORE_NAMESPACE_DECLARATION != this.myInsertLineBreakBeforeNamespaceDeclarationCheckBox.isSelected()) {
                return true;
            }
            return ((AndroidXmlCodeStyleSettings.MySettings)s).INSERT_LINE_BREAK_AFTER_LAST_ATTRIBUTE != this.myInsertLineBreakAfterLastAttributeCheckbox.isSelected();
        }

        protected final void resetImpl(AndroidXmlCodeStyleSettings settings) {
            this.resetImpl(this.mySettingsProvider.getSettings(settings));
        }

        protected void resetImpl(T s) {
            this.myWrapAttributesCombo.setSelectedItem(CodeStyleSettings.WrapStyle.forWrapping((int)((AndroidXmlCodeStyleSettings.MySettings)s).WRAP_ATTRIBUTES));
            this.myInsertLineBreakBeforeFirstAttributeCheckBox.setSelected(((AndroidXmlCodeStyleSettings.MySettings)s).INSERT_LINE_BREAK_BEFORE_FIRST_ATTRIBUTE);
            this.myInsertLineBreakBeforeNamespaceDeclarationCheckBox.setSelected(((AndroidXmlCodeStyleSettings.MySettings)s).INSERT_LINE_BREAK_BEFORE_NAMESPACE_DECLARATION);
            this.myInsertLineBreakAfterLastAttributeCheckbox.setSelected(((AndroidXmlCodeStyleSettings.MySettings)s).INSERT_LINE_BREAK_AFTER_LAST_ATTRIBUTE);
            UIUtil.setEnabled((Component)this.myInsertLineBreakBeforeNamespaceDeclarationCheckBox, (boolean)((AndroidXmlCodeStyleSettings.MySettings)s).INSERT_LINE_BREAK_BEFORE_FIRST_ATTRIBUTE, (boolean)true);
        }

        @NotNull
        public String getTitle() {
            return this.myTitle;
        }

        private void setupUI() {
            this.myPanel = new JPanel();
            this.myPanel.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1));
            Spacer spacer1 = new Spacer();
            this.myPanel.add((Component)spacer1, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
            this.myAdditionalOptionsPanel = new JPanel();
            this.myAdditionalOptionsPanel.setLayout(new BorderLayout(0, 0));
            this.myPanel.add((Component)this.myAdditionalOptionsPanel, new GridConstraints(4, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, false));
            JBLabel jBLabel1 = new JBLabel();
            this.loadLabelText((JLabel)jBLabel1, ApplicationBundle.message((String)"label.wrap.attributes", (Object[])new Object[0]));
            this.myPanel.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
            this.myWrapAttributesCombo = new JComboBox();
            this.myPanel.add((Component)this.myWrapAttributesCombo, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
            this.myInsertLineBreakBeforeFirstAttributeCheckBox = new JBCheckBox();
            this.myInsertLineBreakBeforeFirstAttributeCheckBox.setText("Insert line break before first attribute");
            this.myPanel.add((Component)this.myInsertLineBreakBeforeFirstAttributeCheckBox, new GridConstraints(1, 0, 1, 3, 0, 1, 0, 0, null, null, null, 0, false));
            Spacer spacer2 = new Spacer();
            this.myPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
            this.myInsertLineBreakAfterLastAttributeCheckbox = new JBCheckBox();
            this.myInsertLineBreakAfterLastAttributeCheckbox.setText("Insert line break after last attribute");
            this.myPanel.add((Component)this.myInsertLineBreakAfterLastAttributeCheckbox, new GridConstraints(3, 0, 1, 3, 0, 1, 0, 0, null, null, null, 0, false));
            this.myInsertLineBreakBeforeNamespaceDeclarationCheckBox = new JBCheckBox();
            this.myInsertLineBreakBeforeNamespaceDeclarationCheckBox.setText("Include namespace declarations");
            this.myPanel.add((Component)this.myInsertLineBreakBeforeNamespaceDeclarationCheckBox, new GridConstraints(2, 0, 1, 3, 0, 1, 0, 0, null, null, null, 2, false));
            jBLabel1.setLabelFor((Component)this.myWrapAttributesCombo);
        }

        private void loadLabelText(JLabel component, String text2) {
            TextWithMnemonic textWithMnemonic = TextWithMnemonic.parse((String)text2);
            component.setText(text2);
            if (textWithMnemonic.hasMnemonic()) {
                component.setDisplayedMnemonic(textWithMnemonic.getMnemonicCode());
                component.setDisplayedMnemonicIndex(textWithMnemonic.getMnemonicIndex());
            }
        }
    }
}

