/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.EmptyFindUsagesProvider;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/android/refactoring/AndroidFallbackFindUsagesProvider;", "Lcom/intellij/lang/findUsages/FindUsagesProvider;", "<init>", "()V", "canFindUsagesFor", "", "element", "Lcom/intellij/psi/PsiElement;", "getType", "", "getDescriptiveName", "getNodeText", "useFullName", "getHelpId", "getWordsScanner", "Lcom/intellij/lang/cacheBuilder/WordsScanner;", "Companion", "intellij.android.core"})
public final class AndroidFallbackFindUsagesProvider
implements FindUsagesProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EmptyFindUsagesProvider empty = new EmptyFindUsagesProvider();

    public boolean canFindUsagesFor(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return false;
    }

    @NotNull
    public String getType(@NotNull PsiElement element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (Companion.isBinaryResourceFile(element)) {
            string = "Android resource file";
        } else {
            String string2 = empty.getType(element);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getType(...)");
        }
        return string;
    }

    @NotNull
    public String getDescriptiveName(@NotNull PsiElement element) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!Companion.isBinaryResourceFile(element)) {
            String string = empty.getDescriptiveName(element);
            Intrinsics.checkNotNull((Object)string);
            object = string;
        } else {
            PsiBinaryFile file = (PsiBinaryFile)element;
            PsiDirectory dir = file.getContainingDirectory();
            if (dir != null) {
                object = dir.getName() + "/" + file.getName();
            } else {
                String string = file.getName();
                Intrinsics.checkNotNull((Object)string);
                object = string;
            }
        }
        return object;
    }

    @NotNull
    public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (Companion.isBinaryResourceFile(element)) {
            string = this.getDescriptiveName(element);
        } else {
            String string2 = empty.getNodeText(element, useFullName);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        }
        return string;
    }

    @Nullable
    public String getHelpId(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return Companion.isBinaryResourceFile(element) ? null : empty.getHelpId(element);
    }

    @Nullable
    public WordsScanner getWordsScanner() {
        return null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/android/refactoring/AndroidFallbackFindUsagesProvider$Companion;", "", "<init>", "()V", "empty", "Lcom/intellij/lang/findUsages/EmptyFindUsagesProvider;", "isBinaryResourceFile", "", "element", "Lcom/intellij/psi/PsiElement;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isBinaryResourceFile(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((PsiElement)element);
            if (androidFacet == null) {
                return false;
            }
            AndroidFacet facet = androidFacet;
            if (!(element instanceof PsiBinaryFile)) return false;
            VirtualFile virtualFile = ((PsiBinaryFile)element).getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            if (!IdeResourcesUtil.isResourceFile(virtualFile, facet)) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

