/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.spellchecker;

import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;

public class AndroidTextSpellcheckingStrategy
extends SpellcheckingStrategy
implements DumbAware {
    private static final Key<Boolean> mySpellcheckingIgnoredStateKey = Key.create((String)"android.spellchecking.ignored.state");

    public boolean isMyContext(@NotNull PsiElement element) {
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return false;
        }
        return AndroidTextSpellcheckingStrategy.isIgnored(file.getViewProvider().getVirtualFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isIgnored(@NotNull VirtualFile virtualFile) {
        Boolean spellcheckingIgnoredState = (Boolean)virtualFile.getUserData(mySpellcheckingIgnoredStateKey);
        if (spellcheckingIgnoredState == null) {
            Key<Boolean> key = mySpellcheckingIgnoredStateKey;
            synchronized (key) {
                spellcheckingIgnoredState = (Boolean)virtualFile.getUserData(mySpellcheckingIgnoredStateKey);
                if (spellcheckingIgnoredState == null) {
                    String name2;
                    FileType fileType = virtualFile.getFileType();
                    boolean lastIgnore = false;
                    if (fileType == FileTypes.PLAIN_TEXT) {
                        String name3 = virtualFile.getName();
                        if (Comparing.equal((String)name3, (String)"R.txt", (boolean)virtualFile.isCaseSensitive()) || Comparing.equal((String)name3, (String)"gradlew", (boolean)virtualFile.isCaseSensitive()) || Comparing.equal((String)name3, (String)"gradlew.bat", (boolean)virtualFile.isCaseSensitive()) || Comparing.equal((String)name3, (String)"import-summary.txt", (boolean)virtualFile.isCaseSensitive()) || Comparing.equal((String)name3, (String)".gitignore", (boolean)virtualFile.isCaseSensitive())) {
                            lastIgnore = true;
                        }
                    } else if (fileType == PropertiesFileType.INSTANCE && (Comparing.equal((String)(name2 = virtualFile.getName()), (String)"gradle-wrapper.properties", (boolean)virtualFile.isCaseSensitive()) || Comparing.equal((String)name2, (String)"local.properties", (boolean)virtualFile.isCaseSensitive()) || Comparing.equal((String)name2, (String)"gradle.properties", (boolean)virtualFile.isCaseSensitive()))) {
                        lastIgnore = true;
                    }
                    spellcheckingIgnoredState = lastIgnore;
                    virtualFile.putUserData(mySpellcheckingIgnoredStateKey, (Object)spellcheckingIgnoredState);
                }
            }
        }
        return spellcheckingIgnoredState;
    }

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        return EMPTY_TOKENIZER;
    }
}

