/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.spellchecker;

import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.lint.detector.api.Lint;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.inspections.TextSplitter;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.xml.XmlSpellcheckingStrategy;
import com.intellij.util.Consumer;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.converters.AndroidPackageConverter;
import org.jetbrains.android.dom.converters.AndroidPermissionConverter;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.converters.ConstantFieldConverter;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.resources.ResourceNameConverter;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidXmlSpellcheckingStrategy
extends XmlSpellcheckingStrategy
implements DumbAware {
    private final MyResourceReferenceTokenizer myResourceReferenceTokenizer = new MyResourceReferenceTokenizer();
    private final Tokenizer<XmlAttributeValue> myAttributeValueRenamingTokenizer = new Tokenizer<XmlAttributeValue>(this){

        public void tokenize(@NotNull XmlAttributeValue element, TokenConsumer consumer2) {
            consumer2.consumeToken((PsiElement)element, true, (Splitter)TextSplitter.getInstance());
        }
    };
    private static final AaptXmlTextSplitter AAPT_SPLITTER = new AaptXmlTextSplitter();

    public boolean isMyContext(@NotNull PsiElement element) {
        PsiFile file = element.getContainingFile();
        if (!(file instanceof XmlFile)) {
            return false;
        }
        return AndroidFacet.getInstance((PsiElement)file) != null || AndroidXmlSpellcheckingStrategy.isLintConfig((XmlFile)file);
    }

    private static boolean isLintConfig(@NotNull XmlFile file) {
        String tagName;
        if (file.getName().equals("lint.xml")) {
            return true;
        }
        XmlTag tag = file.getRootTag();
        return tag != null && ("lint".equals(tagName = tag.getName()) || "issues".equals(tagName));
    }

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (AndroidXmlSpellcheckingStrategy.isAttributeValueContext(element)) {
            return this.getAttributeValueTokenizer(element);
        }
        if (AndroidXmlSpellcheckingStrategy.inEnglish(element)) {
            return super.getTokenizer(element);
        }
        return EMPTY_TOKENIZER;
    }

    protected Tokenizer<? extends PsiElement> createTextTokenizer() {
        return new XmlSpellcheckingStrategy.XmlTextTokenizer((Splitter)AAPT_SPLITTER);
    }

    @NotNull
    public Tokenizer getAttributeValueTokenizer(PsiElement element) {
        GenericAttributeValue domValue;
        String value2;
        assert (element instanceof XmlAttributeValue);
        if (IdeResourcesUtil.isIdDeclaration((XmlAttributeValue)element)) {
            return this.myAttributeValueRenamingTokenizer;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof XmlAttribute && (value2 = ((XmlAttribute)parent).getValue()) != null && (domValue = DomManager.getDomManager((Project)parent.getProject()).getDomElement((XmlAttribute)parent)) != null) {
            Converter converter = domValue.getConverter();
            if (converter instanceof ResourceReferenceConverter) {
                return this.myResourceReferenceTokenizer;
            }
            if (converter instanceof ConstantFieldConverter || converter instanceof AndroidPermissionConverter) {
                return EMPTY_TOKENIZER;
            }
            if (converter instanceof ResourceNameConverter || converter instanceof AndroidPackageConverter) {
                return this.myAttributeValueRenamingTokenizer;
            }
        }
        return super.getTokenizer(element);
    }

    private static boolean isAttributeValueContext(@NotNull PsiElement element) {
        if (!(element instanceof XmlAttributeValue)) {
            return false;
        }
        PsiElement parent = element.getParent();
        PsiElement psiElement = parent = parent != null ? parent.getParent() : null;
        if (!(parent instanceof XmlTag)) {
            return false;
        }
        DomElement domElement = DomManager.getDomManager((Project)element.getProject()).getDomElement((XmlTag)parent);
        if (domElement instanceof AndroidDomElement) {
            return AndroidXmlSpellcheckingStrategy.inEnglish(element);
        }
        return false;
    }

    private static boolean inEnglish(PsiElement element) {
        XmlFile file = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)element, XmlFile.class);
        if (file != null) {
            String name2 = file.getName();
            if (name2.equals("AndroidManifest.xml")) {
                return true;
            }
            if (name2.equals("generated.xml") ? GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file.getVirtualFile(), (Project)element.getProject()) : AndroidXmlSpellcheckingStrategy.isLintConfig(file)) {
                return false;
            }
            PsiDirectory dir = file.getParent();
            if (dir != null) {
                String locale = Lint.getLocaleAndRegion((String)dir.getName());
                if (locale == null) {
                    locale = AndroidXmlSpellcheckingStrategy.getToolsLocale(file);
                }
                return locale == null || locale.startsWith("en") || locale.equals("b+en") || locale.startsWith("b+en+");
            }
        }
        return false;
    }

    @Nullable
    private static String getToolsLocale(XmlFile file) {
        XmlTag rootTag = file.getRootTag();
        if (rootTag != null) {
            return rootTag.getAttributeValue("locale", "http://schemas.android.com/tools");
        }
        return null;
    }

    private static class MyResourceReferenceTokenizer
    extends XmlSpellcheckingStrategy.XmlAttributeValueTokenizer {
        MyResourceReferenceTokenizer() {
            super((Splitter)TextSplitter.getInstance());
        }

        @Nullable
        private static AndroidResourceReferenceBase findResourceReference(PsiElement element) {
            for (PsiReference reference : element.getReferences()) {
                if (!(reference instanceof AndroidResourceReferenceBase)) continue;
                return (AndroidResourceReferenceBase)reference;
            }
            return null;
        }

        public void tokenize(@NotNull XmlAttributeValue element, TokenConsumer consumer2) {
            AndroidResourceReferenceBase reference = MyResourceReferenceTokenizer.findResourceReference((PsiElement)element);
            if (reference != null) {
                if (reference.getResourceValue().getPackage() == null) {
                    consumer2.consumeToken((PsiElement)element, true, (Splitter)TextSplitter.getInstance());
                }
                return;
            }
            super.tokenize(element, consumer2);
        }
    }

    public static class AaptXmlTextSplitter
    extends BaseSplitter {
        public void split(@Nullable String text2, @NotNull TextRange range, Consumer<TextRange> consumer2) {
            if (text2 == null || StringUtil.isEmpty((String)text2)) {
                return;
            }
            PlainTextSplitter ps = PlainTextSplitter.getInstance();
            if (text2.indexOf(92) == -1) {
                ps.split(text2, range, consumer2);
            } else {
                int end;
                int length = range.getEndOffset();
                int start2 = range.getStartOffset();
                do {
                    if ((end = text2.indexOf(92, start2)) == -1) {
                        end = length;
                    }
                    ps.split(text2, new TextRange(start2, end), consumer2);
                } while ((start2 = end + 2) < length);
            }
        }
    }
}

