/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview.classloading;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.AndroidManifestPackageNameUtils;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.projectmodel.ExternalAndroidLibrary;
import com.android.resources.aar.AarResourceRepository;
import com.android.tools.idea.projectsystem.DependencyScopeType;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.ResourceClassRegistry;
import com.android.tools.idea.res.StudioResourceIdManager;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.res.CacheableResourceRepository;
import com.android.tools.res.ResourceNamespacing;
import com.android.tools.res.ids.ResourceIdManager;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.facet.AndroidFacet;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0002\u001a$\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0001H\u0002\"\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"getResolvedPackageName", "", "Lcom/android/projectmodel/ExternalAndroidLibrary;", "registerLibraryResources", "", "Lcom/android/tools/idea/res/ResourceClassRegistry;", "externalLib", "idManager", "Lcom/android/tools/res/ids/ResourceIdManager;", "repositoryManager", "Lcom/android/tools/idea/res/StudioResourceRepositoryManager;", "registerResources", "module", "Lcom/intellij/openapi/module/Module;", "RESOURCE_CLASS_NAME", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "isResourceClassName", "", "className", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nLibraryResourceClassLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryResourceClassLoader.kt\norg/jetbrains/android/uipreview/classloading/LibraryResourceClassLoaderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n774#2:167\n865#2,2:168\n1869#2,2:170\n*S KotlinDebug\n*F\n+ 1 LibraryResourceClassLoader.kt\norg/jetbrains/android/uipreview/classloading/LibraryResourceClassLoaderKt\n*L\n99#1:167\n99#1:168,2\n100#1:170,2\n*E\n"})
public final class LibraryResourceClassLoaderKt {
    private static final Pattern RESOURCE_CLASS_NAME = Pattern.compile(".+\\.R(\\$[^.]+)?$");

    private static final String getResolvedPackageName(ExternalAndroidLibrary $this$getResolvedPackageName) {
        if ($this$getResolvedPackageName.getPackageName() != null) {
            return $this$getResolvedPackageName.getPackageName();
        }
        PathString pathString = $this$getResolvedPackageName.getManifestFile();
        if (pathString != null) {
            String string;
            PathString it = pathString;
            boolean bl = false;
            try {
                string = AndroidManifestPackageNameUtils.getPackageNameFromManifestFile((PathString)it);
            }
            catch (IOException ignore) {
                string = null;
            }
            return string;
        }
        return null;
    }

    private static final void registerLibraryResources(ResourceClassRegistry $this$registerLibraryResources, ExternalAndroidLibrary externalLib, ResourceIdManager idManager, StudioResourceRepositoryManager repositoryManager) {
        Triple triple;
        if (repositoryManager.getNamespacing() == ResourceNamespacing.DISABLED) {
            String string = LibraryResourceClassLoaderKt.getResolvedPackageName(externalLib);
            if (string == null) {
                return;
            }
            String resolvedPackageName = string;
            triple = new Triple((Object)repositoryManager.getAppResources(), (Object)ResourceNamespace.RES_AUTO, (Object)resolvedPackageName);
        } else {
            AarResourceRepository aarResourceRepository = repositoryManager.findLibraryResources(externalLib);
            if (aarResourceRepository == null) {
                return;
            }
            AarResourceRepository aarResources = aarResourceRepository;
            triple = new Triple((Object)aarResources, (Object)aarResources.getNamespace(), (Object)aarResources.getPackageName());
        }
        Triple triple2 = triple;
        ResourceRepository rClassContents = (ResourceRepository)triple2.component1();
        Object object = triple2.component2();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component2(...)");
        ResourceNamespace resourcesNamespace = (ResourceNamespace)object;
        String packageName = (String)triple2.component3();
        $this$registerLibraryResources.addLibrary(rClassContents, idManager, packageName, resourcesNamespace);
    }

    /*
     * WARNING - void declaration
     */
    private static final void registerResources(Module module) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String resourcePackageName2;
        Iterable resourcePackageNames;
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
        if (androidFacet == null) {
            return;
        }
        AndroidFacet androidFacet2 = androidFacet;
        StudioResourceRepositoryManager studioResourceRepositoryManager = StudioResourceRepositoryManager.getInstance(androidFacet2);
        Intrinsics.checkNotNullExpressionValue((Object)studioResourceRepositoryManager, (String)"getInstance(...)");
        StudioResourceRepositoryManager repositoryManager = studioResourceRepositoryManager;
        ResourceIdManager idManager = StudioResourceIdManager.Companion.get(module);
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ResourceClassRegistry classRegistry = ResourceClassRegistry.Companion.get(project);
        if (!idManager.getFinalIdsUsed()) {
            resourcePackageNames = (List)ActionsKt.runReadAction(() -> LibraryResourceClassLoaderKt.registerResources$lambda$1(androidFacet2));
            for (String resourcePackageName2 : resourcePackageNames) {
                CacheableResourceRepository cacheableResourceRepository = repositoryManager.getAppResources();
                Intrinsics.checkNotNullExpressionValue((Object)cacheableResourceRepository, (String)"<get-appResources>(...)");
                ResourceRepository resourceRepository = cacheableResourceRepository;
                ResourceNamespace resourceNamespace = repositoryManager.getNamespace();
                Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace, (String)"<get-namespace>(...)");
                classRegistry.addLibrary(resourceRepository, idManager, resourcePackageName2, resourceNamespace);
            }
        }
        resourcePackageNames = ProjectSystemUtil.getModuleSystem(module).getAndroidLibraryDependencies(DependencyScopeType.MAIN);
        boolean $i$f$filter = false;
        resourcePackageName2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ExternalAndroidLibrary it = (ExternalAndroidLibrary)element$iv$iv;
            boolean bl = false;
            if (!it.getHasResources()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExternalAndroidLibrary it = (ExternalAndroidLibrary)element$iv;
            boolean bl = false;
            LibraryResourceClassLoaderKt.registerLibraryResources(classRegistry, it, idManager, repositoryManager);
        }
    }

    private static final boolean isResourceClassName(String className) {
        return RESOURCE_CLASS_NAME.matcher(className).matches();
    }

    private static final List registerResources$lambda$1(AndroidFacet $androidFacet) {
        return ProjectSystemUtil.getModuleSystem($androidFacet).getModuleDependencies().getResourcePackageNames(false);
    }

    public static final /* synthetic */ boolean access$isResourceClassName(String className) {
        return LibraryResourceClassLoaderKt.isResourceClassName(className);
    }

    public static final /* synthetic */ void access$registerResources(Module module) {
        LibraryResourceClassLoaderKt.registerResources(module);
    }
}

