/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0017\u001a\u00020\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0011\u0010\u000b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\nR\u0011\u0010\u000e\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u0011\u0010\u0010\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0011\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u0011\u0010\u0013\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\nR\u0011\u0010\u0015\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\nR\u0011\u0010\u001c\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001eR\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006-"}, d2={"Lcom/android/adblib/RemoteFileMode;", "", "modeBits", "", "<init>", "(I)V", "getModeBits", "()I", "isRegularFile", "", "()Z", "isDirectory", "isSymbolicLink", "isBlockDevice", "isSocket", "isCharacterDevice", "isFifo", "hasStickyBit", "getHasStickyBit", "hasSetUserIddBit", "getHasSetUserIddBit", "hasSetGroupIdBit", "getHasSetGroupIdBit", "equals", "other", "hashCode", "toString", "", "longFormatString", "getLongFormatString", "()Ljava/lang/String;", "fileTypePrefix", "", "getFileTypePrefix", "()C", "posixString", "getPosixString", "posixPermissions", "", "Ljava/nio/file/attribute/PosixFilePermission;", "getPosixPermissions", "()Ljava/util/Set;", "isFileType", "value", "Companion", "android.sdktools.adblib"})
public final class RemoteFileMode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int modeBits;
    private static final int S_IFMT = 61440;
    private static final int S_IFSOCK = 49152;
    private static final int S_IFLNK = 40960;
    private static final int S_IFREG = 32768;
    private static final int S_IFBLK = 24576;
    private static final int S_IFDIR = 16384;
    private static final int S_IFCHR = 8192;
    private static final int S_IFIFO = 4096;
    private static final int S_ISUID = 2048;
    private static final int S_ISGID = 1024;
    private static final int S_ISVTX = 512;
    private static final int S_IRWXU = 448;
    private static final int S_IRUSR = 256;
    private static final int S_IWUSR = 128;
    private static final int S_IXUSR = 64;
    private static final int S_IRWXG = 56;
    private static final int S_IRGRP = 32;
    private static final int S_IWGRP = 16;
    private static final int S_IXGRP = 8;
    private static final int S_IRWXO = 7;
    private static final int S_IROTH = 4;
    private static final int S_IWOTH = 2;
    private static final int S_IXOTH = 1;

    private RemoteFileMode(int modeBits) {
        this.modeBits = modeBits;
    }

    public final int getModeBits() {
        return this.modeBits;
    }

    public final boolean isRegularFile() {
        return this.isFileType(32768);
    }

    public final boolean isDirectory() {
        return this.isFileType(16384);
    }

    public final boolean isSymbolicLink() {
        return this.isFileType(40960);
    }

    public final boolean isBlockDevice() {
        return this.isFileType(24576);
    }

    public final boolean isSocket() {
        return this.isFileType(49152);
    }

    public final boolean isCharacterDevice() {
        return this.isFileType(8192);
    }

    public final boolean isFifo() {
        return this.isFileType(4096);
    }

    public final boolean getHasStickyBit() {
        return (this.modeBits & 0x200) != 0;
    }

    public final boolean getHasSetUserIddBit() {
        return (this.modeBits & 0x800) != 0;
    }

    public final boolean getHasSetGroupIdBit() {
        return (this.modeBits & 0x400) != 0;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof RemoteFileMode && this.modeBits == ((RemoteFileMode)other).modeBits;
    }

    public int hashCode() {
        return Integer.hashCode(this.modeBits);
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(\"" + this.getLongFormatString() + "\")";
    }

    @NotNull
    public final String getLongFormatString() {
        return this.getFileTypePrefix() + this.getPosixString();
    }

    public final char getFileTypePrefix() {
        return (char)(this.isRegularFile() ? 45 : (this.isDirectory() ? 100 : (this.isSymbolicLink() ? 108 : (this.isCharacterDevice() ? 99 : (this.isBlockDevice() ? 98 : (this.isFifo() ? 112 : (this.isSocket() ? 115 : 63)))))));
    }

    @NotNull
    public final String getPosixString() {
        String string2 = PosixFilePermissions.toString(this.getPosixPermissions());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public final Set<PosixFilePermission> getPosixPermissions() {
        return RemoteFileMode.Companion.modeBitsToPosixPermissions(this.modeBits);
    }

    private final boolean isFileType(int value) {
        return (this.modeBits & 0xF000) == value;
    }

    public /* synthetic */ RemoteFileMode(int modeBits, DefaultConstructorMarker $constructor_marker) {
        this(modeBits);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0005J\u001f\u0010\"\u001a\u00020\u001d2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020%0$\"\u00020%\u00a2\u0006\u0002\u0010&J\u0014\u0010\"\u001a\u00020\u001d2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0'J\u000e\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*J\u0010\u0010+\u001a\u0004\u0018\u00010\u001d2\u0006\u0010,\u001a\u00020-J\u0017\u0010.\u001a\u0004\u0018\u00010\u001d2\u0006\u0010,\u001a\u00020-H\u0000\u00a2\u0006\u0002\b/J\u001d\u00100\u001a\u00020\u00052\u000e\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020%0$H\u0002\u00a2\u0006\u0002\u00102J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020%0'2\u0006\u0010!\u001a\u00020\u0005H\u0002J\u0010\u00104\u001a\u00020\u00052\u0006\u00105\u001a\u00020%H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00066"}, d2={"Lcom/android/adblib/RemoteFileMode$Companion;", "", "<init>", "()V", "S_IFMT", "", "S_IFSOCK", "S_IFLNK", "S_IFREG", "S_IFBLK", "S_IFDIR", "S_IFCHR", "S_IFIFO", "S_ISUID", "S_ISGID", "S_ISVTX", "S_IRWXU", "S_IRUSR", "S_IWUSR", "S_IXUSR", "S_IRWXG", "S_IRGRP", "S_IWGRP", "S_IXGRP", "S_IRWXO", "S_IROTH", "S_IWOTH", "S_IXOTH", "DEFAULT", "Lcom/android/adblib/RemoteFileMode;", "getDEFAULT", "()Lcom/android/adblib/RemoteFileMode;", "fromModeBits", "modeBits", "fromPosixPermissions", "permissions", "", "Ljava/nio/file/attribute/PosixFilePermission;", "([Ljava/nio/file/attribute/PosixFilePermission;)Lcom/android/adblib/RemoteFileMode;", "", "fromPosixString", "value", "", "fromPath", "path", "Ljava/nio/file/Path;", "fromUnsupportedFileSystem", "fromUnsupportedFileSystem$android_sdktools_adblib", "modeBitsFromPosixPermissions", "posixPermissions", "([Ljava/nio/file/attribute/PosixFilePermission;)I", "modeBitsToPosixPermissions", "modeBitFromPosixFilePermission", "permission", "android.sdktools.adblib"})
    @SourceDebugExtension(value={"SMAP\nRemoteFileMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteFileMode.kt\ncom/android/adblib/RemoteFileMode$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,304:1\n37#2:305\n36#2,3:306\n37#2:309\n36#2,3:310\n13472#3,2:313\n13472#3,2:315\n*S KotlinDebug\n*F\n+ 1 RemoteFileMode.kt\ncom/android/adblib/RemoteFileMode$Companion\n*L\n201#1:305\n201#1:306,3\n213#1:309\n213#1:310,3\n272#1:313,2\n280#1:315,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RemoteFileMode getDEFAULT() {
            return this.fromModeBits(Integer.parseInt("644", CharsKt.checkRadix((int)8)));
        }

        @NotNull
        public final RemoteFileMode fromModeBits(int modeBits) {
            return new RemoteFileMode(modeBits, null);
        }

        @NotNull
        public final RemoteFileMode fromPosixPermissions(PosixFilePermission ... permissions) {
            Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
            return new RemoteFileMode(this.modeBitsFromPosixPermissions(permissions), null);
        }

        @NotNull
        public final RemoteFileMode fromPosixPermissions(@NotNull Set<? extends PosixFilePermission> permissions) {
            Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
            Collection $this$toTypedArray$iv = permissions;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            PosixFilePermission[] posixFilePermissionArray = thisCollection$iv.toArray(new PosixFilePermission[0]);
            return this.fromPosixPermissions(Arrays.copyOf(posixFilePermissionArray, posixFilePermissionArray.length));
        }

        @NotNull
        public final RemoteFileMode fromPosixString(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Set<PosixFilePermission> permissions = PosixFilePermissions.fromString(value);
            Intrinsics.checkNotNull(permissions);
            Collection $this$toTypedArray$iv = permissions;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            PosixFilePermission[] posixFilePermissionArray = thisCollection$iv.toArray(new PosixFilePermission[0]);
            return this.fromPosixPermissions(Arrays.copyOf(posixFilePermissionArray, posixFilePermissionArray.length));
        }

        @Nullable
        public final RemoteFileMode fromPath(@NotNull Path path) {
            RemoteFileMode remoteFileMode;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            try {
                Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(path, new LinkOption[0]);
                Intrinsics.checkNotNull(permissions);
                remoteFileMode = this.fromPosixPermissions(permissions);
            }
            catch (UnsupportedOperationException e) {
                remoteFileMode = this.fromUnsupportedFileSystem$android_sdktools_adblib(path);
            }
            catch (Exception e) {
                remoteFileMode = null;
            }
            return remoteFileMode;
        }

        @Nullable
        public final RemoteFileMode fromUnsupportedFileSystem$android_sdktools_adblib(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            try {
                HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
                if (Files.isReadable(path)) {
                    permissions.add(PosixFilePermission.OWNER_READ);
                    permissions.add(PosixFilePermission.GROUP_READ);
                    permissions.add(PosixFilePermission.OTHERS_READ);
                }
                if (Files.isWritable(path)) {
                    permissions.add(PosixFilePermission.OWNER_WRITE);
                }
                if (Files.isExecutable(path)) {
                    permissions.add(PosixFilePermission.OWNER_EXECUTE);
                    permissions.add(PosixFilePermission.GROUP_EXECUTE);
                    permissions.add(PosixFilePermission.OTHERS_EXECUTE);
                }
                return permissions.isEmpty() ? null : this.fromPosixPermissions((Set<? extends PosixFilePermission>)permissions);
            }
            catch (Exception e) {
                return null;
            }
        }

        private final int modeBitsFromPosixPermissions(PosixFilePermission[] posixPermissions) {
            int modeBits = 0;
            PosixFilePermission[] $this$forEach$iv = posixPermissions;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                PosixFilePermission element$iv;
                PosixFilePermission permission = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                modeBits |= Companion.modeBitFromPosixFilePermission(permission);
            }
            return modeBits;
        }

        private final Set<PosixFilePermission> modeBitsToPosixPermissions(int modeBits) {
            HashSet<PosixFilePermission> result2 = new HashSet<PosixFilePermission>();
            PosixFilePermission[] $this$forEach$iv = PosixFilePermission.values();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                PosixFilePermission element$iv;
                PosixFilePermission permission = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if ((modeBits & Companion.modeBitFromPosixFilePermission(permission)) == 0) continue;
                result2.add(permission);
            }
            return result2;
        }

        private final int modeBitFromPosixFilePermission(PosixFilePermission permission) {
            return switch (WhenMappings.$EnumSwitchMapping$0[permission.ordinal()]) {
                case 1 -> 256;
                case 2 -> 128;
                case 3 -> 64;
                case 4 -> 32;
                case 5 -> 16;
                case 6 -> 8;
                case 7 -> 4;
                case 8 -> 2;
                case 9 -> 1;
                default -> 0;
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PosixFilePermission.values().length];
                try {
                    nArray[PosixFilePermission.OWNER_READ.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PosixFilePermission.OWNER_WRITE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PosixFilePermission.OWNER_EXECUTE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PosixFilePermission.GROUP_READ.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PosixFilePermission.GROUP_WRITE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PosixFilePermission.GROUP_EXECUTE.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PosixFilePermission.OTHERS_READ.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PosixFilePermission.OTHERS_WRITE.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PosixFilePermission.OTHERS_EXECUTE.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

