/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.impl;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u00002\u00020\u0001:\u0002\b\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\n"}, d2={"Lcom/android/adblib/impl/StdoutByteBufferProcessor;", "", "<init>", "()V", "convertBuffer", "Ljava/nio/ByteBuffer;", "buffer", "convertBufferEnd", "DirectProcessor", "StripCrLfProcessor", "android.sdktools.adblib"})
public abstract class StdoutByteBufferProcessor {
    @NotNull
    public abstract ByteBuffer convertBuffer(@NotNull ByteBuffer var1);

    @Nullable
    public abstract ByteBuffer convertBufferEnd();

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/adblib/impl/StdoutByteBufferProcessor$DirectProcessor;", "Lcom/android/adblib/impl/StdoutByteBufferProcessor;", "<init>", "()V", "convertBuffer", "Ljava/nio/ByteBuffer;", "buffer", "convertBufferEnd", "android.sdktools.adblib"})
    public static final class DirectProcessor
    extends StdoutByteBufferProcessor {
        @Override
        @NotNull
        public ByteBuffer convertBuffer(@NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            return buffer;
        }

        @Override
        @Nullable
        public ByteBuffer convertBufferEnd() {
            return null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002J*\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00052\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000e0\u0010H\u0002J \u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/android/adblib/impl/StdoutByteBufferProcessor$StripCrLfProcessor;", "Lcom/android/adblib/impl/StdoutByteBufferProcessor;", "<init>", "()V", "workBuffer", "Ljava/nio/ByteBuffer;", "leftoverByte", "", "Ljava/lang/Byte;", "convertBuffer", "buffer", "convertBufferEnd", "ensureWorkBuffer", "processCrLfRanges", "", "block", "Lkotlin/Function2;", "", "indexOfCrLf", "bytes", "offset", "limit", "android.sdktools.adblib"})
    @SourceDebugExtension(value={"SMAP\nStdoutByteBufferProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StdoutByteBufferProcessor.kt\ncom/android/adblib/impl/StdoutByteBufferProcessor$StripCrLfProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n1#2:153\n*E\n"})
    public static final class StripCrLfProcessor
    extends StdoutByteBufferProcessor {
        @Nullable
        private ByteBuffer workBuffer;
        @Nullable
        private Byte leftoverByte;

        @Override
        @NotNull
        public ByteBuffer convertBuffer(@NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            if (buffer.remaining() == 0) {
                return buffer;
            }
            ByteBuffer destinationBuffer = this.ensureWorkBuffer(buffer);
            destinationBuffer.clear();
            Byte by = this.leftoverByte;
            if (by != null) {
                boolean bl;
                byte by2 = ((Number)by).byteValue();
                boolean bl2 = false;
                boolean bl3 = bl = buffer.remaining() > 0;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                if (by2 != 13 || buffer.get(buffer.position()) != 10) {
                    destinationBuffer.put(by2);
                }
                this.leftoverByte = null;
            }
            ByteBuffer slice = buffer.slice();
            this.processCrLfRanges(buffer, (Function2<? super Integer, ? super Integer, Unit>)((Function2)(arg_0, arg_1) -> StripCrLfProcessor.convertBuffer$lambda$1(buffer, this, destinationBuffer, slice, arg_0, arg_1)));
            buffer.position(buffer.limit());
            destinationBuffer.flip();
            return destinationBuffer;
        }

        @Override
        @Nullable
        public ByteBuffer convertBufferEnd() {
            ByteBuffer byteBuffer;
            Byte by = this.leftoverByte;
            if (by != null) {
                byte by2 = ((Number)by).byteValue();
                boolean bl = false;
                ByteBuffer byteBuffer2 = this.workBuffer;
                if (byteBuffer2 != null) {
                    ByteBuffer buffer = byteBuffer2;
                    boolean bl2 = false;
                    buffer.clear();
                    buffer.put(by2);
                    buffer.flip();
                }
                byteBuffer = this.workBuffer;
            } else {
                byteBuffer = null;
            }
            return byteBuffer;
        }

        private final ByteBuffer ensureWorkBuffer(ByteBuffer buffer) {
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2 = this.workBuffer;
            if (byteBuffer2 != null) {
                ByteBuffer byteBuffer3;
                ByteBuffer it = byteBuffer3 = byteBuffer2;
                boolean bl = false;
                if (it.capacity() != buffer.capacity()) {
                    throw new IllegalArgumentException("ByteBuffer capacity should not vary during successive calls");
                }
                byteBuffer = byteBuffer3;
            } else {
                ByteBuffer byteBuffer4;
                ByteBuffer it = byteBuffer4 = ByteBuffer.allocate(buffer.capacity());
                boolean bl = false;
                this.workBuffer = it;
                ByteBuffer byteBuffer5 = byteBuffer4;
                byteBuffer = byteBuffer5;
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer5, (String)"also(...)");
            }
            return byteBuffer;
        }

        private final void processCrLfRanges(ByteBuffer buffer, Function2<? super Integer, ? super Integer, Unit> block) {
            int index2 = buffer.position();
            int limit = buffer.limit();
            while (index2 < limit) {
                int crLfOffset = this.indexOfCrLf(buffer, index2, limit);
                if (crLfOffset < 0) {
                    block.invoke((Object)index2, (Object)limit);
                    break;
                }
                block.invoke((Object)index2, (Object)crLfOffset);
                index2 = crLfOffset + 1;
            }
        }

        private final int indexOfCrLf(ByteBuffer bytes, int offset, int limit) {
            int previousByte = -1;
            for (int index2 = offset; index2 < limit; ++index2) {
                byte currentByte = bytes.get(index2);
                if (previousByte == 13 && currentByte == 10) {
                    return index2 - 1;
                }
                previousByte = currentByte;
            }
            return -1;
        }

        private static final Unit convertBuffer$lambda$1(ByteBuffer $buffer, StripCrLfProcessor this$0, ByteBuffer $destinationBuffer, ByteBuffer $slice, int start2, int end2) {
            int n;
            if (end2 == $buffer.limit() && start2 < end2 && $buffer.get(end2 - 1) == 13) {
                this$0.leftoverByte = 13;
                n = end2 - 1;
            } else if (end2 == $buffer.limit() && $destinationBuffer.remaining() < end2 - start2) {
                boolean bl;
                boolean bl2 = bl = $destinationBuffer.remaining() == end2 - start2 - 1;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                this$0.leftoverByte = $buffer.get(end2 - 1);
                n = end2 - 1;
            } else {
                n = end2;
            }
            int actualEnd = n;
            $slice.limit(actualEnd);
            $slice.position(start2);
            $destinationBuffer.put($slice);
            return Unit.INSTANCE;
        }
    }
}

