/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.impl;

import com.android.adblib.SystemNanoTimeProvider;
import com.android.adblib.impl.TimeoutTrackerKt;
import com.android.adblib.utils.SystemNanoTime;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\u000bJ\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/android/adblib/impl/TimeoutTracker;", "", "nanoTimeProvider", "Lcom/android/adblib/SystemNanoTimeProvider;", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "<init>", "(Lcom/android/adblib/SystemNanoTimeProvider;JLjava/util/concurrent/TimeUnit;)V", "unit", "(JLjava/util/concurrent/TimeUnit;)V", "getTimeUnit", "()Ljava/util/concurrent/TimeUnit;", "startNanos", "remainingMills", "getRemainingMills", "()J", "remainingNanos", "getRemainingNanos", "getRemainingTime", "getElapsedTime", "toString", "", "throwIfElapsed", "", "elapsedNanos", "Companion", "android.sdktools.adblib"})
public final class TimeoutTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SystemNanoTimeProvider nanoTimeProvider;
    private final long timeout;
    @NotNull
    private final TimeUnit timeUnit;
    private final long startNanos;
    @NotNull
    private static final TimeoutTracker INFINITE = new TimeoutTracker(Long.MAX_VALUE, TimeUnit.NANOSECONDS);

    public TimeoutTracker(@NotNull SystemNanoTimeProvider nanoTimeProvider, long timeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)nanoTimeProvider, (String)"nanoTimeProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        this.nanoTimeProvider = nanoTimeProvider;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.startNanos = this.elapsedNanos(0L);
    }

    @NotNull
    public final TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public TimeoutTracker(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        this(SystemNanoTime.Companion.getInstance(), timeout, unit);
    }

    public final long getRemainingMills() {
        return this.getRemainingTime(TimeUnit.MILLISECONDS);
    }

    public final long getRemainingNanos() {
        if (this.timeout != Long.MAX_VALUE) {
            return this.timeUnit.toNanos(this.timeout) - this.elapsedNanos(this.startNanos);
        }
        return Long.MAX_VALUE;
    }

    public final long getRemainingTime(@NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        if (this.timeout != Long.MAX_VALUE) {
            return unit.convert(this.getRemainingNanos(), TimeUnit.NANOSECONDS);
        }
        return Long.MAX_VALUE;
    }

    public final long getElapsedTime(@NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return unit.convert(this.elapsedNanos(this.startNanos), TimeUnit.NANOSECONDS);
    }

    @NotNull
    public String toString() {
        Locale locale = Locale.ROOT;
        String string2 = "%s, %,.1f msec elapsed";
        Object[] objectArray = new Object[]{TimeoutTrackerKt.remainingTimeoutToString(this.getRemainingMills(), TimeUnit.MILLISECONDS), (double)this.getElapsedTime(TimeUnit.MILLISECONDS)};
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }

    public final void throwIfElapsed() throws TimeoutException {
        if (this.getRemainingNanos() <= 0L) {
            throw new TimeoutException("Operation has timed out");
        }
    }

    private final long elapsedNanos(long startNanos) {
        return this.nanoTimeProvider.nanoTime() - startNanos;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/android/adblib/impl/TimeoutTracker$Companion;", "", "<init>", "()V", "INFINITE", "Lcom/android/adblib/impl/TimeoutTracker;", "getINFINITE", "()Lcom/android/adblib/impl/TimeoutTracker;", "fromTimeout", "unit", "Ljava/util/concurrent/TimeUnit;", "timeout", "", "android.sdktools.adblib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TimeoutTracker getINFINITE() {
            return INFINITE;
        }

        @NotNull
        public final TimeoutTracker fromTimeout(@NotNull TimeUnit unit, long timeout) {
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            return timeout == Long.MAX_VALUE ? this.getINFINITE() : new TimeoutTracker(timeout, unit);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

