/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.testrunner;

public class TestIdentifier {
    private final String mClassName;
    private final String mTestName;
    private final int mTestIndex;

    public TestIdentifier(String className, String testName) {
        this(className, testName, -1);
    }

    public TestIdentifier(String className, String testName, int testIndex) {
        if (className == null || testName == null) {
            throw new IllegalArgumentException("className and testName must be non-null");
        }
        this.mClassName = className;
        this.mTestName = testName;
        this.mTestIndex = testIndex;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public String getTestName() {
        return this.mTestName;
    }

    public int getTestIndex() {
        return this.mTestIndex;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.mClassName == null ? 0 : this.mClassName.hashCode());
        result2 = 31 * result2 + (this.mTestName == null ? 0 : this.mTestName.hashCode());
        result2 = 31 * result2 + this.mTestIndex;
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestIdentifier other = (TestIdentifier)obj;
        if (this.mClassName == null ? other.mClassName != null : !this.mClassName.equals(other.mClassName)) {
            return false;
        }
        if (this.mTestName == null ? other.mTestName != null : !this.mTestName.equals(other.mTestName)) {
            return false;
        }
        return this.mTestIndex == other.mTestIndex;
    }

    public String toString() {
        return String.format("%s#%s", this.getClassName(), this.getTestName());
    }
}

