/*
 * Decompiled with CFR 0.152.
 */
package com.android.incfs.install.adb.ddmlib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.TimeoutException;
import com.android.incfs.install.IDeviceConnection;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

public class DeviceConnection
implements IDeviceConnection {
    private final SocketChannel mChannel;
    private final Selector mReadSelector;
    private final Selector mWriteSelector;

    public static Factory getFactory(String deviceSerialNumber2) throws IOException {
        AndroidDebugBridge adb = AndroidDebugBridge.getBridge();
        if (adb == null) {
            throw new IOException("Unable to connect to adb");
        }
        for (IDevice device2 : adb.getDevices()) {
            if (!deviceSerialNumber2.equals(device2.getSerialNumber())) continue;
            return new Factory(device2);
        }
        throw new IOException("Failed to find device with serial \"" + deviceSerialNumber2 + "\"");
    }

    private DeviceConnection(SocketChannel channel) throws IOException {
        this.mChannel = channel;
        this.mChannel.configureBlocking(false);
        this.mReadSelector = Selector.open();
        this.mChannel.register(this.mReadSelector, 1);
        this.mWriteSelector = Selector.open();
        this.mChannel.register(this.mWriteSelector, 4);
    }

    @Override
    public int read(ByteBuffer dst, long timeoutMs) throws IOException {
        this.mReadSelector.select(timeoutMs);
        return this.mChannel.read(dst);
    }

    @Override
    public int write(ByteBuffer src, long timeoutMs) throws IOException {
        this.mWriteSelector.select(timeoutMs);
        return this.mChannel.write(src);
    }

    @Override
    public void close() throws Exception {
        try (SocketChannel c = this.mChannel;
             Selector r2 = this.mReadSelector;){
            Selector w = this.mWriteSelector;
            if (w != null) {
                w.close();
            }
        }
    }

    public static class Factory
    implements IDeviceConnection.Factory {
        private final IDevice mDevice;

        private Factory(IDevice device2) {
            this.mDevice = device2;
        }

        @Override
        public IDeviceConnection connectToService(String service, String[] parameters) throws IOException {
            SocketChannel channel;
            try {
                channel = this.mDevice.rawBinder(service, parameters);
            }
            catch (AdbCommandRejectedException | TimeoutException e) {
                throw new IOException(String.format("Failed invoking binder command \"%s %s\"", service, String.join((CharSequence)" ", parameters)), e);
            }
            channel.configureBlocking(false);
            return new DeviceConnection(channel);
        }
    }
}

