/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwppacket;

import com.android.jdwppacket.IDSizes;
import com.android.jdwppacket.Writer;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0006\u0010\r\u001a\u00020\tJ\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0018H\u0016J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/jdwppacket/MessageWriter;", "Lcom/android/jdwppacket/Writer;", "idSizes", "Lcom/android/jdwppacket/IDSizes;", "size", "", "<init>", "(Lcom/android/jdwppacket/IDSizes;I)V", "buffer", "Ljava/nio/ByteBuffer;", "start", "", "capacity", "finish", "putByte", "byte", "", "putInt", "int", "putShort", "short", "", "putLong", "long", "", "putID", "value", "putString", "s", "", "android.sdktools.jdwppacket"})
public final class MessageWriter
extends Writer {
    @NotNull
    private ByteBuffer buffer;

    public MessageWriter(@NotNull IDSizes idSizes, int size) {
        Intrinsics.checkNotNullParameter((Object)idSizes, (String)"idSizes");
        super(idSizes);
        ByteBuffer byteBuffer = ByteBuffer.allocate(size);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocate(...)");
        this.buffer = byteBuffer;
    }

    public final void start(int capacity) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(capacity);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocate(...)");
        this.buffer = byteBuffer;
    }

    @NotNull
    public final ByteBuffer finish() {
        this.buffer.clear();
        return this.buffer;
    }

    @Override
    public void putByte(byte by) {
        this.buffer.put(by);
    }

    @Override
    public void putInt(int n) {
        this.buffer.putInt(n);
    }

    @Override
    public void putShort(short s) {
        this.buffer.putShort(s);
    }

    @Override
    public void putLong(long l) {
        this.buffer.putLong(l);
    }

    @Override
    public void putID(int size, long value) {
        switch (size) {
            case 1: {
                ByteBuffer byteBuffer = this.buffer.put((byte)value);
                break;
            }
            case 2: {
                ByteBuffer byteBuffer = this.buffer.putShort((short)value);
                break;
            }
            case 4: {
                ByteBuffer byteBuffer = this.buffer.putInt((int)value);
                break;
            }
            case 8: {
                ByteBuffer byteBuffer = this.buffer.putLong(value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported id size: " + size);
            }
        }
    }

    @Override
    public void putString(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        String string2 = s;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] array = byArray;
        this.buffer.putInt(s.length());
        this.buffer.put(array);
    }
}

