/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwppacket.threadreference;

import com.android.jdwppacket.Cmd;
import com.android.jdwppacket.MessageReader;
import com.android.jdwppacket.ThreadReference;
import com.android.jdwppacket.Writer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001f"}, d2={"Lcom/android/jdwppacket/threadreference/FramesCmd;", "Lcom/android/jdwppacket/Cmd;", "threadID", "", "startFrame", "", "length", "<init>", "(JII)V", "getThreadID", "()J", "getStartFrame", "()I", "getLength", "paramsKey", "", "writePayload", "", "writer", "Lcom/android/jdwppacket/Writer;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "Companion", "android.sdktools.jdwppacket"})
public final class FramesCmd
extends Cmd {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long threadID;
    private final int startFrame;
    private final int length;

    public FramesCmd(long threadID, int startFrame, int length) {
        super(ThreadReference.Frames);
        this.threadID = threadID;
        this.startFrame = startFrame;
        this.length = length;
    }

    public final long getThreadID() {
        return this.threadID;
    }

    public final int getStartFrame() {
        return this.startFrame;
    }

    public final int getLength() {
        return this.length;
    }

    @Override
    @NotNull
    protected String paramsKey() {
        return "" + this.threadID + '-' + this.startFrame + '-' + this.length;
    }

    @Override
    protected void writePayload(@NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.putThreadID(this.threadID);
        writer.putInt(this.startFrame);
        writer.putInt(this.length);
    }

    public final long component1() {
        return this.threadID;
    }

    public final int component2() {
        return this.startFrame;
    }

    public final int component3() {
        return this.length;
    }

    @NotNull
    public final FramesCmd copy(long threadID, int startFrame, int length) {
        return new FramesCmd(threadID, startFrame, length);
    }

    public static /* synthetic */ FramesCmd copy$default(FramesCmd framesCmd, long l, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            l = framesCmd.threadID;
        }
        if ((n3 & 2) != 0) {
            n = framesCmd.startFrame;
        }
        if ((n3 & 4) != 0) {
            n2 = framesCmd.length;
        }
        return framesCmd.copy(l, n, n2);
    }

    @NotNull
    public String toString() {
        return "FramesCmd(threadID=" + this.threadID + ", startFrame=" + this.startFrame + ", length=" + this.length + ')';
    }

    public int hashCode() {
        int result2 = Long.hashCode(this.threadID);
        result2 = result2 * 31 + Integer.hashCode(this.startFrame);
        result2 = result2 * 31 + Integer.hashCode(this.length);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FramesCmd)) {
            return false;
        }
        FramesCmd framesCmd = (FramesCmd)other;
        if (this.threadID != framesCmd.threadID) {
            return false;
        }
        if (this.startFrame != framesCmd.startFrame) {
            return false;
        }
        return this.length == framesCmd.length;
    }

    @JvmStatic
    @NotNull
    public static final FramesCmd parse(@NotNull MessageReader reader) {
        return Companion.parse(reader);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/android/jdwppacket/threadreference/FramesCmd$Companion;", "", "<init>", "()V", "parse", "Lcom/android/jdwppacket/threadreference/FramesCmd;", "reader", "Lcom/android/jdwppacket/MessageReader;", "android.sdktools.jdwppacket"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final FramesCmd parse(@NotNull MessageReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            return new FramesCmd(reader.getThreadID(), reader.getInt(), reader.getInt());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

