/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwpscache;

import com.android.jdwppacket.CmdSet;
import com.android.jdwppacket.Event;
import com.android.jdwppacket.IDSizes;
import com.android.jdwppacket.MessageReader;
import com.android.jdwppacket.PacketHeader;
import com.android.jdwppacket.VirtualMachine;
import com.android.jdwppacket.event.CompositeCmd;
import com.android.jdwppacket.vm.IDSizesReply;
import com.android.jdwpscache.Handler;
import com.android.jdwpscache.SCacheLogger;
import com.android.jdwpscache.SCacheResponse;
import com.android.jdwpscache.Speculator;
import com.android.jdwpscache.TriggerManager;
import com.android.jdwpscache.UtilsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0019\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0014H\u0002J\b\u0010#\u001a\u00020\u001cH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/jdwpscache/SCache;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "enabled", "", "logger", "Lcom/android/jdwpscache/SCacheLogger;", "<init>", "(ZLcom/android/jdwpscache/SCacheLogger;)V", "getEnabled$android_sdktools_jdwpscache", "()Z", "setEnabled$android_sdktools_jdwpscache", "(Z)V", "triggerManager", "Lcom/android/jdwpscache/TriggerManager;", "speculator", "Lcom/android/jdwpscache/Speculator;", "idSizes", "Lcom/android/jdwppacket/IDSizes;", "onUpstreamPacket", "Lcom/android/jdwpscache/SCacheResponse;", "packet", "Ljava/nio/ByteBuffer;", "onUpstreamPacketSafe", "originalPacket", "onDownstreamPacket", "onDownstreamPacketSafe", "onEvent", "", "event", "Lcom/android/jdwppacket/event/CompositeCmd;", "onIDSizesReply", "reader", "Lcom/android/jdwppacket/MessageReader;", "response", "close", "android.sdktools.jdwpscache"})
public final class SCache
implements AutoCloseable {
    private boolean enabled;
    @NotNull
    private final SCacheLogger logger;
    @NotNull
    private final TriggerManager triggerManager;
    @NotNull
    private Speculator speculator;
    @NotNull
    private IDSizes idSizes;

    public SCache(boolean enabled, @NotNull SCacheLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.enabled = enabled;
        this.logger = logger;
        this.triggerManager = new TriggerManager();
        this.speculator = new Speculator(this.triggerManager, this.logger);
        this.idSizes = new IDSizes(0, 0, 0, 0, 0, 31, null);
        this.logger.info("scache status is " + (this.enabled ? "enabled" : "disabled"));
        this.triggerManager.registerReplyTrigger$android_sdktools_jdwpscache(CmdSet.Vm.getId(), VirtualMachine.IDSizes.getId(), new Handler(){

            @Override
            public void handle(MessageReader reader, SCacheResponse response) {
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                this.onIDSizesReply(reader, response);
            }
        });
    }

    public /* synthetic */ SCache(boolean bl, SCacheLogger sCacheLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl, sCacheLogger);
    }

    public final boolean getEnabled$android_sdktools_jdwpscache() {
        return this.enabled;
    }

    public final void setEnabled$android_sdktools_jdwpscache(boolean bl) {
        this.enabled = bl;
    }

    @NotNull
    public final SCacheResponse onUpstreamPacket(@NotNull ByteBuffer packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        try {
            return this.onUpstreamPacketSafe(packet);
        }
        catch (Exception e) {
            this.enabled = false;
            this.logger.error("SCache onUpstream error", e);
            SCacheResponse response = new SCacheResponse();
            response.addToUpstream(packet);
            return response;
        }
    }

    private final SCacheResponse onUpstreamPacketSafe(ByteBuffer originalPacket) {
        SCacheResponse response = new SCacheResponse();
        if (!this.enabled) {
            response.addToUpstream(originalPacket);
            return response;
        }
        ByteBuffer packet = originalPacket.duplicate();
        Intrinsics.checkNotNull((Object)packet);
        MessageReader reader = new MessageReader(this.idSizes, packet);
        PacketHeader header = new PacketHeader(reader);
        this.triggerManager.handle$android_sdktools_jdwpscache(header, reader.duplicate(), response);
        if (header.isReply()) {
            this.logger.warn("Replying to VM?? With (" + Integer.toHexString(header.getId()) + ')');
            response.addToUpstream(originalPacket);
            return response;
        }
        ByteBuffer speculatedReply = this.speculator.getCachedReply$android_sdktools_jdwpscache(header, reader.duplicate());
        if (speculatedReply != null) {
            ByteBuffer reply = UtilsKt.retag(speculatedReply, header.getId());
            response.addToDownstream(reply);
            response.addToUpstreamJournal$android_sdktools_jdwpscache(originalPacket);
            this.onDownstreamPacket(reply);
            return response;
        }
        response.addToUpstream(originalPacket);
        return response;
    }

    @NotNull
    public final SCacheResponse onDownstreamPacket(@NotNull ByteBuffer packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        try {
            return this.onDownstreamPacketSafe(packet);
        }
        catch (Exception e) {
            this.enabled = false;
            this.logger.error("SCache onDownstream error", e);
            SCacheResponse response = new SCacheResponse();
            response.addToDownstream(packet);
            return response;
        }
    }

    private final SCacheResponse onDownstreamPacketSafe(ByteBuffer originalPacket) {
        SCacheResponse response = new SCacheResponse();
        if (!this.enabled) {
            response.addToDownstream(originalPacket);
            return response;
        }
        ByteBuffer packet = originalPacket.duplicate();
        Intrinsics.checkNotNull((Object)packet);
        MessageReader reader = new MessageReader(this.idSizes, packet);
        PacketHeader header = new PacketHeader(reader);
        if (header.isCmd()) {
            response.addToDownstream(originalPacket);
            if (header.isA(CmdSet.Event.getId(), Event.Composite.getId())) {
                this.onEvent(CompositeCmd.Companion.parse(reader));
            }
            return response;
        }
        if (this.speculator.isSyntheticReply$android_sdktools_jdwpscache(header)) {
            this.speculator.handleSyntheticReply$android_sdktools_jdwpscache(header, packet);
            response.addToDownstreamJournal$android_sdktools_jdwpscache(originalPacket);
            return response;
        }
        if (header.getError() != 0) {
            response.addToDownstream(originalPacket);
            return response;
        }
        this.triggerManager.handle$android_sdktools_jdwpscache(header, reader.duplicate(), response);
        response.addToDownstream(originalPacket);
        return response;
    }

    private final void onEvent(CompositeCmd event) {
        this.speculator.onEvent(event);
    }

    private final void onIDSizesReply(MessageReader reader, SCacheResponse response) {
        IDSizesReply s = IDSizesReply.Companion.parse(reader);
        this.idSizes = new IDSizes(s.getFieldIDSize(), s.getMethodIDSize(), s.getObjectIDSize(), s.getReferenceTypeIDSize(), s.getFrameIDSize());
    }

    @Override
    public void close() {
        this.speculator.invalidateCache();
    }
}

