/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwppacket.MessageReader;
import com.android.jdwppacket.stackframe.GetValuesCmd;
import com.android.jdwppacket.stackframe.GetValuesReply;
import com.android.jdwptracer.CmdSet;
import com.android.jdwptracer.Message;
import com.android.jdwptracer.Session;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class CmdSetStackFrame
extends CmdSet {
    protected CmdSetStackFrame() {
        super(16, "STACK_FRAME");
        this.add(1, "GetValues", CmdSetStackFrame::parseGetValuesCmd, CmdSetStackFrame::parseGetValuesReply);
        this.add(2, "SetValues");
        this.add(3, "ThisObject");
        this.add(4, "PopFrames");
    }

    private static Message parseGetValuesCmd(MessageReader reader, Session session2) {
        Message message = new Message(reader);
        GetValuesCmd reply = GetValuesCmd.parse(reader);
        message.addArg("threadID", reply.getThreadID());
        message.addArg("frameID", reply.getFrameID());
        JsonArray slots = new JsonArray();
        for (GetValuesCmd.Slot slot : reply.getSlots()) {
            JsonObject slotEntry = new JsonObject();
            slotEntry.addProperty("slot", (Number)slot.getSlot());
            slotEntry.addProperty("sigbyte", (Number)slot.getSibByte());
            slots.add((JsonElement)slotEntry);
        }
        message.addArg("slots", (JsonElement)slots);
        return message;
    }

    private static Message parseGetValuesReply(MessageReader reader, Session session2) {
        Message message = new Message(reader);
        GetValuesReply reply = GetValuesReply.parse(reader);
        message.addArg("values", reply.getNumValues());
        return message;
    }
}

