/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwppacket.MessageReader;
import com.android.jdwptracer.Session;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

class Message {
    private final JsonObject args = new JsonObject();
    private String name = "";
    private final int payloadLength;

    Message(MessageReader reader) {
        this.payloadLength = reader.remaining();
    }

    String name() {
        return this.name;
    }

    int payloadLength() {
        return this.payloadLength;
    }

    void setName(String name) {
        this.name = name;
    }

    void addArg(String key, String value) {
        this.addArg(key, (JsonElement)new JsonPrimitive(value));
    }

    void addArg(String key, Number value) {
        this.addArg(key, (JsonElement)new JsonPrimitive(value));
    }

    void addArg(String key, JsonElement value) {
        this.args.add(key, value);
    }

    JsonObject args() {
        return this.args;
    }

    public void prefixName(String prefix) {
        this.name = prefix + this.name;
    }

    static Message defaultMessageParser(MessageReader reader, Session unused) {
        return new Message(reader);
    }
}

