/*
 * Decompiled with CFR 0.152.
 */
package com.android.processmonitor.common;

import com.android.processmonitor.common.ProcessEventKt;
import com.android.processmonitor.monitor.ProcessNames;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\b\tB\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Lcom/android/processmonitor/common/ProcessEvent;", "", "pid", "", "<init>", "(I)V", "getPid", "()I", "ProcessAdded", "ProcessRemoved", "Lcom/android/processmonitor/common/ProcessEvent$ProcessAdded;", "Lcom/android/processmonitor/common/ProcessEvent$ProcessRemoved;", "android.sdktools.process-monitor"})
public abstract sealed class ProcessEvent {
    private final int pid;

    private ProcessEvent(int pid) {
        this.pid = pid;
    }

    public int getPid() {
        return this.pid;
    }

    public /* synthetic */ ProcessEvent(int pid, DefaultConstructorMarker $constructor_marker) {
        this(pid);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J)\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/android/processmonitor/common/ProcessEvent$ProcessAdded;", "Lcom/android/processmonitor/common/ProcessEvent;", "pid", "", "applicationId", "", "processName", "<init>", "(ILjava/lang/String;Ljava/lang/String;)V", "getPid", "()I", "getApplicationId", "()Ljava/lang/String;", "getProcessName", "toProcessNames", "Lcom/android/processmonitor/monitor/ProcessNames;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "android.sdktools.process-monitor"})
    public static final class ProcessAdded
    extends ProcessEvent {
        private final int pid;
        @Nullable
        private final String applicationId;
        @NotNull
        private final String processName;

        public ProcessAdded(int pid, @Nullable String applicationId, @NotNull String processName) {
            Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
            super(pid, null);
            this.pid = pid;
            this.applicationId = applicationId;
            this.processName = processName;
        }

        @Override
        public int getPid() {
            return this.pid;
        }

        @Nullable
        public final String getApplicationId() {
            return this.applicationId;
        }

        @NotNull
        public final String getProcessName() {
            return this.processName;
        }

        @NotNull
        public final ProcessNames toProcessNames() {
            String string2 = this.applicationId;
            if (string2 == null) {
                string2 = ProcessEventKt.access$toPackageName(this.processName);
            }
            return new ProcessNames(string2, this.processName);
        }

        public final int component1() {
            return this.pid;
        }

        @Nullable
        public final String component2() {
            return this.applicationId;
        }

        @NotNull
        public final String component3() {
            return this.processName;
        }

        @NotNull
        public final ProcessAdded copy(int pid, @Nullable String applicationId, @NotNull String processName) {
            Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
            return new ProcessAdded(pid, applicationId, processName);
        }

        public static /* synthetic */ ProcessAdded copy$default(ProcessAdded processAdded, int n, String string2, String string3, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = processAdded.pid;
            }
            if ((n2 & 2) != 0) {
                string2 = processAdded.applicationId;
            }
            if ((n2 & 4) != 0) {
                string3 = processAdded.processName;
            }
            return processAdded.copy(n, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ProcessAdded(pid=" + this.pid + ", applicationId=" + this.applicationId + ", processName=" + this.processName + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.pid);
            result2 = result2 * 31 + (this.applicationId == null ? 0 : this.applicationId.hashCode());
            result2 = result2 * 31 + this.processName.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProcessAdded)) {
                return false;
            }
            ProcessAdded processAdded = (ProcessAdded)other;
            if (this.pid != processAdded.pid) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.applicationId, (Object)processAdded.applicationId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.processName, (Object)processAdded.processName);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/android/processmonitor/common/ProcessEvent$ProcessRemoved;", "Lcom/android/processmonitor/common/ProcessEvent;", "pid", "", "<init>", "(I)V", "getPid", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "android.sdktools.process-monitor"})
    public static final class ProcessRemoved
    extends ProcessEvent {
        private final int pid;

        public ProcessRemoved(int pid) {
            super(pid, null);
            this.pid = pid;
        }

        @Override
        public int getPid() {
            return this.pid;
        }

        public final int component1() {
            return this.pid;
        }

        @NotNull
        public final ProcessRemoved copy(int pid) {
            return new ProcessRemoved(pid);
        }

        public static /* synthetic */ ProcessRemoved copy$default(ProcessRemoved processRemoved, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = processRemoved.pid;
            }
            return processRemoved.copy(n);
        }

        @NotNull
        public String toString() {
            return "ProcessRemoved(pid=" + this.pid + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.pid);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProcessRemoved)) {
                return false;
            }
            ProcessRemoved processRemoved = (ProcessRemoved)other;
            return this.pid == processRemoved.pid;
        }
    }
}

