/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.base;

import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.resources.base.BasicValueResourceItemBase;
import com.android.resources.base.ResourceSourceFile;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class BasicArrayResourceItem
extends BasicValueResourceItemBase
implements ArrayResourceValue {
    private final List<String> myElements;
    private final int myDefaultIndex;

    public BasicArrayResourceItem(String name, ResourceSourceFile sourceFile, ResourceVisibility visibility, List<String> elements, int defaultIndex) {
        super(ResourceType.ARRAY, name, sourceFile, visibility);
        this.myElements = elements;
        assert (elements.isEmpty() || defaultIndex < elements.size());
        this.myDefaultIndex = defaultIndex;
    }

    public int getElementCount() {
        return this.myElements.size();
    }

    public String getElement(int index2) {
        return this.myElements.get(index2);
    }

    public Iterator<String> iterator() {
        return this.myElements.iterator();
    }

    @Override
    public String getValue() {
        return this.myElements.isEmpty() ? null : this.myElements.get(this.myDefaultIndex);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BasicArrayResourceItem other = (BasicArrayResourceItem)obj;
        return this.myElements.equals(other.myElements);
    }

    @Override
    public void serialize(Base128OutputStream stream, Object2IntMap<String> configIndexes, Object2IntMap<ResourceSourceFile> sourceFileIndexes, Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        stream.writeInt(this.myElements.size());
        for (String element : this.myElements) {
            stream.writeString(element);
        }
        stream.writeInt(this.myDefaultIndex);
    }

    static BasicArrayResourceItem deserialize(Base128InputStream stream, String name, ResourceVisibility visibility, ResourceSourceFile sourceFile, ResourceNamespace.Resolver resolver) throws IOException {
        int n = stream.readInt();
        ArrayList<String> elements = n == 0 ? Collections.emptyList() : new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            elements.add(stream.readString());
        }
        int defaultIndex = stream.readInt();
        if (!elements.isEmpty() && defaultIndex >= elements.size()) {
            throw Base128InputStream.StreamFormatException.invalidFormat();
        }
        BasicArrayResourceItem item = new BasicArrayResourceItem(name, sourceFile, visibility, elements, defaultIndex);
        item.setNamespaceResolver(resolver);
        return item;
    }
}

