/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.base;

import com.android.ide.common.rendering.api.PluralsResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.Arity;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.resources.base.BasicValueResourceItemBase;
import com.android.resources.base.ResourceSourceFile;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public final class BasicPluralsResourceItem
extends BasicValueResourceItemBase
implements PluralsResourceValue {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Arity[] myArities;
    private final String[] myValues;
    private final int myDefaultIndex;

    public BasicPluralsResourceItem(String name, ResourceSourceFile sourceFile, ResourceVisibility visibility, Map<Arity, String> quantityValues, Arity defaultArity) {
        this(name, sourceFile, visibility, quantityValues.keySet().toArray(Arity.EMPTY_ARRAY), quantityValues.values().toArray(EMPTY_STRING_ARRAY), BasicPluralsResourceItem.getIndex(defaultArity, quantityValues.keySet()));
    }

    private BasicPluralsResourceItem(String name, ResourceSourceFile sourceFile, ResourceVisibility visibility, Arity[] arities, String[] values, int defaultIndex) {
        super(ResourceType.PLURALS, name, sourceFile, visibility);
        assert (arities.length == values.length);
        this.myArities = arities;
        this.myValues = values;
        assert (values.length == 0 || defaultIndex < values.length);
        this.myDefaultIndex = defaultIndex;
    }

    private static int getIndex(Arity arity, Collection<Arity> arities) {
        if (arity == null || arities.isEmpty()) {
            return 0;
        }
        int index2 = 0;
        for (Arity ar : arities) {
            if (ar == arity) {
                return index2;
            }
            ++index2;
        }
        throw new IllegalArgumentException();
    }

    public int getPluralsCount() {
        return this.myArities.length;
    }

    public String getQuantity(int index2) {
        return this.myArities[index2].getName();
    }

    public String getValue(int index2) {
        return this.myValues[index2];
    }

    public String getValue(String quantity) {
        int n = this.myArities.length;
        for (int i = 0; i < n; ++i) {
            if (!quantity.equals(this.myArities[i].getName())) continue;
            return this.myValues[i];
        }
        return null;
    }

    @Override
    public String getValue() {
        return this.myValues.length == 0 ? null : this.myValues[this.myDefaultIndex];
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BasicPluralsResourceItem other = (BasicPluralsResourceItem)obj;
        return Arrays.equals(this.myArities, other.myArities) && Arrays.equals(this.myValues, other.myValues);
    }

    @Override
    public void serialize(Base128OutputStream stream, Object2IntMap<String> configIndexes, Object2IntMap<ResourceSourceFile> sourceFileIndexes, Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        int n = this.myArities.length;
        stream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            stream.writeInt(this.myArities[i].ordinal());
            stream.writeString(this.myValues[i]);
        }
        stream.writeInt(this.myDefaultIndex);
    }

    static BasicPluralsResourceItem deserialize(Base128InputStream stream, String name, ResourceVisibility visibility, ResourceSourceFile sourceFile, ResourceNamespace.Resolver resolver) throws IOException {
        int n = stream.readInt();
        Arity[] arities = n == 0 ? Arity.EMPTY_ARRAY : new Arity[n];
        String[] values = n == 0 ? EMPTY_STRING_ARRAY : new String[n];
        for (int i = 0; i < n; ++i) {
            arities[i] = Arity.values()[stream.readInt()];
            values[i] = stream.readString();
        }
        int defaultIndex = stream.readInt();
        if (values.length != 0 && defaultIndex >= values.length) {
            throw Base128InputStream.StreamFormatException.invalidFormat();
        }
        BasicPluralsResourceItem item = new BasicPluralsResourceItem(name, sourceFile, visibility, arities, values, defaultIndex);
        item.setNamespaceResolver(resolver);
        return item;
    }
}

