/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.base;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.resources.base.BasicResourceItem;
import com.android.resources.base.BasicValueResourceItemBase;
import com.android.resources.base.LoadableResourceRepository;
import com.android.resources.base.RepositoryConfiguration;
import com.android.resources.base.ResourceSourceFile;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import com.android.utils.HashCodes;
import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.List;

public abstract class BasicResourceItemBase
implements BasicResourceItem {
    private final String myName;
    private final byte myTypeOrdinal;
    private final byte myVisibilityOrdinal;

    BasicResourceItemBase(ResourceType type, String name, ResourceVisibility visibility) {
        this.myName = name;
        this.myTypeOrdinal = (byte)type.ordinal();
        this.myVisibilityOrdinal = (byte)visibility.ordinal();
    }

    public final ResourceType getType() {
        return this.getResourceType();
    }

    public ResourceNamespace getNamespace() {
        return this.getRepository().getNamespace();
    }

    public final String getName() {
        return this.myName;
    }

    public final String getLibraryName() {
        return this.getRepository().getLibraryName();
    }

    public final ResourceType getResourceType() {
        return ResourceType.values()[this.myTypeOrdinal];
    }

    public final ResourceVisibility getVisibility() {
        return ResourceVisibility.values()[this.myVisibilityOrdinal];
    }

    public final ResourceValue getResourceValue() {
        return this;
    }

    public final boolean isUserDefined() {
        return this.getRepository().containsUserDefinedResources();
    }

    public final ResourceReference asReference() {
        return this.getReferenceToSelf();
    }

    public final LoadableResourceRepository getRepository() {
        return this.getRepositoryConfiguration().getRepository();
    }

    public final FolderConfiguration getConfiguration() {
        return this.getRepositoryConfiguration().getFolderConfiguration();
    }

    public abstract RepositoryConfiguration getRepositoryConfiguration();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BasicResourceItemBase other = (BasicResourceItemBase)obj;
        return this.myTypeOrdinal == other.myTypeOrdinal && this.myName.equals(other.myName) && this.myVisibilityOrdinal == other.myVisibilityOrdinal;
    }

    public int hashCode() {
        return HashCodes.mix((int)this.myTypeOrdinal, (int)this.myName.hashCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("namespace", (Object)this.getNamespace()).add("type", (Object)this.getResourceType()).add("name", (Object)this.getName()).add("value", (Object)this.getValue()).toString();
    }

    public void serialize(Base128OutputStream stream, Object2IntMap<String> configIndexes, Object2IntMap<ResourceSourceFile> sourceFileIndexes, Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        stream.writeInt((this.myTypeOrdinal << 1) + (this.isFileBased() ? 1 : 0));
        stream.writeString(this.myName);
        stream.writeInt((int)this.myVisibilityOrdinal);
    }

    public static BasicResourceItemBase deserialize(Base128InputStream stream, List<RepositoryConfiguration> configurations, List<ResourceSourceFile> sourceFiles, List<ResourceNamespace.Resolver> namespaceResolvers) throws IOException {
        assert (!configurations.isEmpty());
        int encodedType = stream.readInt();
        boolean isFileBased = (encodedType & 1) != 0;
        ResourceType resourceType = ResourceType.values()[encodedType >>> 1];
        String name = stream.readString();
        if (name == null) {
            throw Base128InputStream.StreamFormatException.invalidFormat();
        }
        ResourceVisibility visibility = ResourceVisibility.values()[stream.readInt()];
        if (isFileBased) {
            LoadableResourceRepository repository2 = configurations.get(0).getRepository();
            return repository2.deserializeFileResourceItem(stream, resourceType, name, visibility, configurations);
        }
        return BasicValueResourceItemBase.deserialize(stream, resourceType, name, visibility, configurations, sourceFiles, namespaceResolvers);
    }
}

