/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer;

import java.util.Locale;
import java.util.function.Predicate;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class FilteredTreeModel<T>
extends DefaultTreeModel {
    private final Predicate<T> predicate;

    public FilteredTreeModel(@NotNull TreeNode treeNode, @NotNull Predicate<T> predicate) {
        super(treeNode);
        this.predicate = predicate;
    }

    @Override
    public Object getChild(Object parent, int index2) {
        int n = super.getChildCount(parent);
        for (int i = 0; i < n; ++i) {
            Object result2 = super.getChild(parent, i);
            if (!this.predicate.test(result2)) continue;
            if (index2 == 0) {
                return result2;
            }
            --index2;
        }
        String msg = String.format(Locale.US, "Child index %1$d is higher than # of children %2$d", index2, this.getChildCount(parent));
        throw new IllegalStateException(msg);
    }

    @Override
    public int getChildCount(Object parent) {
        int count = 0;
        int n = super.getChildCount(parent);
        for (int i = 0; i < n; ++i) {
            Object result2 = super.getChild(parent, i);
            if (!this.predicate.test(result2)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int index2 = 0;
        int n = super.getChildCount(parent);
        for (int i = 0; i < n; ++i) {
            Object result2 = super.getChild(parent, i);
            if (!this.predicate.test(result2)) continue;
            if (result2.equals(child)) {
                return index2;
            }
            ++index2;
        }
        return -1;
    }
}

