/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.leakcanarylib.parser;

import com.android.tools.leakcanarylib.data.ReferencingField;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/leakcanarylib/parser/ReferencingFieldParser;", "", "<init>", "()V", "Companion", "android.sdktools.leakcanarylib"})
public final class ReferencingFieldParser {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\bH\u0002\u00a8\u0006\f"}, d2={"Lcom/android/tools/leakcanarylib/parser/ReferencingFieldParser$Companion;", "", "<init>", "()V", "parseReferencingField", "Lcom/android/tools/leakcanarylib/data/ReferencingField;", "referenceLines", "", "", "additionalLinesPrefix", "parseReferencePath", "referencePathLine", "android.sdktools.leakcanarylib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReferencingField parseReferencingField(@NotNull List<String> referenceLines, @NotNull String additionalLinesPrefix) {
            Intrinsics.checkNotNullParameter(referenceLines, (String)"referenceLines");
            Intrinsics.checkNotNullParameter((Object)additionalLinesPrefix, (String)"additionalLinesPrefix");
            if (referenceLines.isEmpty()) {
                throw new IllegalArgumentException("Reference lines cannot be empty");
            }
            List<String> referenceTypeAndDisplayName = this.parseReferencePath(StringsKt.removePrefix((String)referenceLines.get(0), (CharSequence)additionalLinesPrefix));
            ReferencingField.ReferencingFieldType referenceType = ReferencingField.ReferencingFieldType.valueOf(referenceTypeAndDisplayName.get(0));
            String referenceDisplayName = referenceTypeAndDisplayName.get(1);
            String owningClassName = referenceTypeAndDisplayName.get(2);
            String string2 = (String)CollectionsKt.getOrNull(referenceLines, (int)1);
            boolean isPrimeSuspect = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"~", (boolean)false, (int)2, null) : false;
            return new ReferencingField(owningClassName, referenceType, isPrimeSuspect, referenceDisplayName);
        }

        private final List<String> parseReferencePath(String referencePathLine) {
            String referenceType = "";
            String owningClassSimpleName = "";
            String referenceDisplayName = "";
            int referencePathLineStartingIndex = StringsKt.indexOf$default((CharSequence)referencePathLine, (String)"\u2193", (int)0, (boolean)false, (int)6, null) + 1;
            String string2 = referencePathLine.substring(referencePathLineStartingIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String referencePathLineTrimmed = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            if (StringsKt.startsWith$default((String)referencePathLineTrimmed, (String)"static", (boolean)false, (int)2, null)) {
                referenceType = "STATIC_FIELD";
                String[] stringArray = new String[]{"."};
                parts = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)referencePathLineTrimmed, (CharSequence)"static"), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                owningClassSimpleName = ((Object)StringsKt.trim((CharSequence)((String)parts.get(0)))).toString();
                referenceDisplayName = ((Object)StringsKt.trim((CharSequence)((String)parts.get(1)))).toString();
            } else if (StringsKt.contains$default((CharSequence)referencePathLineTrimmed, (CharSequence)"[", (boolean)false, (int)2, null)) {
                referenceType = "ARRAY_ENTRY";
                int arrayIndex = StringsKt.indexOf$default((CharSequence)referencePathLineTrimmed, (String)"[", (int)0, (boolean)false, (int)6, null);
                int arrayEndIndex = StringsKt.indexOf$default((CharSequence)referencePathLineTrimmed, (String)"]", (int)0, (boolean)false, (int)6, null);
                String string3 = referencePathLineTrimmed.substring(0, arrayIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                owningClassSimpleName = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                String string4 = referencePathLineTrimmed.substring(arrayIndex + 1, arrayEndIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                referenceDisplayName = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            } else if (StringsKt.contains$default((CharSequence)referencePathLineTrimmed, (CharSequence)"<Java Local>", (boolean)false, (int)2, null)) {
                referenceType = "LOCAL";
                referenceDisplayName = "<Java Local>";
                owningClassSimpleName = ((Object)StringsKt.trim((CharSequence)StringsKt.removeSuffix((String)referencePathLineTrimmed, (CharSequence)"<Java Local>"))).toString();
            } else {
                referenceType = "INSTANCE_FIELD";
                String[] stringArray = new String[]{"."};
                parts = StringsKt.split$default((CharSequence)referencePathLineTrimmed, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                owningClassSimpleName = ((Object)StringsKt.trim((CharSequence)((String)parts.get(0)))).toString();
                referenceDisplayName = ((Object)StringsKt.trim((CharSequence)((String)parts.get(1)))).toString();
            }
            Object[] objectArray = new String[]{referenceType, referenceDisplayName, owningClassSimpleName};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

