/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.XmlUtils;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u00012\u00020\u0002:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/C2dmDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "<init>", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "android.sdktools.lint-checks"})
public final class C2dmDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(C2dmDetector.class, Scope.MANIFEST_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @Override
    @NotNull
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"receiver");
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
        if (attr == null) {
            return;
        }
        Attr attribute = attr;
        String receiverName = attribute.getValue();
        if (!Intrinsics.areEqual((Object)receiverName, (Object)"com.google.android.c2dm.C2DMBroadcastReceiver") && !Intrinsics.areEqual((Object)receiverName, (Object)"com.google.android.gcm.GCMBroadcastReceiver")) {
            return;
        }
        boolean haveReceive = false;
        boolean haveRegistration = false;
        Element intentFilter = XmlUtils.getFirstSubTagByName((Node)element, (String)"intent-filter");
        while (intentFilter != null) {
            Element action = XmlUtils.getFirstSubTagByName((Node)intentFilter, (String)"action");
            while (action != null) {
                String actionName = action.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                if (Intrinsics.areEqual((Object)actionName, (Object)"com.google.android.c2dm.intent.RECEIVE")) {
                    haveReceive = true;
                } else if (Intrinsics.areEqual((Object)actionName, (Object)"com.google.android.c2dm.intent.REGISTRATION")) {
                    haveRegistration = true;
                }
                action = XmlUtils.getNextTagByName((Node)action, (String)"action");
            }
            intentFilter = XmlUtils.getNextTagByName((Node)intentFilter, (String)"intent-filter");
        }
        if (haveReceive && haveRegistration) {
            String message = "The C2DM library does not work on Android P or newer devices; you should migrate to Firebase Cloud Messaging to ensure reliable message delivery";
            XmlContext.report$default(context2, ISSUE, attribute, context2.getValueLocation(attribute), message, null, 16, null);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.SECURITY;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default(companion, "UsingC2DM", "Using C2DM", "\n                The C2DM library does not work on Android P or newer devices; \\\n                you should migrate to Firebase Cloud Messaging to ensure reliable message delivery.\n                ", implementation, "https://developers.google.com/cloud-messaging/c2dm", category, 8, severity, false, null, null, null, 3840, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/C2dmDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

