/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.LintMapUtilsKt;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCatchClause;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UTypeReferenceExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00110\u0006H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0016H\u0016\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/checks/CredentialManagerMisuseDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "getApplicableUastTypes", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "checkPartialResults", "Lcom/android/tools/lint/detector/api/Context;", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "afterCheckRootProject", "Companion", "android.sdktools.lint-checks"})
@SourceDebugExtension(value={"SMAP\nCredentialManagerMisuseDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CredentialManagerMisuseDetector.kt\ncom/android/tools/lint/checks/CredentialManagerMisuseDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1761#2,3:163\n1617#2,9:166\n1869#2:175\n1870#2:177\n1626#2:178\n1387#2:179\n1475#2,5:180\n1#3:176\n*S KotlinDebug\n*F\n+ 1 CredentialManagerMisuseDetector.kt\ncom/android/tools/lint/checks/CredentialManagerMisuseDetector\n*L\n106#1:163,3\n115#1:166,9\n115#1:175\n115#1:177\n115#1:178\n117#1:179\n117#1:180,5\n115#1:176\n*E\n"})
public final class CredentialManagerMisuseDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String KEY_GET_CREDENTIAL_CALLS = "GET_CREDENTIAL_CALLS";
    @NotNull
    private static final String KEY_SAW_NO_CREDENTIAL_EXCEPTION = "SAW_NO_CREDENTIAL_EXCEPTION";
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(CredentialManagerMisuseDetector.class, EnumSet.of((Enum)Scope.ALL_JAVA_FILES));
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"getCredential", "getCredentialAsync"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClass cls = psiClass;
        if (!context2.getEvaluator().implementsInterface(cls, "androidx.credentials.CredentialManager", false)) {
            return;
        }
        if (context2.getDriver().isSuppressed(context2, ISSUE, (UElement)node)) {
            return;
        }
        LintMapUtilsKt.appendLocation(LintMapUtilsKt.getOrPutLintMap(context2.getPartialResults(ISSUE).map(), KEY_GET_CREDENTIAL_CALLS), context2.getLocation((UElement)node));
    }

    @Override
    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UCatchClause.class, UTypeReferenceExpression.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new UElementHandler(context2){
            final /* synthetic */ JavaContext $context;
            {
                this.$context = $context;
            }

            private final void storeSawNoCredentialException() {
                this.$context.getPartialResults(CredentialManagerMisuseDetector.ISSUE).map().put("SAW_NO_CREDENTIAL_EXCEPTION", true);
            }

            public void visitCatchClause(UCatchClause node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                for (UTypeReferenceExpression typeReference : node.getTypeReferences()) {
                    if (!Intrinsics.areEqual((Object)typeReference.getType().getCanonicalText(), (Object)"androidx.credentials.exceptions.NoCredentialException")) continue;
                    this.storeSawNoCredentialException();
                    break;
                }
            }

            public void visitTypeReferenceExpression(UTypeReferenceExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (Intrinsics.areEqual((Object)node.getType().getCanonicalText(), (Object)"androidx.credentials.exceptions.NoCredentialException")) {
                    this.storeSawNoCredentialException();
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void checkPartialResults(@NotNull Context context2, @NotNull PartialResult partialResults) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object element$iv2;
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)partialResults, (String)"partialResults");
            if (context2.getProject().isLibrary()) {
                return;
            }
            Iterable $this$any$iv = partialResults.maps();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    LintMap it = (LintMap)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)LintMap.getBoolean$default(it, KEY_SAW_NO_CREDENTIAL_EXCEPTION, null, 2, null), (Object)true)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        Iterable $i$f$any = partialResults.maps();
        boolean $i$f$mapNotNull = false;
        element$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            LintMap it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl3 = false;
            LintMap it = (LintMap)element$iv$iv;
            boolean bl4 = false;
            if (it.getMap(KEY_GET_CREDENTIAL_CALLS) == null) continue;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$flatMapSequence = false;
        $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            LintMap it = (LintMap)element$iv$iv;
            boolean bl6 = false;
            Sequence<Location> list$iv$iv = LintMapUtilsKt.asLocationSequence(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        List locations = (List)destination$iv$iv;
        for (Location location : locations) {
            Context.report$default(context2, ISSUE, location, "Call to `CredentialManager.getCredential` without use of `NoCredentialException`", null, 8, null);
        }
    }

    @Override
    public void afterCheckRootProject(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.isGlobalAnalysis()) {
            this.checkPartialResults(context2, context2.getPartialResults(ISSUE));
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default(companion, "CredentialManagerMisuse", "Misuse of Credential Manager API", "\n          When calling `CredentialManager.getCredential` or `CredentialManager.getCredentialAsync`, \\\n          you should handle `NoCredentialException` somewhere in your project.\n          ", implementation, "https://developer.android.com/identity/sign-in/credential-manager#handle-exceptions", category, 5, severity, false, true, null, null, 3328, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/CredentialManagerMisuseDetector$Companion;", "", "<init>", "()V", "KEY_GET_CREDENTIAL_CALLS", "", "KEY_SAW_NO_CREDENTIAL_EXCEPTION", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

