/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.GradleScanner;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004JJ\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/MissingResourcesPropertiesDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/GradleScanner;", "<init>", "()V", "checkDslPropertyAssignment", "", "context", "Lcom/android/tools/lint/detector/api/GradleContext;", "property", "", "value", "parent", "parentParent", "propertyCookie", "", "valueCookie", "statementCookie", "Companion", "android.sdktools.lint-checks"})
@SourceDebugExtension(value={"SMAP\nMissingResourcesPropertiesDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MissingResourcesPropertiesDetector.kt\ncom/android/tools/lint/checks/MissingResourcesPropertiesDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n2746#2,3:76\n*S KotlinDebug\n*F\n+ 1 MissingResourcesPropertiesDetector.kt\ncom/android/tools/lint/checks/MissingResourcesPropertiesDetector\n*L\n45#1:76,3\n*E\n"})
public final class MissingResourcesPropertiesDetector
extends Detector
implements GradleScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue ISSUE;

    @Override
    public void checkDslPropertyAssignment(@NotNull GradleContext context2, @NotNull String property, @NotNull String value, @NotNull String parent, @Nullable String parentParent, @NotNull Object propertyCookie, @NotNull Object valueCookie, @NotNull Object statementCookie) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)propertyCookie, (String)"propertyCookie");
        Intrinsics.checkNotNullParameter((Object)valueCookie, (String)"valueCookie");
        Intrinsics.checkNotNullParameter((Object)statementCookie, (String)"statementCookie");
        if (context2.getProject().isLibrary()) {
            return;
        }
        if (Intrinsics.areEqual((Object)property, (Object)"generateLocaleConfig") && Intrinsics.areEqual((Object)value, (Object)"true")) {
            boolean bl;
            block6: {
                List<File> list2 = context2.getProject().getResourceFolders();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getResourceFolders(...)");
                Iterable $this$none$iv = list2;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        File it = (File)element$iv;
                        boolean bl2 = false;
                        if (!new File(it, "resources.properties").exists()) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                Incident incident = new Incident(ISSUE, propertyCookie, context2.getLocation(propertyCookie), "Missing resources.properties file");
                LintClient.report$default(context2.getClient(), context2, incident, null, 4, null);
            }
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(MissingResourcesPropertiesDetector.class, Scope.GRADLE_SCOPE);
        ISSUE = Issue.Companion.create$default(companion, "MissingResourcesProperties", "Missing resources.properties file", "When `generateLocaleConfig` is turned on, the default locale must be specified in a resources.properties file.", implementation, "https://developer.android.com/r/studio-ui/build/automatic-per-app-languages", category, 2, severity, false, true, null, null, 3328, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/MissingResourcesPropertiesDetector$Companion;", "", "<init>", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

