/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPackage;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UReferenceExpression;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 32\u00020\u00012\u00020\u0002:\u00013B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016J0\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\tH\u0016J \u0010\u0014\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070\u001dH\u0016J\u0018\u0010#\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u0007H\u0002J\u0018\u0010(\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J \u0010)\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u001a\u0010)\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00152\b\u0010*\u001a\u0004\u0018\u00010+H\u0002J\u0018\u0010,\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020%H\u0002J\u0010\u0010.\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0015H\u0016J\u0010\u0010/\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0015H\u0002J \u00100\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J \u00101\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J \u00102\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/android/tools/lint/checks/PrivateResourceDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "overriding", "", "", "appliesToResourceRefs", "", "visitResourceReference", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UElement;", "type", "Lcom/android/resources/ResourceType;", "name", "isFramework", "filterIncident", "Lcom/android/tools/lint/detector/api/Context;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "referencedInMain", "resourceType", "getApplicableAttributes", "", "visitAttribute", "Lcom/android/tools/lint/detector/api/XmlContext;", "attribute", "Lorg/w3c/dom/Attr;", "getApplicableElements", "visitElement", "element", "Lorg/w3c/dom/Element;", "recordOverriding", "resourceName", "isOverriding", "isPrivate", "url", "Lcom/android/resources/ResourceUrl;", "checkChildRefs", "item", "beforeCheckFile", "hasOverride", "createOverrideErrorMessage", "createUsageErrorMessage", "getLibraryName", "Companion", "android.sdktools.lint-checks"})
@SourceDebugExtension(value={"SMAP\nPrivateResourceDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrivateResourceDetector.kt\ncom/android/tools/lint/checks/PrivateResourceDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,363:1\n1#2:364\n*E\n"})
public final class PrivateResourceDetector
extends ResourceXmlDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private List<String> overriding;
    @NotNull
    private static final String ATTR_OVERRIDE = "override";
    @NotNull
    private static final String KEY_URL = "url";
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @Override
    public boolean appliesToResourceRefs() {
        return true;
    }

    @Override
    public void visitResourceReference(@NotNull JavaContext context2, @NotNull UElement node, @NotNull ResourceType type, @NotNull String name, boolean isFramework) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!isFramework && this.isPrivate(context2, type, name)) {
            PsiPackage pkg;
            PsiElement resolved;
            boolean foreignPackage = false;
            boolean globalAnalysis = context2.isGlobalAnalysis();
            if (node instanceof UReferenceExpression && (resolved = ((UReferenceExpression)node).resolve()) instanceof PsiField && (pkg = context2.getEvaluator().getPackage(resolved)) != null) {
                String string2 = pkg.getQualifiedName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getQualifiedName(...)");
                String pkgName = string2;
                if (!(Intrinsics.areEqual((Object)pkgName, (Object)context2.getProject().getPackage()) || globalAnalysis && Intrinsics.areEqual((Object)pkgName, (Object)context2.getMainProject().getPackage()))) {
                    foreignPackage = true;
                }
            }
            if (!foreignPackage) {
                if (globalAnalysis && this.referencedInMain(context2, type, name)) {
                    return;
                }
                if (this.isOverriding(type, name)) {
                    return;
                }
            }
            String message = this.createUsageErrorMessage(context2, type, name);
            Incident incident = new Incident(ISSUE, node, context2.getLocation(node), message);
            if (globalAnalysis) {
                context2.report(incident);
            } else {
                context2.report(incident, this.map().put(KEY_URL, "@" + type + "/" + name));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean filterIncident(@NotNull Context context2, @NotNull Incident incident, @NotNull LintMap map2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
        String urlString = map2.getString(KEY_URL, null);
        if (urlString == null) return false;
        ResourceUrl url = ResourceUrl.parse((String)urlString);
        if (url == null) return false;
        ResourceType resourceType = url.type;
        Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"type");
        String string2 = url.name;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
        if (this.referencedInMain(context2, resourceType, string2)) return false;
        return true;
    }

    private final boolean referencedInMain(Context context2, ResourceType resourceType, String name) {
        LintClient client = context2.getClient();
        Project mainProject = context2.getMainProject();
        ResourceRepository repository2 = client.getResources(mainProject, ResourceRepositoryScope.LOCAL_DEPENDENCIES);
        return repository2.hasResources(ResourceNamespace.TODO(), resourceType, name);
    }

    @NotNull
    public List<String> getApplicableAttributes() {
        List list2 = ResourceXmlDetector.ALL;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ALL");
        return list2;
    }

    @Override
    public void visitAttribute(@NotNull XmlContext context2, @NotNull Attr attribute) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        String value = attribute.getNodeValue();
        ResourceUrl url = ResourceUrl.parse((String)value);
        if (this.isPrivate(context2, url)) {
            Context context3 = context2;
            ResourceUrl resourceUrl = url;
            Intrinsics.checkNotNull((Object)resourceUrl);
            ResourceType resourceType = resourceUrl.type;
            Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"type");
            String string2 = url.name;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
            String message = this.createUsageErrorMessage(context3, resourceType, string2);
            XmlContext.report$default(context2, ISSUE, attribute, context2.getValueLocation(attribute), message, null, 16, null);
        }
    }

    @NotNull
    public List<String> getApplicableElements() {
        Object[] objectArray = new String[]{"style", "resources", "array", "string-array", "integer-array", "plurals"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (Intrinsics.areEqual((Object)"resources", (Object)element.getTagName())) {
            for (Element item : XmlUtils.getSubTags((Node)element)) {
                Attr nameAttribute = item.getAttributeNode("name");
                if (nameAttribute == null) continue;
                String string2 = nameAttribute.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
                String name = ResourcesUtil.resourceNameToFieldName((String)string2);
                ResourceType resourceType = ResourceType.fromXmlTag((Node)item);
                if (resourceType == null || !this.isPrivate(context2, resourceType, name)) continue;
                this.recordOverriding(resourceType, name);
                if (Intrinsics.areEqual((Object)"true", (Object)item.getAttributeNS("http://schemas.android.com/tools", ATTR_OVERRIDE))) continue;
                String message = this.createOverrideErrorMessage(context2, resourceType, name);
                Location location = context2.getValueLocation(nameAttribute);
                XmlContext.report$default(context2, ISSUE, nameAttribute, location, message, null, 16, null);
            }
        } else {
            boolean bl;
            boolean bl2 = bl = Intrinsics.areEqual((Object)"style", (Object)element.getTagName()) || Intrinsics.areEqual((Object)"array", (Object)element.getTagName()) || Intrinsics.areEqual((Object)"plurals", (Object)element.getTagName()) || Intrinsics.areEqual((Object)"integer-array", (Object)element.getTagName()) || Intrinsics.areEqual((Object)"string-array", (Object)element.getTagName());
            if (_Assertions.ENABLED && !bl) {
                String item = "Assertion failed";
                throw new AssertionError((Object)item);
            }
            for (Element item : XmlUtils.getSubTags((Node)element)) {
                Intrinsics.checkNotNull((Object)item);
                this.checkChildRefs(context2, item);
            }
        }
    }

    private final void recordOverriding(ResourceType resourceType, String resourceName) {
        List list2 = this.overriding;
        if (list2 == null) {
            List list3;
            List it = list3 = (List)new ArrayList();
            boolean bl = false;
            this.overriding = it;
            list2 = list3;
        }
        List overriding = list2;
        overriding.add((String)(resourceType.getName() + ":" + resourceName));
    }

    private final boolean isOverriding(ResourceType type, String name) {
        List<String> list2 = this.overriding;
        if (list2 == null) {
            return false;
        }
        List<String> overriding = list2;
        return overriding.contains(type + ":" + name);
    }

    private final boolean isPrivate(Context context2, ResourceType type, String name) {
        if (type == ResourceType.ID) {
            return false;
        }
        ResourceVisibilityLookup lookup = context2.getProject().getResourceVisibility();
        return lookup.isPrivate(type, name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPrivate(Context context2, ResourceUrl url) {
        if (url == null) return false;
        if (url.isFramework()) return false;
        ResourceType resourceType = url.type;
        Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"type");
        String string2 = url.name;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
        if (!this.isPrivate(context2, resourceType, string2)) return false;
        return true;
    }

    private final void checkChildRefs(XmlContext context2, Element item) {
        NodeList childNodes = item.getChildNodes();
        int n = childNodes.getLength();
        block0: for (int i = 0; i < n; ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 3) continue;
            String text = child.getNodeValue();
            Intrinsics.checkNotNull((Object)text);
            int index2 = StringsKt.indexOf$default((CharSequence)text, (String)"?attr/", (int)0, (boolean)false, (int)6, null);
            if (index2 != -1) {
                String string2 = text.substring(index2 + 6);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String name = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                if (!this.isPrivate(context2, ResourceType.ATTR, name)) continue;
                String message = this.createUsageErrorMessage(context2, ResourceType.ATTR, name);
                Node node = item;
                Intrinsics.checkNotNull((Object)child);
                XmlContext.report$default(context2, ISSUE, node, context2.getLocation(child), message, null, 16, null);
                continue;
            }
            int m = text.length();
            for (int j = 0; j < m; ++j) {
                char c = text.charAt(j);
                if (c == '@') {
                    ResourceUrl url = ResourceUrl.parse((String)((Object)StringsKt.trim((CharSequence)text)).toString());
                    if (!this.isPrivate(context2, url)) continue block0;
                    Context context3 = context2;
                    ResourceUrl resourceUrl = url;
                    Intrinsics.checkNotNull((Object)resourceUrl);
                    ResourceType resourceType = resourceUrl.type;
                    Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"type");
                    String string3 = url.name;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name");
                    String message = this.createUsageErrorMessage(context3, resourceType, string3);
                    Node node = item;
                    Intrinsics.checkNotNull((Object)child);
                    XmlContext.report$default(context2, ISSUE, node, context2.getLocation(child), message, null, 16, null);
                    continue block0;
                }
                if (!Character.isWhitespace(c)) continue block0;
            }
        }
    }

    @Override
    public void beforeCheckFile(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        File file = context2.file;
        if (!Lint.isXmlFile(file) && !SdkUtils.isBitmapFile((File)file)) {
            return;
        }
        String parentName = file.getParentFile().getName();
        Intrinsics.checkNotNull((Object)parentName);
        int dash = StringsKt.indexOf$default((CharSequence)parentName, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (dash != -1 || Intrinsics.areEqual((Object)"values", (Object)parentName)) {
            return;
        }
        ResourceFolderType resourceFolderType = ResourceFolderType.getFolderType((String)parentName);
        if (resourceFolderType == null) {
            return;
        }
        ResourceFolderType folderType = resourceFolderType;
        List types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
        if (types.isEmpty()) {
            return;
        }
        ResourceType type = (ResourceType)types.get(0);
        String string2 = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String resourceName = ResourcesUtil.resourceNameToFieldName((String)Lint.getBaseName(string2));
        Intrinsics.checkNotNull((Object)type);
        if (this.isPrivate(context2, type, resourceName)) {
            if (Lint.isXmlFile(file)) {
                this.recordOverriding(type, resourceName);
                if (this.hasOverride(context2)) {
                    return;
                }
            }
            String message = this.createOverrideErrorMessage(context2, type, resourceName);
            Location location = Location.Companion.create(file);
            Context.report$default(context2, ISSUE, location, message, null, 8, null);
        }
    }

    private final boolean hasOverride(Context context2) {
        if (context2 instanceof XmlContext) {
            Element element = ((XmlContext)context2).document.getDocumentElement();
            if (element == null) {
                return false;
            }
            Element element2 = element;
            return Intrinsics.areEqual((Object)"true", (Object)element2.getAttributeNS("http://schemas.android.com/tools", ATTR_OVERRIDE));
        }
        return false;
    }

    private final String createOverrideErrorMessage(Context context2, ResourceType type, String name) {
        String libraryName = this.getLibraryName(context2, type, name);
        return "Overriding `@" + type + "/" + name + "` which is marked as private in " + libraryName + ". If deliberate, use tools:override=\"true\", otherwise pick a different name.";
    }

    private final String createUsageErrorMessage(Context context2, ResourceType type, String name) {
        String libraryName = this.getLibraryName(context2, type, name);
        return "The resource `@" + type + "/" + name + "` is marked as private in " + libraryName;
    }

    private final String getLibraryName(Context context2, ResourceType type, String name) {
        ResourceVisibilityLookup lookup = context2.getProject().getResourceVisibility();
        String library2 = lookup.getPrivateIn(type, name);
        String string2 = library2;
        if (string2 == null) {
            string2 = "the library";
        }
        return string2;
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.JAVA_FILE_SCOPE, Scope.RESOURCE_FILE_SCOPE};
        IMPLEMENTATION = new Implementation(PrivateResourceDetector.class, Scope.JAVA_AND_RESOURCE_FILES, enumSetArray);
        ISSUE = Issue.Companion.create("PrivateResource", "Using private resources", "\n          Private resources should not be referenced; the may not be present everywhere, \\\n          and even where they are they may disappear without notice.\n\n          To fix this, copy the resource into your own project instead.\n          ", Category.CORRECTNESS, 3, Severity.WARNING, IMPLEMENTATION);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/PrivateResourceDetector$Companion;", "", "<init>", "()V", "ATTR_OVERRIDE", "", "KEY_URL", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

