/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/checks/TileServiceActivityDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Issues", "android.sdktools.lint-checks"})
public final class TileServiceActivityDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(TileServiceActivityDetector.class, EnumSet.of((Enum)Scope.BINARY_RESOURCE_FILE, (Enum)Scope.MANIFEST));
    private static final int UPSIDE_DOWN_CAKE_API_VERSION = 34;
    @JvmField
    @NotNull
    public static final Issue START_ACTIVITY_AND_COLLAPSE_DEPRECATED;

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"startActivityAndCollapse");
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!JavaEvaluator.isMemberInSubClassOf$default(context2.getEvaluator(), (PsiMember)method, "android.service.quicksettings.TileService", false, 4, null)) {
            return;
        }
        UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)node.getValueArguments());
        if (uExpression == null) {
            return;
        }
        UExpression argument = uExpression;
        PsiType psiType = argument.getExpressionType();
        if (!Intrinsics.areEqual((Object)(psiType != null ? psiType.getCanonicalText() : null), (Object)"android.content.Intent")) {
            return;
        }
        Location location = context2.getLocation((UElement)argument);
        String message = "TileService#startActivityAndCollapse(Intent) is deprecated. Use TileService#startActivityAndCollapse(PendingIntent) instead.";
        context2.report(new Incident(START_ACTIVITY_AND_COLLAPSE_DEPRECATED, node, location, message).overrideSeverity(Severity.WARNING), Constraints.targetSdkLessThan(34));
        context2.report(new Incident(START_ACTIVITY_AND_COLLAPSE_DEPRECATED, node, location, message), Constraints.targetSdkAtLeast(34));
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(TileServiceActivityDetector.class, Scope.JAVA_FILE_SCOPE);
        START_ACTIVITY_AND_COLLAPSE_DEPRECATED = Issue.Companion.create$default(companion, "StartActivityAndCollapseDeprecated", "TileService.startActivityAndCollapse(Intent) is deprecated", "\n                `TileService#startActivityAndCollapse(Intent)` has been deprecated, and will throw \\\n                an `UnsupportedOperationException` if used in apps targeting Android versions UpsideDownCake and higher. \\\n                Convert the Intent to a PendingIntent.\n            ", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/lint/checks/TileServiceActivityDetector$Issues;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "getIMPLEMENTATION", "()Lcom/android/tools/lint/detector/api/Implementation;", "UPSIDE_DOWN_CAKE_API_VERSION", "", "START_ACTIVITY_AND_COLLAPSE_DEPRECATED", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        @NotNull
        public final Implementation getIMPLEMENTATION() {
            return IMPLEMENTATION;
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

