/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.WearDetectorKt;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.utils.DomExtensions;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/WearDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "<init>", "()V", "isWearProject", "", "()Z", "setWearProject", "(Z)V", "beforeCheckEachProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "Companion", "android.sdktools.lint-checks"})
public class WearDetector
extends Detector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isWearProject;

    public final boolean isWearProject() {
        return this.isWearProject;
    }

    public final void setWearProject(boolean bl) {
        this.isWearProject = bl;
    }

    @Override
    public void beforeCheckEachProject(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super.beforeCheckEachProject(context2);
        this.isWearProject = Companion.isWearProject(context2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/WearDetector$Companion;", "", "<init>", "()V", "isWearProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "containsWearFeature", "manifest", "Lorg/w3c/dom/Element;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isWearProject(@NotNull Context context2) {
            Element element;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (context2.isGlobalAnalysis()) {
                Document document = context2.getMainProject().getMergedManifest();
                element = document != null ? document.getDocumentElement() : null;
            } else {
                Document document = context2.getProject().getMergedManifest();
                element = document != null ? document.getDocumentElement() : null;
            }
            return this.containsWearFeature(element);
        }

        public final boolean containsWearFeature(@Nullable Element manifest) {
            if (manifest == null) {
                return false;
            }
            Iterator iterator = DomExtensions.iterator((Element)manifest);
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                if (!WearDetectorKt.access$isWearFeature(element)) continue;
                return true;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

