/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.helpers.ZipStreamsKt;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 72\u00020\u0001:\u0003567B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u001d\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u0014*\b\u0012\u0004\u0012\u0002H\u00140\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016J \u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u001b\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010\u001d\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\"\u0010$\u001a\u0004\u0018\u00010%*\u00020#2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020!0'H\u0002J\u0010\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\fH\u0002J\u0010\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020#H\u0002J(\u0010,\u001a\u00020!*\u00020%2\u0006\u0010-\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\nH\u0002J \u0010,\u001a\u00020!*\u00020%2\u0006\u0010\u0018\u001a\u00020\n2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\nH\u0002J(\u0010/\u001a\u00020!*\u00020%2\u0006\u0010-\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\nH\u0002J(\u00100\u001a\u00020!*\u00020%2\u0006\u0010-\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\nH\u0002J \u00100\u001a\u00020!*\u00020%2\u0006\u0010\u0018\u001a\u00020\n2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010(\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0016\u00101\u001a\b\u0012\u0002\b\u0003\u0018\u0001022\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u000e\u00103\u001a\u0004\u0018\u00010%*\u00020%H\u0002J\n\u00104\u001a\u00020\n*\u00020#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/android/tools/lint/client/api/LintJarApiMigration;", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "<init>", "(Lcom/android/tools/lint/client/api/LintClient;)V", "getMigratedJar", "Ljava/io/File;", "jar", "registryClass", "", "migrateJar", "", "jarBytes", "migrateClass", "bytes", "mapClass", "s", "migrateClassNames", "pop", "E", "", "(Ljava/util/List;)Ljava/lang/Object;", "mapApi", "owner", "oldApi", "descriptor", "getSuperTypes", "", "type", "(Ljava/lang/String;)[Ljava/lang/String;", "key", "isRelevantMethod", "", "methodNode", "Lorg/objectweb/asm/tree/MethodNode;", "find", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "condition", "Lkotlin/Function1;", "migrateAnalyzeCall", "classBytes", "handleLintUtilRedirection", "method", "isCall", "name", "desc", "isVirtualCall", "isStaticCall", "findClass", "Ljava/lang/Class;", "prev", "prettyPrint", "SwitchToInterfaceClassVisitor", "SwitchToInterfaceMethodVisitor", "Companion", "android.sdktools.lint-api"})
@SourceDebugExtension(value={"SMAP\nLintJarApiMigration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintJarApiMigration.kt\ncom/android/tools/lint/client/api/LintJarApiMigration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,2589:1\n295#2,2:2590\n*S KotlinDebug\n*F\n+ 1 LintJarApiMigration.kt\ncom/android/tools/lint/client/api/LintJarApiMigration\n*L\n2162#1:2590,2\n*E\n"})
public final class LintJarApiMigration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LintClient client;
    private static final boolean DEBUG = false;

    public LintJarApiMigration(@NotNull LintClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
    }

    @NotNull
    public final File getMigratedJar(@NotNull File jar, @NotNull String registryClass) {
        Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
        Intrinsics.checkNotNullParameter((Object)registryClass, (String)"registryClass");
        File cacheDir = this.client.getCacheDir("migrated-jars", true);
        byte[] jarContents = FilesKt.readBytes((File)jar);
        HashFunction hashFunction = Hashing.farmHashFingerprint64();
        Hasher hasher = hashFunction.newHasher();
        hasher.putBytes(jarContents);
        HashCode hashCode = hasher.hash();
        String string2 = hashCode.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String hashCodeString = string2;
        String fileName = (String)(!StringsKt.isBlank((CharSequence)registryClass) ? registryClass + "-" : "") + hashCodeString + "..jar";
        File cachedJar = new File(cacheDir, fileName);
        if (!cachedJar.isFile()) {
            byte[] bytes = this.migrateJar(jarContents);
            FilesKt.writeBytes((File)cachedJar, (byte[])bytes);
        }
        return cachedJar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] migrateJar(byte[] jarBytes) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Closeable closeable = new JarInputStream(new ByteArrayInputStream(jarBytes));
        Throwable throwable = null;
        try {
            JarInputStream jis = (JarInputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = output;
            Throwable throwable2 = null;
            try {
                ByteArrayOutputStream fos = (ByteArrayOutputStream)closeable2;
                boolean bl2 = false;
                Closeable closeable3 = new JarOutputStream(fos);
                Throwable throwable3 = null;
                try {
                    JarOutputStream jos = (JarOutputStream)closeable3;
                    boolean bl3 = false;
                    JarEntry entry = jis.getNextJarEntry();
                    while (entry != null) {
                        jos.putNextEntry(new JarEntry(entry.getName()));
                        String name = entry.getName();
                        Intrinsics.checkNotNull((Object)name);
                        if (StringsKt.endsWith$default((String)name, (String)".class", (boolean)false, (int)2, null) && !entry.isDirectory()) {
                            byte[] bytes = ZipStreamsKt.readAllBytes(jis, (ZipEntry)entry);
                            byte[] migrated = this.migrateClass(bytes);
                            jos.write(migrated);
                        } else {
                            ByteStreamsKt.copyTo$default((InputStream)jis, (OutputStream)jos, (int)0, (int)2, null);
                        }
                        jos.closeEntry();
                        entry = jis.getNextJarEntry();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] byArray = output.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    @NotNull
    public final byte[] migrateClass(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return this.migrateClassNames(this.migrateAnalyzeCall(bytes));
    }

    @Nullable
    public final String mapClass(@Nullable String s) {
        if (s == null || !Companion.isRelevantType(s)) {
            return null;
        }
        int innerClassIndex = StringsKt.indexOf$default((CharSequence)s, (char)'$', (int)0, (boolean)false, (int)6, null);
        if (innerClassIndex != -1) {
            String string2 = s.substring(0, innerClassIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String mapped = this.mapClass(string2);
            if (mapped != null) {
                String string3 = s.substring(innerClassIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                return mapped + string3;
            }
        }
        return switch (s) {
            case "org/jetbrains/kotlin/analysis/api/KaStarTypeProjection" -> "org/jetbrains/kotlin/analysis/api/types/KaStarTypeProjection";
            case "org/jetbrains/kotlin/analysis/api/KaSymbolBasedReference" -> "org/jetbrains/kotlin/analysis/api/resolution/KaSymbolBasedReference";
            case "org/jetbrains/kotlin/analysis/api/KaTypeArgumentWithVariance" -> "org/jetbrains/kotlin/analysis/api/types/KaTypeArgumentWithVariance";
            case "org/jetbrains/kotlin/analysis/api/KaTypeProjection" -> "org/jetbrains/kotlin/analysis/api/types/KaTypeProjection";
            case "org/jetbrains/kotlin/analysis/api/KtAnalysisApiInternals" -> "org/jetbrains/kotlin/analysis/api/KaAnalysisApiInternals";
            case "org/jetbrains/kotlin/analysis/api/KtAnalysisNonPublicApi" -> "org/jetbrains/kotlin/analysis/api/KaAnalysisNonPublicApi";
            case "org/jetbrains/kotlin/analysis/api/KtAnalysisSession" -> "org/jetbrains/kotlin/analysis/api/KaSession";
            case "org/jetbrains/kotlin/analysis/api/KtStarTypeProjection" -> "org/jetbrains/kotlin/analysis/api/types/KaStarTypeProjection";
            case "org/jetbrains/kotlin/analysis/api/KtSymbolBasedReference" -> "org/jetbrains/kotlin/analysis/api/resolution/KaSymbolBasedReference";
            case "org/jetbrains/kotlin/analysis/api/KtTypeArgumentWithVariance" -> "org/jetbrains/kotlin/analysis/api/types/KaTypeArgumentWithVariance";
            case "org/jetbrains/kotlin/analysis/api/KtTypeProjection" -> "org/jetbrains/kotlin/analysis/api/types/KaTypeProjection";
            case "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationApplication" -> "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotation";
            case "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationApplicationInfo" -> "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotation";
            case "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationApplicationValue" -> "KaAnnotationValue$NestedAnnotationValue";
            case "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationApplicationWithArgumentsInfo" -> "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotation";
            case "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationsList" -> "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationList";
            case "org/jetbrains/kotlin/analysis/api/annotations/KaArrayAnnotationValue" -> "KaAnnotationValue$ArrayValue";
            case "org/jetbrains/kotlin/analysis/api/annotations/KaConstantAnnotationValue" -> "KaAnnotationValue$ConstantValue";
            case "org/jetbrains/kotlin/analysis/api/annotations/KaEnumEntryAnnotationValue" -> "KaAnnotationValue$EnumEntryValue";
            case "org/jetbrains/kotlin/analysis/api/annotations/KaKClassAnnotationValue" -> "KaAnnotationValue$ClassLiteralValue";
            case "org/jetbrains/kotlin/analysis/api/annotations/KaUnsupportedAnnotationValue" -> "KaAnnotationValue$UnsupportedValue";
            case "org/jetbrains/kotlin/analysis/api/annotations/KtAnnotated" -> "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotated";
            case "org/jetbrains/kotlin/analysis/api/annotations/KtAnnotationApplication" -> "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotation";
            case "org/jetbrains/kotlin/analysis/api/annotations/KtAnnotationApplicationInfo" -> "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotation";
            case "org/jetbrains/kotlin/analysis/api/annotations/KtAnnotationApplicationValue" -> "KaAnnotationValue$NestedAnnotationValue";
            case "org/jetbrains/kotlin/analysis/api/annotations/KtAnnotationApplicationWithArgumentsInfo" -> "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotation";
            case "org/jetbrains/kotlin/analysis/api/annotations/KtAnnotationValue" -> "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue";
            case "org/jetbrains/kotlin/analysis/api/annotations/KtAnnotationsList" -> "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationList";
            case "org/jetbrains/kotlin/analysis/api/annotations/KtArrayAnnotationValue" -> "KaAnnotationValue$ArrayValue";
            case "org/jetbrains/kotlin/analysis/api/annotations/KtConstantAnnotationValue" -> "KaAnnotationValue$ConstantValue";
            case "org/jetbrains/kotlin/analysis/api/annotations/KtEnumEntryAnnotationValue" -> "KaAnnotationValue$EnumEntryValue";
            case "org/jetbrains/kotlin/analysis/api/annotations/KtKClassAnnotationValue" -> "KaAnnotationValue$ClassLiteralValue";
            case "org/jetbrains/kotlin/analysis/api/annotations/KtNamedAnnotationValue" -> "org/jetbrains/kotlin/analysis/api/annotations/KaNamedAnnotationValue";
            case "org/jetbrains/kotlin/analysis/api/annotations/KtUnsupportedAnnotationValue" -> "KaAnnotationValue$UnsupportedValue";
            case "org/jetbrains/kotlin/analysis/api/base/KtConstantValue" -> "org/jetbrains/kotlin/analysis/api/base/KaConstantValue";
            case "org/jetbrains/kotlin/analysis/api/base/KtContextReceiver" -> "org/jetbrains/kotlin/analysis/api/base/KaContextReceiver";
            case "org/jetbrains/kotlin/analysis/api/base/KtContextReceiversOwner" -> "org/jetbrains/kotlin/analysis/api/base/KaContextReceiversOwner";
            case "org/jetbrains/kotlin/analysis/api/calls/KaAnnotationCall" -> "org/jetbrains/kotlin/analysis/api/resolution/KaAnnotationCall";
            case "org/jetbrains/kotlin/analysis/api/calls/KaApplicableCallCandidateInfo" -> "org/jetbrains/kotlin/analysis/api/resolution/KaApplicableCallCandidateInfo";
            case "org/jetbrains/kotlin/analysis/api/calls/KaCall" -> "org/jetbrains/kotlin/analysis/api/resolution/KaCall";
            case "org/jetbrains/kotlin/analysis/api/calls/KaCallCandidateInfo" -> "org/jetbrains/kotlin/analysis/api/resolution/KaCallCandidateInfo";
            case "org/jetbrains/kotlin/analysis/api/calls/KaCallInfo" -> "org/jetbrains/kotlin/analysis/api/resolution/KaCallInfo";
            case "org/jetbrains/kotlin/analysis/api/calls/KaCallableMemberCall" -> "org/jetbrains/kotlin/analysis/api/resolution/KaCallableMemberCall";
            case "org/jetbrains/kotlin/analysis/api/calls/KaCompoundAccess" -> "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundOperation";
            case "org/jetbrains/kotlin/analysis/api/calls/KaCompoundAccessCall" -> "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundAccessCall";
            case "org/jetbrains/kotlin/analysis/api/calls/KaCompoundArrayAccessCall" -> "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundArrayAccessCall";
            case "org/jetbrains/kotlin/analysis/api/calls/KaCompoundVariableAccessCall" -> "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundVariableAccessCall";
            case "org/jetbrains/kotlin/analysis/api/calls/KaDelegatedConstructorCall" -> "org/jetbrains/kotlin/analysis/api/resolution/KaDelegatedConstructorCall";
            case "org/jetbrains/kotlin/analysis/api/calls/KaErrorCallInfo" -> "org/jetbrains/kotlin/analysis/api/resolution/KaErrorCallInfo";
            case "org/jetbrains/kotlin/analysis/api/calls/KaExplicitReceiverValue" -> "org/jetbrains/kotlin/analysis/api/resolution/KaExplicitReceiverValue";
            case "org/jetbrains/kotlin/analysis/api/calls/KaFunctionCall" -> "org/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall";
            case "org/jetbrains/kotlin/analysis/api/calls/KaImplicitReceiverValue" -> "org/jetbrains/kotlin/analysis/api/resolution/KaImplicitReceiverValue";
            case "org/jetbrains/kotlin/analysis/api/calls/KaInapplicableCallCandidateInfo" -> "org/jetbrains/kotlin/analysis/api/resolution/KaInapplicableCallCandidateInfo";
            case "org/jetbrains/kotlin/analysis/api/calls/KaPartiallyAppliedFunctionSymbol" -> "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedFunctionSymbol";
            case "org/jetbrains/kotlin/analysis/api/calls/KaPartiallyAppliedSymbol" -> "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedSymbol";
            case "org/jetbrains/kotlin/analysis/api/calls/KaPartiallyAppliedVariableSymbol" -> "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedVariableSymbol";
            case "org/jetbrains/kotlin/analysis/api/calls/KaReceiverValue" -> "org/jetbrains/kotlin/analysis/api/resolution/KaReceiverValue";
            case "org/jetbrains/kotlin/analysis/api/calls/KaSimpleFunctionCall" -> "org/jetbrains/kotlin/analysis/api/resolution/KaSimpleFunctionCall";
            case "org/jetbrains/kotlin/analysis/api/calls/KaSimpleVariableAccess" -> "org/jetbrains/kotlin/analysis/api/resolution/KaSimpleVariableAccess";
            case "org/jetbrains/kotlin/analysis/api/calls/KaSimpleVariableAccessCall" -> "org/jetbrains/kotlin/analysis/api/resolution/KaSimpleVariableAccessCall";
            case "org/jetbrains/kotlin/analysis/api/calls/KaSmartCastedReceiverValue" -> "org/jetbrains/kotlin/analysis/api/resolution/KaSmartCastedReceiverValue";
            case "org/jetbrains/kotlin/analysis/api/calls/KaSuccessCallInfo" -> "org/jetbrains/kotlin/analysis/api/resolution/KaSuccessCallInfo";
            case "org/jetbrains/kotlin/analysis/api/calls/KaVariableAccessCall" -> "org/jetbrains/kotlin/analysis/api/resolution/KaVariableAccessCall";
            case "org/jetbrains/kotlin/analysis/api/calls/KtAnnotationCall" -> "org/jetbrains/kotlin/analysis/api/resolution/KaAnnotationCall";
            case "org/jetbrains/kotlin/analysis/api/calls/KtApplicableCallCandidateInfo" -> "org/jetbrains/kotlin/analysis/api/resolution/KaApplicableCallCandidateInfo";
            case "org/jetbrains/kotlin/analysis/api/calls/KtCall" -> "org/jetbrains/kotlin/analysis/api/resolution/KaCall";
            case "org/jetbrains/kotlin/analysis/api/calls/KtCallCandidateInfo" -> "org/jetbrains/kotlin/analysis/api/resolution/KaCallCandidateInfo";
            case "org/jetbrains/kotlin/analysis/api/calls/KtCallInfo" -> "org/jetbrains/kotlin/analysis/api/resolution/KaCallInfo";
            case "org/jetbrains/kotlin/analysis/api/calls/KtCallableMemberCall" -> "org/jetbrains/kotlin/analysis/api/resolution/KaCallableMemberCall";
            case "org/jetbrains/kotlin/analysis/api/calls/KtCompoundAccess" -> "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundOperation";
            case "org/jetbrains/kotlin/analysis/api/calls/KtCompoundAccessCall" -> "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundAccessCall";
            case "org/jetbrains/kotlin/analysis/api/calls/KtCompoundArrayAccessCall" -> "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundArrayAccessCall";
            case "org/jetbrains/kotlin/analysis/api/calls/KtCompoundVariableAccessCall" -> "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundVariableAccessCall";
            case "org/jetbrains/kotlin/analysis/api/calls/KtDelegatedConstructorCall" -> "org/jetbrains/kotlin/analysis/api/resolution/KaDelegatedConstructorCall";
            case "org/jetbrains/kotlin/analysis/api/calls/KtErrorCallInfo" -> "org/jetbrains/kotlin/analysis/api/resolution/KaErrorCallInfo";
            case "org/jetbrains/kotlin/analysis/api/calls/KtExplicitReceiverValue" -> "org/jetbrains/kotlin/analysis/api/resolution/KaExplicitReceiverValue";
            case "org/jetbrains/kotlin/analysis/api/calls/KtFunctionCall" -> "org/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall";
            case "org/jetbrains/kotlin/analysis/api/calls/KtImplicitReceiverValue" -> "org/jetbrains/kotlin/analysis/api/resolution/KaImplicitReceiverValue";
            case "org/jetbrains/kotlin/analysis/api/calls/KtInapplicableCallCandidateInfo" -> "org/jetbrains/kotlin/analysis/api/resolution/KaInapplicableCallCandidateInfo";
            case "org/jetbrains/kotlin/analysis/api/calls/KtPartiallyAppliedFunctionSymbol" -> "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedFunctionSymbol";
            case "org/jetbrains/kotlin/analysis/api/calls/KtPartiallyAppliedSymbol" -> "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedSymbol";
            case "org/jetbrains/kotlin/analysis/api/calls/KtPartiallyAppliedVariableSymbol" -> "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedVariableSymbol";
            case "org/jetbrains/kotlin/analysis/api/calls/KtReceiverValue" -> "org/jetbrains/kotlin/analysis/api/resolution/KaReceiverValue";
            case "org/jetbrains/kotlin/analysis/api/calls/KtSimpleFunctionCall" -> "org/jetbrains/kotlin/analysis/api/resolution/KaSimpleFunctionCall";
            case "org/jetbrains/kotlin/analysis/api/calls/KtSimpleVariableAccess" -> "org/jetbrains/kotlin/analysis/api/resolution/KaSimpleVariableAccess";
            case "org/jetbrains/kotlin/analysis/api/calls/KtSimpleVariableAccessCall" -> "org/jetbrains/kotlin/analysis/api/resolution/KaSimpleVariableAccessCall";
            case "org/jetbrains/kotlin/analysis/api/calls/KtSmartCastedReceiverValue" -> "org/jetbrains/kotlin/analysis/api/resolution/KaSmartCastedReceiverValue";
            case "org/jetbrains/kotlin/analysis/api/calls/KtSuccessCallInfo" -> "org/jetbrains/kotlin/analysis/api/resolution/KaSuccessCallInfo";
            case "org/jetbrains/kotlin/analysis/api/calls/KtVariableAccessCall" -> "org/jetbrains/kotlin/analysis/api/resolution/KaVariableAccessCall";
            case "org/jetbrains/kotlin/analysis/api/components/KtBuiltinTypes" -> "org/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes";
            case "org/jetbrains/kotlin/analysis/api/components/KtClassTypeBuilder" -> "org/jetbrains/kotlin/analysis/api/components/KaClassTypeBuilder";
            case "org/jetbrains/kotlin/analysis/api/components/KtCompilationResult" -> "org/jetbrains/kotlin/analysis/api/components/KaCompilationResult";
            case "org/jetbrains/kotlin/analysis/api/components/KtCompiledFile" -> "org/jetbrains/kotlin/analysis/api/components/KaCompiledFile";
            case "org/jetbrains/kotlin/analysis/api/components/KtCompilerTarget" -> "org/jetbrains/kotlin/analysis/api/components/KaCompilerTarget";
            case "org/jetbrains/kotlin/analysis/api/components/KtCompletionExtensionCandidateChecker" -> "org/jetbrains/kotlin/analysis/api/components/KaCompletionExtensionCandidateChecker";
            case "org/jetbrains/kotlin/analysis/api/components/KtDataFlowExitPointSnapshot" -> "org/jetbrains/kotlin/analysis/api/components/KaDataFlowExitPointSnapshot";
            case "org/jetbrains/kotlin/analysis/api/components/KtDiagnosticCheckerFilter" -> "org/jetbrains/kotlin/analysis/api/components/KaDiagnosticCheckerFilter";
            case "org/jetbrains/kotlin/analysis/api/components/KtExtensionApplicabilityResult" -> "org/jetbrains/kotlin/analysis/api/components/KaExtensionApplicabilityResult";
            case "org/jetbrains/kotlin/analysis/api/components/KtImplicitReceiver" -> "org/jetbrains/kotlin/analysis/api/components/KaImplicitReceiver";
            case "org/jetbrains/kotlin/analysis/api/components/KtImplicitReceiverSmartCast" -> "org/jetbrains/kotlin/analysis/api/components/KaImplicitReceiverSmartCast";
            case "org/jetbrains/kotlin/analysis/api/components/KtImplicitReceiverSmartCastKind" -> "org/jetbrains/kotlin/analysis/api/components/KaImplicitReceiverSmartCastKind";
            case "org/jetbrains/kotlin/analysis/api/components/KtImportOptimizerResult" -> "org/jetbrains/kotlin/analysis/api/components/KaImportOptimizerResult";
            case "org/jetbrains/kotlin/analysis/api/components/KtScopeContext" -> "org/jetbrains/kotlin/analysis/api/components/KaScopeContext";
            case "org/jetbrains/kotlin/analysis/api/components/KtScopeKind" -> "org/jetbrains/kotlin/analysis/api/components/KaScopeKind";
            case "org/jetbrains/kotlin/analysis/api/components/KtScopeWithKind" -> "org/jetbrains/kotlin/analysis/api/components/KaScopeWithKind";
            case "org/jetbrains/kotlin/analysis/api/components/KtSmartCastInfo" -> "org/jetbrains/kotlin/analysis/api/components/KaSmartCastInfo";
            case "org/jetbrains/kotlin/analysis/api/components/KtSubstitutorBuilder" -> "org/jetbrains/kotlin/analysis/api/components/KaSubstitutorBuilder";
            case "org/jetbrains/kotlin/analysis/api/components/KtSubtypingErrorTypePolicy" -> "org/jetbrains/kotlin/analysis/api/components/KaSubtypingErrorTypePolicy";
            case "org/jetbrains/kotlin/analysis/api/components/KtSymbolDeclarationOverridesProvider" -> "org/jetbrains/kotlin/analysis/api/components/KaSymbolRelationProvider";
            case "org/jetbrains/kotlin/analysis/api/components/KtSymbolDeclarationOverridesProviderMixIn" -> "org/jetbrains/kotlin/analysis/api/components/KaSymbolRelationProviderMixIn";
            case "org/jetbrains/kotlin/analysis/api/components/KtTypeBuilder" -> "org/jetbrains/kotlin/analysis/api/components/KaTypeBuilder";
            case "org/jetbrains/kotlin/analysis/api/components/KtTypeParameterTypeBuilder" -> "org/jetbrains/kotlin/analysis/api/components/KaTypeParameterTypeBuilder";
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KtContractCallsInPlaceContractEffectDeclaration" -> "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractCallsInPlaceContractEffectDeclaration";
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KtContractConditionalContractEffectDeclaration" -> "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractConditionalContractEffectDeclaration";
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KtContractConstantValue" -> "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractConstantValue";
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KtContractEffectDeclaration" -> "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractEffectDeclaration";
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KtContractParameterValue" -> "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractParameterValue";
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KtContractReturnsContractEffectDeclaration" -> "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractReturnsContractEffectDeclaration";
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KtContractBinaryLogicExpression" -> "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBinaryLogicExpression";
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KtContractBooleanConstantExpression" -> "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanConstantExpression";
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KtContractBooleanExpression" -> "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanExpression";
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KtContractBooleanValueParameterExpression" -> "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanValueParameterExpression";
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KtContractIsInstancePredicateExpression" -> "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractIsInstancePredicateExpression";
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KtContractIsNullPredicateExpression" -> "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractIsNullPredicateExpression";
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KtContractLogicalNotExpression" -> "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractLogicalNotExpression";
            case "org/jetbrains/kotlin/analysis/api/diagnostics/KtDiagnostic" -> "org/jetbrains/kotlin/analysis/api/diagnostics/KaDiagnostic";
            case "org/jetbrains/kotlin/analysis/api/diagnostics/KtDiagnosticWithPsi" -> "org/jetbrains/kotlin/analysis/api/diagnostics/KaDiagnosticWithPsi";
            case "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KtCompilerPluginDiagnostic0" -> "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic0";
            case "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KtCompilerPluginDiagnostic1" -> "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic1";
            case "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KtCompilerPluginDiagnostic2" -> "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic2";
            case "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KtCompilerPluginDiagnostic3" -> "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic3";
            case "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KtCompilerPluginDiagnostic4" -> "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic4";
            case "org/jetbrains/kotlin/analysis/api/lifetime/KtIllegalLifetimeOwnerAccessException" -> "org/jetbrains/kotlin/analysis/api/lifetime/KaIllegalLifetimeOwnerAccessException";
            case "org/jetbrains/kotlin/analysis/api/lifetime/KtInaccessibleLifetimeOwnerAccessException" -> "org/jetbrains/kotlin/analysis/api/lifetime/KaInaccessibleLifetimeOwnerAccessException";
            case "org/jetbrains/kotlin/analysis/api/lifetime/KtInvalidLifetimeOwnerAccessException" -> "org/jetbrains/kotlin/analysis/api/lifetime/KaInvalidLifetimeOwnerAccessException";
            case "org/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeOwner" -> "org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner";
            case "org/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeOwnerField" -> "org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwnerField";
            case "org/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken" -> "org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken";
            case "org/jetbrains/kotlin/analysis/api/renderer/base/KtKeywordRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/base/KaKeywordRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/base/KtKeywordsRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/base/KaKeywordsRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/KtAnnotationRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/KaAnnotationRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/KtAnnotationRendererForSource" -> "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/KaAnnotationRendererForSource";
            case "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/KtRendererAnnotationsFilter" -> "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/KaRendererAnnotationsFilter";
            case "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/renderers/KtAnnotationArgumentsRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/renderers/KaAnnotationArgumentsRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/renderers/KtAnnotationListRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/renderers/KaAnnotationListRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/renderers/KtAnnotationQualifierRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/renderers/KaAnnotationQualifierRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/renderers/KtAnnotationUseSiteTargetRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/renderers/KaAnnotationUseSiteTargetRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/base/contextReceivers/KtContextReceiversRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/base/contextReceivers/KaContextReceiversRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/base/contextReceivers/KtContextReceiversRendererForSource" -> "org/jetbrains/kotlin/analysis/api/renderer/base/contextReceivers/KaContextReceiversRendererForSource";
            case "org/jetbrains/kotlin/analysis/api/renderer/base/contextReceivers/renderers/KtContextReceiverLabelRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/base/contextReceivers/renderers/KaContextReceiverLabelRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/base/contextReceivers/renderers/KtContextReceiverListRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/base/contextReceivers/renderers/KaContextReceiverListRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/KtCallableReturnTypeFilter" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/KaCallableReturnTypeFilter";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/KtDeclarationRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/KaDeclarationRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/KtRecommendedRendererCodeStyle" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/KaRecommendedRendererCodeStyle";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/KtRendererCodeStyle" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/KaRendererCodeStyle";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/KtRendererTypeApproximator" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/KaRendererTypeApproximator";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KtFunctionLikeBodyRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KaFunctionLikeBodyRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KtParameterDefaultValueRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KaParameterDefaultValueRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KtPropertyAccessorBodyRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KaPropertyAccessorBodyRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KtRendererBodyMemberScopeProvider" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KaRendererBodyMemberScopeProvider";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KtRendererBodyMemberScopeSorter" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KaRendererBodyMemberScopeSorter";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KtScriptInitializerRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KaScriptInitializerRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KtVariableInitializerRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KaVariableInitializerRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/impl/KtDeclarationRendererForDebug" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/impl/KaDeclarationRendererForDebug";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/impl/KtDeclarationRendererForSource" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/impl/KaDeclarationRendererForSource";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/KtDeclarationModifiersRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/KaDeclarationModifiersRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/impl/KtDeclarationModifiersRendererForSource" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/impl/KaDeclarationModifiersRendererForSource";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KtModifierListRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KaModifierListRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KtModifiersSorter" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KaModifiersSorter";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KtRendererKeywordFilter" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KaRendererKeywordFilter";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KtRendererModalityModifierProvider" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KaRendererModalityModifierProvider";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KtRendererOtherModifiersProvider" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KaRendererOtherModifiersProvider";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KtRendererVisibilityModifierProvider" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KaRendererVisibilityModifierProvider";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KtCallableParameterRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KaCallableParameterRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KtClassInitializerRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KaClassInitializerRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KtClassifierBodyRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KaClassifierBodyRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KtClassifierBodyWithMembersRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KaClassifierBodyWithMembersRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KtDeclarationNameRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KaDeclarationNameRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KtTypeParameterRendererFilter" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KaTypeParameterRendererFilter";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KtTypeParametersRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KaTypeParametersRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaFunctionSymbolRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaNamedFunctionSymbolRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtAnonymousFunctionSymbolRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaAnonymousFunctionSymbolRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtBackingFieldSymbolRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaBackingFieldSymbolRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtCallableReceiverRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaCallableReceiverRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtCallableReturnTypeRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaCallableReturnTypeRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtCallableSignatureRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaCallableSignatureRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtConstructorSymbolRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaConstructorSymbolRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtDestructuringDeclarationRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaDestructuringDeclarationRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtEnumEntrySymbolRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaEnumEntrySymbolRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtFunctionSymbolRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaNamedFunctionSymbolRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtJavaFieldSymbolRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaJavaFieldSymbolRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtKotlinPropertySymbolRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaKotlinPropertySymbolRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtLocalVariableSymbolRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaLocalVariableSymbolRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtPropertyAccessorsRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaPropertyAccessorsRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtPropertyGetterSymbolRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaPropertyGetterSymbolRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtPropertySetterSymbolRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaPropertySetterSymbolRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtSamConstructorSymbolRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaSamConstructorSymbolRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtScriptSymbolRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaScriptSymbolRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtSyntheticJavaPropertySymbolRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaSyntheticJavaPropertySymbolRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtValueParameterSymbolRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaValueParameterSymbolRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KaNamedClassOrObjectSymbolRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KaNamedClassSymbolRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KtAnonymousObjectSymbolRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KaAnonymousObjectSymbolRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KtNamedClassOrObjectSymbolRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KaNamedClassSymbolRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KtSingleTypeParameterSymbolRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KaSingleTypeParameterSymbolRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KtTypeAliasSymbolRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KaTypeAliasSymbolRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/superTypes/KtSuperTypeListRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/superTypes/KaSuperTypeListRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/superTypes/KtSuperTypeRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/superTypes/KaSuperTypeRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/superTypes/KtSuperTypesCallArgumentsRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/superTypes/KaSuperTypesCallArgumentsRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/superTypes/KtSuperTypesFilter" -> "org/jetbrains/kotlin/analysis/api/renderer/declarations/superTypes/KaSuperTypesFilter";
            case "org/jetbrains/kotlin/analysis/api/renderer/types/KtExpandedTypeRenderingMode" -> "org/jetbrains/kotlin/analysis/api/renderer/types/KaExpandedTypeRenderingMode";
            case "org/jetbrains/kotlin/analysis/api/renderer/types/KtTypeRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/types/KaTypeRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/types/impl/KtTypeRendererForDebug" -> "org/jetbrains/kotlin/analysis/api/renderer/types/impl/KaTypeRendererForDebug";
            case "org/jetbrains/kotlin/analysis/api/renderer/types/impl/KtTypeRendererForSource" -> "org/jetbrains/kotlin/analysis/api/renderer/types/impl/KaTypeRendererForSource";
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtCapturedTypeRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaCapturedTypeRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtClassTypeQualifierRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaClassTypeQualifierRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtDefinitelyNotNullTypeRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaDefinitelyNotNullTypeRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtDynamicTypeRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaDynamicTypeRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtFlexibleTypeRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaFlexibleTypeRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtFunctionalTypeRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaFunctionalTypeRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtIntersectionTypeRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaIntersectionTypeRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtTypeErrorTypeRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaErrorTypeRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtTypeNameRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaTypeNameRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtTypeParameterTypeRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaTypeParameterTypeRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtTypeProjectionRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaTypeProjectionRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtUnresolvedClassErrorTypeRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaUnresolvedClassErrorTypeRenderer";
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtUsualClassTypeRenderer" -> "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaUsualClassTypeRenderer";
            case "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundAccess" -> "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundOperation";
            case "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedFunctionSymbol" -> "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedSymbol";
            case "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedVariableSymbol" -> "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedSymbol";
            case "org/jetbrains/kotlin/analysis/api/resolution/KtApplicableCallCandidateInfo" -> "org/jetbrains/kotlin/analysis/api/resolution/KaApplicableCallCandidateInfo";
            case "org/jetbrains/kotlin/analysis/api/resolution/KtCallCandidateInfo" -> "org/jetbrains/kotlin/analysis/api/resolution/KaCallCandidateInfo";
            case "org/jetbrains/kotlin/analysis/api/resolve/extensions/KtResolveExtension" -> "org/jetbrains/kotlin/analysis/api/resolve/extensions/KaResolveExtension";
            case "org/jetbrains/kotlin/analysis/api/resolve/extensions/KtResolveExtensionFile" -> "org/jetbrains/kotlin/analysis/api/resolve/extensions/KaResolveExtensionFile";
            case "org/jetbrains/kotlin/analysis/api/resolve/extensions/KtResolveExtensionNavigationTargetsProvider" -> "org/jetbrains/kotlin/analysis/api/resolve/extensions/KaResolveExtensionNavigationTargetsProvider";
            case "org/jetbrains/kotlin/analysis/api/resolve/extensions/KtResolveExtensionProvider" -> "org/jetbrains/kotlin/analysis/api/resolve/extensions/KaResolveExtensionProvider";
            case "org/jetbrains/kotlin/analysis/api/scopes/KtScope" -> "org/jetbrains/kotlin/analysis/api/scopes/KaScope";
            case "org/jetbrains/kotlin/analysis/api/scopes/KtScopeLike" -> "org/jetbrains/kotlin/analysis/api/scopes/KaScopeLike";
            case "org/jetbrains/kotlin/analysis/api/scopes/KtScopeNameFilter" -> "org/jetbrains/kotlin/analysis/api/scopes/(Name) -> Boolean";
            case "org/jetbrains/kotlin/analysis/api/scopes/KtTypeScope" -> "org/jetbrains/kotlin/analysis/api/scopes/KaTypeScope";
            case "org/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider" -> "org/jetbrains/kotlin/analysis/api/session/KaSessionProvider";
            case "org/jetbrains/kotlin/analysis/api/signatures/KaFunctionLikeSignature" -> "org/jetbrains/kotlin/analysis/api/signatures/KaFunctionSignature";
            case "org/jetbrains/kotlin/analysis/api/signatures/KaVariableLikeSignature" -> "org/jetbrains/kotlin/analysis/api/signatures/KaVariableSignature";
            case "org/jetbrains/kotlin/analysis/api/signatures/KtCallableSignature" -> "org/jetbrains/kotlin/analysis/api/signatures/KaCallableSignature";
            case "org/jetbrains/kotlin/analysis/api/signatures/KtFunctionLikeSignature" -> "org/jetbrains/kotlin/analysis/api/signatures/KaFunctionSignature";
            case "org/jetbrains/kotlin/analysis/api/signatures/KtVariableLikeSignature" -> "org/jetbrains/kotlin/analysis/api/signatures/KaVariableSignature";
            case "org/jetbrains/kotlin/analysis/api/symbols/KaClassOrObjectSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KaFunctionLikeSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KaNamedClassOrObjectSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaNamedClassSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KaVariableLikeSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaVariableSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtAnonymousFunctionSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaAnonymousFunctionSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtAnonymousObjectSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaAnonymousObjectSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtBackingFieldSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaBackingFieldSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtCallableSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtClassInitializerSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaClassInitializerSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtClassKind" -> "org/jetbrains/kotlin/analysis/api/symbols/KaClassKind";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtClassLikeSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaClassLikeSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtClassOrObjectSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtClassifierSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaClassifierSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtConstructorSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaConstructorSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtDeclarationSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtDestructuringDeclarationSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaDestructuringDeclarationSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtEnumEntryInitializerSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaEnumEntryInitializerSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtEnumEntrySymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaEnumEntrySymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtFileSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaFileSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtFunctionLikeSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtFunctionSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaNamedFunctionSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtJavaFieldSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaJavaFieldSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtKotlinPropertySymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaKotlinPropertySymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtLocalVariableSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaLocalVariableSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtNamedClassOrObjectSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaNamedClassSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtPackageSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaPackageSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtParameterSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaParameterSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtPropertyAccessorSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaPropertyAccessorSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtPropertyGetterSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaPropertyGetterSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtPropertySetterSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaPropertySetterSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtPropertySymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaPropertySymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtReceiverParameterSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaReceiverParameterSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtSamConstructorSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaSamConstructorSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtScriptSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaScriptSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtSymbolOrigin" -> "org/jetbrains/kotlin/analysis/api/symbols/KaSymbolOrigin";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtSyntheticJavaPropertySymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaSyntheticJavaPropertySymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtTypeAliasSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaTypeAliasSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtTypeParameterSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaTypeParameterSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtValueParameterSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaValueParameterSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtVariableLikeSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaVariableSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/KtVariableSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaVariableSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KaPossibleMultiplatformSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KaSymbolWithMembers" -> "org/jetbrains/kotlin/analysis/api/symbols/markers/KaDeclarationContainerSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KaSymbolWithModality" -> "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KaSymbolWithTypeParameters" -> "org/jetbrains/kotlin/analysis/api/symbols/markers/KaTypeParameterOwnerSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KaSymbolWithVisibility" -> "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtAnnotatedSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/markers/KaAnnotatedSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtNamedSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/markers/KaNamedSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtPossibleMultiplatformSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtPossiblyNamedSymbol" -> "org/jetbrains/kotlin/analysis/api/symbols/markers/KaPossiblyNamedSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtSymbolKind" -> "org/jetbrains/kotlin/analysis/api/symbols/markers/KaSymbolKind";
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtSymbolWithKind" -> "org/jetbrains/kotlin/analysis/api/symbols/markers/KaSymbolWithKind";
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtSymbolWithMembers" -> "org/jetbrains/kotlin/analysis/api/symbols/markers/KaDeclarationContainerSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtSymbolWithModality" -> "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtSymbolWithTypeParameters" -> "org/jetbrains/kotlin/analysis/api/symbols/markers/KaTypeParameterOwnerSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtSymbolWithVisibility" -> "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol";
            case "org/jetbrains/kotlin/analysis/api/symbols/pointers/KtPsiBasedSymbolPointer" -> "org/jetbrains/kotlin/analysis/api/symbols/pointers/KaPsiBasedSymbolPointer";
            case "org/jetbrains/kotlin/analysis/api/symbols/pointers/KtSymbolPointer" -> "org/jetbrains/kotlin/analysis/api/symbols/pointers/KaSymbolPointer";
            case "org/jetbrains/kotlin/analysis/api/types/KaFunctionalType" -> "org/jetbrains/kotlin/analysis/api/types/KaFunctionType";
            case "org/jetbrains/kotlin/analysis/api/types/KaNonErrorClassType" -> "org/jetbrains/kotlin/analysis/api/types/KaClassType";
            case "org/jetbrains/kotlin/analysis/api/types/KaTypeErrorType" -> "org/jetbrains/kotlin/analysis/api/types/KaErrorType";
            case "org/jetbrains/kotlin/analysis/api/types/KtCapturedType" -> "org/jetbrains/kotlin/analysis/api/types/KaCapturedType";
            case "org/jetbrains/kotlin/analysis/api/types/KtClassErrorType" -> "org/jetbrains/kotlin/analysis/api/types/KaClassErrorType";
            case "org/jetbrains/kotlin/analysis/api/types/KtClassTypeQualifier" -> "org/jetbrains/kotlin/analysis/api/types/KaClassTypeQualifier";
            case "org/jetbrains/kotlin/analysis/api/types/KtDefinitelyNotNullType" -> "org/jetbrains/kotlin/analysis/api/types/KaDefinitelyNotNullType";
            case "org/jetbrains/kotlin/analysis/api/types/KtDynamicType" -> "org/jetbrains/kotlin/analysis/api/types/KaDynamicType";
            case "org/jetbrains/kotlin/analysis/api/types/KtErrorType" -> "org/jetbrains/kotlin/analysis/api/types/KaErrorType";
            case "org/jetbrains/kotlin/analysis/api/types/KtFlexibleType" -> "org/jetbrains/kotlin/analysis/api/types/KaFlexibleType";
            case "org/jetbrains/kotlin/analysis/api/types/KtFunctionalType" -> "org/jetbrains/kotlin/analysis/api/types/KaFunctionType";
            case "org/jetbrains/kotlin/analysis/api/types/KtIntersectionType" -> "org/jetbrains/kotlin/analysis/api/types/KaIntersectionType";
            case "org/jetbrains/kotlin/analysis/api/types/KtNonErrorClassType" -> "org/jetbrains/kotlin/analysis/api/types/KaClassType";
            case "org/jetbrains/kotlin/analysis/api/types/KtType" -> "org/jetbrains/kotlin/analysis/api/types/KaType";
            case "org/jetbrains/kotlin/analysis/api/types/KtTypeErrorType" -> "org/jetbrains/kotlin/analysis/api/types/KaErrorType";
            case "org/jetbrains/kotlin/analysis/api/types/KtTypeMappingMode" -> "org/jetbrains/kotlin/analysis/api/types/KaTypeMappingMode";
            case "org/jetbrains/kotlin/analysis/api/types/KtTypeNullability" -> "org/jetbrains/kotlin/analysis/api/types/KaTypeNullability";
            case "org/jetbrains/kotlin/analysis/api/types/KtTypeParameterType" -> "org/jetbrains/kotlin/analysis/api/types/KaTypeParameterType";
            case "org/jetbrains/kotlin/analysis/api/types/KtUsualClassType" -> "org/jetbrains/kotlin/analysis/api/types/KaUsualClassType";
            default -> {
                String ktPrefix = "org/jetbrains/kotlin/analysis/api/";
                int lastIndex = StringsKt.lastIndexOf$default((CharSequence)s, (String)"/", (int)0, (boolean)false, (int)6, null);
                if (StringsKt.startsWith$default((String)s, (String)ktPrefix, (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)s, (String)"Kt", (int)(lastIndex + 1), (boolean)false, (int)4, null)) {
                    String v3 = s.substring(0, lastIndex + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"substring(...)");
                    String v4 = s.substring(lastIndex + 3);
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"substring(...)");
                    yield v3 + "Ka" + v4;
                }
                yield null;
            }
        };
    }

    private final byte[] migrateClassNames(byte[] jarBytes) {
        ClassReader classReader = new ClassReader(jarBytes);
        ClassWriter classWriter2 = new ClassWriter(classReader){

            protected String getCommonSuperClass(String type1, String type2) {
                String string2;
                Intrinsics.checkNotNullParameter((Object)type1, (String)"type1");
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type2");
                try {
                    string2 = super.getCommonSuperClass(type1, type2);
                    Intrinsics.checkNotNull((Object)string2);
                }
                catch (TypeNotPresentException e) {
                    string2 = "java/lang/Object";
                }
                return string2;
            }
        };
        Remapper mapper2 = new Remapper(this){
            final /* synthetic */ LintJarApiMigration this$0;
            {
                this.this$0 = $receiver;
            }

            public String mapMethodName(String owner, String name, String descriptor) {
                String string2 = this.this$0.mapClass(name);
                if (string2 == null) {
                    string2 = name;
                }
                return string2;
            }

            public String mapInvokeDynamicMethodName(String name, String descriptor) {
                String string2 = this.this$0.mapClass(name);
                if (string2 == null) {
                    string2 = name;
                }
                return string2;
            }

            public String mapRecordComponentName(String owner, String name, String descriptor) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                String string2 = this.this$0.mapClass(name);
                if (string2 == null) {
                    string2 = name;
                }
                return string2;
            }

            public String mapFieldName(String owner, String name, String descriptor) {
                String string2 = this.this$0.mapClass(name);
                if (string2 == null) {
                    string2 = name;
                }
                return string2;
            }

            public String mapPackageName(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                String string2 = this.this$0.mapClass(name);
                if (string2 == null) {
                    string2 = name;
                }
                return string2;
            }

            public String mapModuleName(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                String string2 = this.this$0.mapClass(name);
                if (string2 == null) {
                    string2 = name;
                }
                return string2;
            }

            public String map(String internalName) {
                String string2 = this.this$0.mapClass(internalName);
                if (string2 == null) {
                    string2 = internalName;
                }
                return string2;
            }
        };
        SwitchToInterfaceClassVisitor myVisitor = new SwitchToInterfaceClassVisitor((ClassVisitor)classWriter2);
        ClassRemapper classMapper = new ClassRemapper((ClassVisitor)myVisitor, mapper2);
        classReader.accept((ClassVisitor)classMapper, 0);
        byte[] byArray = classWriter2.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    private final <E> E pop(List<E> $this$pop) {
        return $this$pop.remove($this$pop.size() - 1);
    }

    private final String mapApi(String owner, String oldApi, String descriptor) {
        String beforeClosingParen = StringsKt.substringBefore$default((String)descriptor, (String)")", null, (int)2, null);
        String initialSig = !Intrinsics.areEqual((Object)beforeClosingParen, (Object)descriptor) && beforeClosingParen.length() > 1 ? beforeClosingParen + ")" : "(L" + owner + ";)";
        List queue = new ArrayList();
        queue.add(initialSig);
        while (!((Collection)queue).isEmpty()) {
            String string2;
            String sig = (String)this.pop(queue);
            String key = oldApi + " " + sig;
            String newApi = this.mapApi(key, oldApi);
            if (!Intrinsics.areEqual((Object)newApi, (Object)oldApi)) {
                return newApi;
            }
            String beforeSemi = StringsKt.substringBefore$default((String)sig, (String)";", null, (int)2, null);
            if (beforeSemi.length() > 2) {
                String string3 = beforeSemi.substring(2);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else {
                string2 = "";
            }
            String oldSuperType = string2;
            for (String superType : this.getSuperTypes(oldSuperType)) {
                queue.add(StringsKt.replace$default((String)sig, (String)oldSuperType, (String)superType, (boolean)false, (int)4, null));
            }
        }
        return oldApi;
    }

    private final String[] getSuperTypes(String type) {
        return switch (type) {
            case "org/jetbrains/kotlin/analysis/api/KaConstantInitializerValue" -> {
                String[] var3_3 = new String[]{"org/jetbrains/kotlin/analysis/api/KaInitializerValue"};
                yield var3_3;
            }
            case "org/jetbrains/kotlin/analysis/api/KaConstantValueForAnnotation" -> {
                String[] var3_4 = new String[]{"org/jetbrains/kotlin/analysis/api/KaInitializerValue"};
                yield var3_4;
            }
            case "org/jetbrains/kotlin/analysis/api/KaNonConstantInitializerValue" -> {
                String[] var3_5 = new String[]{"org/jetbrains/kotlin/analysis/api/KaInitializerValue"};
                yield var3_5;
            }
            case "org/jetbrains/kotlin/analysis/api/KaSession" -> {
                String[] var3_6 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner", "org/jetbrains/kotlin/analysis/api/KaResolver", "org/jetbrains/kotlin/analysis/api/KaSymbolRelationProvider", "org/jetbrains/kotlin/analysis/api/KaDiagnosticProvider", "org/jetbrains/kotlin/analysis/api/KaScopeProvider", "org/jetbrains/kotlin/analysis/api/KaCompletionCandidateChecker", "org/jetbrains/kotlin/analysis/api/KaExpressionTypeProvider", "org/jetbrains/kotlin/analysis/api/KaTypeProvider", "org/jetbrains/kotlin/analysis/api/KaTypeInformationProvider", "org/jetbrains/kotlin/analysis/api/KaSymbolProvider", "org/jetbrains/kotlin/analysis/api/KaJavaInteroperabilityComponent", "org/jetbrains/kotlin/analysis/api/KaSymbolInformationProvider", "org/jetbrains/kotlin/analysis/api/KaTypeRelationChecker", "org/jetbrains/kotlin/analysis/api/KaExpressionInformationProvider", "org/jetbrains/kotlin/analysis/api/KaEvaluator", "org/jetbrains/kotlin/analysis/api/KaReferenceShortener", "org/jetbrains/kotlin/analysis/api/KaImportOptimizer", "org/jetbrains/kotlin/analysis/api/KaRenderer", "org/jetbrains/kotlin/analysis/api/KaVisibilityChecker", "org/jetbrains/kotlin/analysis/api/KaOriginalPsiProvider", "org/jetbrains/kotlin/analysis/api/KaTypeCreator", "org/jetbrains/kotlin/analysis/api/KaAnalysisScopeProvider", "org/jetbrains/kotlin/analysis/api/KaSignatureSubstitutor", "org/jetbrains/kotlin/analysis/api/KaResolveExtensionInfoProvider", "org/jetbrains/kotlin/analysis/api/KaCompilerPluginGeneratedDeclarationsProvider", "org/jetbrains/kotlin/analysis/api/KaCompilerFacility", "org/jetbrains/kotlin/analysis/api/KaMetadataCalculator", "org/jetbrains/kotlin/analysis/api/KaSubstitutorProvider", "org/jetbrains/kotlin/analysis/api/KaDataFlowProvider", "org/jetbrains/kotlin/analysis/api/KaSourceProvider"};
                yield var3_6;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotation" -> {
                String[] var3_7 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_7;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationList" -> {
                String[] var3_8 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_8;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue" -> {
                String[] var3_9 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_9;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaNamedAnnotationValue" -> {
                String[] var3_10 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_10;
            }
            case "org/jetbrains/kotlin/analysis/api/base/KaContextReceiver" -> {
                String[] var3_11 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_11;
            }
            case "org/jetbrains/kotlin/analysis/api/base/KaContextReceiversOwner" -> {
                String[] var3_12 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_12;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes" -> {
                String[] var3_13 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_13;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaClassTypeBuilder" -> {
                String[] var3_14 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaTypeBuilder"};
                yield var3_14;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaCompilerPluginGeneratedDeclarations" -> {
                String[] var3_15 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_15;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaExtensionApplicabilityResult" -> {
                String[] var3_16 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_16;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaImplicitReceiver" -> {
                String[] var3_17 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_17;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaImplicitReceiverSmartCast" -> {
                String[] var3_18 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_18;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaScopeContext" -> {
                String[] var3_19 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_19;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaScopeWithKind" -> {
                String[] var3_20 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_20;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaScopeWithKindImpl" -> {
                String[] var3_21 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaScopeWithKind"};
                yield var3_21;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaSmartCastInfo" -> {
                String[] var3_22 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_22;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaSubstitutorBuilder" -> {
                String[] var3_23 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_23;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaTypeBuilder" -> {
                String[] var3_24 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_24;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaTypeParameterTypeBuilder" -> {
                String[] var3_25 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaTypeBuilder"};
                yield var3_25;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractCallsInPlaceContractEffectDeclaration" -> {
                String[] var3_26 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractEffectDeclaration"};
                yield var3_26;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractConditionalContractEffectDeclaration" -> {
                String[] var3_27 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractEffectDeclaration"};
                yield var3_27;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractConstantValue" -> {
                String[] var3_28 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_28;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractEffectDeclaration" -> {
                String[] var3_29 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_29;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractParameterValue" -> {
                String[] var3_30 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_30;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractReturnsContractEffectDeclaration" -> {
                String[] var3_31 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractEffectDeclaration"};
                yield var3_31;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractReturnsNotNullEffectDeclaration" -> {
                String[] var3_32 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractReturnsContractEffectDeclaration"};
                yield var3_32;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractReturnsSpecificValueEffectDeclaration" -> {
                String[] var3_33 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractReturnsContractEffectDeclaration"};
                yield var3_33;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractReturnsSuccessfullyEffectDeclaration" -> {
                String[] var3_34 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractReturnsContractEffectDeclaration"};
                yield var3_34;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBinaryLogicExpression" -> {
                String[] var3_35 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanExpression"};
                yield var3_35;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanConstantExpression" -> {
                String[] var3_36 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanExpression"};
                yield var3_36;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanExpression" -> {
                String[] var3_37 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_37;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanValueParameterExpression" -> {
                String[] var3_38 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanExpression"};
                yield var3_38;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractIsInstancePredicateExpression" -> {
                String[] var3_39 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanExpression"};
                yield var3_39;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractIsNullPredicateExpression" -> {
                String[] var3_40 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanExpression"};
                yield var3_40;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractLogicalNotExpression" -> {
                String[] var3_41 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanExpression"};
                yield var3_41;
            }
            case "org/jetbrains/kotlin/analysis/api/descriptors/symbols/descriptorBased/KaDefaultValueParameterSymbol" -> {
                String[] var3_42 = new String[]{"org/jetbrains/kotlin/analysis/api/descriptors/symbols/descriptorBased/KaValueParameterSymbol"};
                yield var3_42;
            }
            case "org/jetbrains/kotlin/analysis/api/descriptors/symbols/psiBased/KaDefaultValueParameterSymbol" -> {
                String[] var3_43 = new String[]{"org/jetbrains/kotlin/analysis/api/descriptors/symbols/psiBased/KaValueParameterSymbol"};
                yield var3_43;
            }
            case "org/jetbrains/kotlin/analysis/api/diagnostics/KaDiagnostic" -> {
                String[] var3_44 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_44;
            }
            case "org/jetbrains/kotlin/analysis/api/diagnostics/KaDiagnosticWithPsi" -> {
                String[] var3_45 = new String[]{"org/jetbrains/kotlin/analysis/api/diagnostics/KaDiagnostic"};
                yield var3_45;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/components/KaLazyCompletionExtensionCandidateChecker" -> {
                String[] var3_46 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaCompletionExtensionCandidateChecker"};
                yield var3_46;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic0Impl" -> {
                String[] var3_47 = new String[]{"org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic0"};
                yield var3_47;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic1Impl" -> {
                String[] var3_48 = new String[]{"org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic1"};
                yield var3_48;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic2Impl" -> {
                String[] var3_49 = new String[]{"org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic2"};
                yield var3_49;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic3Impl" -> {
                String[] var3_50 = new String[]{"org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic3"};
                yield var3_50;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic4Impl" -> {
                String[] var3_51 = new String[]{"org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic4"};
                yield var3_51;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/symbols/pointers/KaTopLevelCallableSymbolPointer" -> {
                String[] var3_52 = new String[]{"org/jetbrains/kotlin/analysis/api/fir/symbols/pointers/KaSymbolPointer"};
                yield var3_52;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/utils/KaGenericTypePointer" -> {
                String[] var3_53 = new String[]{"org/jetbrains/kotlin/analysis/api/fir/utils/KaTypePointer"};
                yield var3_53;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaBaseContextReceiver" -> {
                String[] var3_54 = new String[]{"org/jetbrains/kotlin/analysis/api/base/KaContextReceiver"};
                yield var3_54;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaBaseSession" -> {
                String[] var3_55 = new String[]{"org/jetbrains/kotlin/analysis/api/KaSession", "org/jetbrains/kotlin/analysis/api/impl/base/KaResolver", "org/jetbrains/kotlin/analysis/api/impl/base/KaSymbolRelationProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaDiagnosticProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaScopeProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaCompletionCandidateChecker", "org/jetbrains/kotlin/analysis/api/impl/base/KaExpressionTypeProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaTypeProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaTypeInformationProvider", "org/jetbrains/kotlin/analysis/api/symbols/KaSymbolProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaJavaInteroperabilityComponent", "org/jetbrains/kotlin/analysis/api/impl/base/KaSymbolInformationProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaTypeRelationChecker", "org/jetbrains/kotlin/analysis/api/impl/base/KaExpressionInformationProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaEvaluator", "org/jetbrains/kotlin/analysis/api/impl/base/KaReferenceShortener", "org/jetbrains/kotlin/analysis/api/impl/base/KaImportOptimizer", "org/jetbrains/kotlin/analysis/api/impl/base/KaRenderer", "org/jetbrains/kotlin/analysis/api/impl/base/KaVisibilityChecker", "org/jetbrains/kotlin/analysis/api/impl/base/KaOriginalPsiProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaTypeCreator", "org/jetbrains/kotlin/analysis/api/impl/base/KaAnalysisScopeProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaSignatureSubstitutor", "org/jetbrains/kotlin/analysis/api/impl/base/KaResolveExtensionInfoProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaCompilerPluginGeneratedDeclarationsProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaCompilerFacility", "org/jetbrains/kotlin/analysis/api/impl/base/KaMetadataCalculator", "org/jetbrains/kotlin/analysis/api/impl/base/KaSubstitutorProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaDataFlowProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaSourceProvider"};
                yield var3_55;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaBooleanConstantValueImpl" -> {
                String[] var3_56 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$BooleanValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaBooleanConstantValue"};
                yield var3_56;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaByteConstantValueImpl" -> {
                String[] var3_57 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$ByteValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaByteConstantValue"};
                yield var3_57;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaChainedSubstitutor" -> {
                String[] var3_58 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaSubstitutor"};
                yield var3_58;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaCharConstantValueImpl" -> {
                String[] var3_59 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$CharValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaCharConstantValue"};
                yield var3_59;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaDoubleConstantValueImpl" -> {
                String[] var3_60 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$DoubleValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaDoubleConstantValue"};
                yield var3_60;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaErrorConstantValueImpl" -> {
                String[] var3_61 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$ErrorValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaErrorConstantValue"};
                yield var3_61;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaFloatConstantValueImpl" -> {
                String[] var3_62 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$FloatValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaFloatConstantValue"};
                yield var3_62;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaIntConstantValueImpl" -> {
                String[] var3_63 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$IntValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaIntConstantValue"};
                yield var3_63;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaLongConstantValueImpl" -> {
                String[] var3_64 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$LongValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaLongConstantValue"};
                yield var3_64;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaMapBackedSubstitutor" -> {
                String[] var3_65 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaSubstitutor"};
                yield var3_65;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaNullConstantValueImpl" -> {
                String[] var3_66 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$NullValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaNullConstantValue"};
                yield var3_66;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaShortConstantValueImpl" -> {
                String[] var3_67 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$ShortValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaShortConstantValue"};
                yield var3_67;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaStringConstantValueImpl" -> {
                String[] var3_68 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$StringValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaStringConstantValue"};
                yield var3_68;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaUnsignedByteConstantValueImpl" -> {
                String[] var3_69 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$UByteValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaUnsignedByteConstantValue"};
                yield var3_69;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaUnsignedIntConstantValueImpl" -> {
                String[] var3_70 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$UIntValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaUnsignedIntConstantValue"};
                yield var3_70;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaUnsignedLongConstantValueImpl" -> {
                String[] var3_71 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$ULongValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaUnsignedLongConstantValue"};
                yield var3_71;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaUnsignedShortConstantValueImpl" -> {
                String[] var3_72 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$UShortValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaUnsignedShortConstantValue"};
                yield var3_72;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaAnnotationImpl" -> {
                String[] var3_73 = new String[]{"org/jetbrains/kotlin/analysis/api/annotations/KaAnnotation"};
                yield var3_73;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaArrayAnnotationValueImpl" -> {
                String[] var3_74 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaAnnotationValue$ArrayValue"};
                yield var3_74;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaBaseEmptyAnnotationList" -> {
                String[] var3_75 = new String[]{"org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationList"};
                yield var3_75;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaBaseNamedAnnotationValue" -> {
                String[] var3_76 = new String[]{"org/jetbrains/kotlin/analysis/api/annotations/KaNamedAnnotationValue"};
                yield var3_76;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaClassLiteralAnnotationValueImpl" -> {
                String[] var3_77 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaAnnotationValue$ClassLiteralValue"};
                yield var3_77;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaConstantAnnotationValueImpl" -> {
                String[] var3_78 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaAnnotationValue$ConstantValue"};
                yield var3_78;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaEnumEntryAnnotationValueImpl" -> {
                String[] var3_79 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaAnnotationValue$EnumEntryValue"};
                yield var3_79;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaNestedAnnotationAnnotationValueImpl" -> {
                String[] var3_80 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaAnnotationValue$NestedAnnotationValue"};
                yield var3_80;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaUnsupportedAnnotationValueImpl" -> {
                String[] var3_81 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaAnnotationValue$UnsupportedValue"};
                yield var3_81;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaAbstractResolver" -> {
                String[] var3_82 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/components/KaSessionComponent", "org/jetbrains/kotlin/analysis/api/components/KaResolver"};
                yield var3_82;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaAbstractSignatureSubstitutor" -> {
                String[] var3_83 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/components/KaSessionComponent", "org/jetbrains/kotlin/analysis/api/components/KaSignatureSubstitutor"};
                yield var3_83;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaAnalysisScopeProviderImpl" -> {
                String[] var3_84 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/components/KaSessionComponent", "org/jetbrains/kotlin/analysis/api/components/KaAnalysisScopeProvider"};
                yield var3_84;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseClassTypeBuilder" -> {
                String[] var3_85 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaClassTypeBuilder"};
                yield var3_85;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseCompilerPluginGeneratedDeclarations" -> {
                String[] var3_86 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaCompilerPluginGeneratedDeclarations"};
                yield var3_86;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseImplicitReceiver" -> {
                String[] var3_87 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaImplicitReceiver"};
                yield var3_87;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseImplicitReceiverSmartCast" -> {
                String[] var3_88 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaImplicitReceiverSmartCast"};
                yield var3_88;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseScopeContext" -> {
                String[] var3_89 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaScopeContext"};
                yield var3_89;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseSmartCastInfo" -> {
                String[] var3_90 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaSmartCastInfo"};
                yield var3_90;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseSymbolProvider" -> {
                String[] var3_91 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/components/KaSessionComponent", "org/jetbrains/kotlin/analysis/api/symbols/KaSymbolProvider"};
                yield var3_91;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseTypeCreator" -> {
                String[] var3_92 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/components/KaSessionComponent", "org/jetbrains/kotlin/analysis/api/components/KaTypeCreator"};
                yield var3_92;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseTypeParameterTypeBuilder" -> {
                String[] var3_93 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaTypeParameterTypeBuilder"};
                yield var3_93;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseTypeRelationChecker" -> {
                String[] var3_94 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/components/KaSessionComponent", "org/jetbrains/kotlin/analysis/api/components/KaTypeRelationChecker"};
                yield var3_94;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaRendererImpl" -> {
                String[] var3_95 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaRenderer", "org/jetbrains/kotlin/analysis/api/impl/base/components/KaSessionComponent"};
                yield var3_95;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaSessionComponent" -> {
                String[] var3_96 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_96;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/KaBaseContractCallsInPlaceContractEffectDeclaration" -> {
                String[] var3_97 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractCallsInPlaceContractEffectDeclaration"};
                yield var3_97;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/KaBaseContractConditionalContractEffectDeclaration" -> {
                String[] var3_98 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractConditionalContractEffectDeclaration"};
                yield var3_98;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/KaBaseContractConstantValue" -> {
                String[] var3_99 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractConstantValue"};
                yield var3_99;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/KaBaseContractParameterValue" -> {
                String[] var3_100 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractParameterValue"};
                yield var3_100;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/KaBaseContractReturnsNotNullEffectDeclaration" -> {
                String[] var3_101 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractReturnsContractEffectDeclaration$KaContractReturnsNotNullEffectDeclaration"};
                yield var3_101;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/KaBaseContractReturnsSpecificValueEffectDeclaration" -> {
                String[] var3_102 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractReturnsContractEffectDeclaration$KaContractReturnsSpecificValueEffectDeclaration"};
                yield var3_102;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/KaBaseContractReturnsSuccessfullyEffectDeclaration" -> {
                String[] var3_103 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractReturnsContractEffectDeclaration$KaContractReturnsSuccessfullyEffectDeclaration"};
                yield var3_103;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/booleans/KaBaseContractBinaryLogicExpression" -> {
                String[] var3_104 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBinaryLogicExpression"};
                yield var3_104;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/booleans/KaBaseContractBooleanConstantExpression" -> {
                String[] var3_105 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanConstantExpression"};
                yield var3_105;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/booleans/KaBaseContractBooleanValueParameterExpression" -> {
                String[] var3_106 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanValueParameterExpression"};
                yield var3_106;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/booleans/KaBaseContractIsInstancePredicateExpression" -> {
                String[] var3_107 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractIsInstancePredicateExpression"};
                yield var3_107;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/booleans/KaBaseContractIsNullPredicateExpression" -> {
                String[] var3_108 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractIsNullPredicateExpression"};
                yield var3_108;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/booleans/KaBaseContractLogicalNotExpression" -> {
                String[] var3_109 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractLogicalNotExpression"};
                yield var3_109;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/lifetime/KaBaseLifetimeTracker" -> {
                String[] var3_110 = new String[]{"org/jetbrains/kotlin/analysis/api/platform/lifetime/KaLifetimeTracker"};
                yield var3_110;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/permissions/KaBaseAnalysisPermissionChecker" -> {
                String[] var3_111 = new String[]{"org/jetbrains/kotlin/analysis/api/platform/permissions/KaAnalysisPermissionChecker"};
                yield var3_111;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/projectStructure/KaBaseModuleProvider" -> {
                String[] var3_112 = new String[]{"org/jetbrains/kotlin/analysis/api/projectStructure/KaModuleProvider"};
                yield var3_112;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/projectStructure/KaBuiltinsModuleImpl" -> {
                String[] var3_113 = new String[]{"org/jetbrains/kotlin/analysis/api/projectStructure/KaBuiltinsModule"};
                yield var3_113;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/references/KaBaseSimpleNameReference" -> {
                String[] var3_114 = new String[]{"org/jetbrains/kotlin/idea/references/KtSimpleNameReference"};
                yield var3_114;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseAnnotationCall" -> {
                String[] var3_115 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaAnnotationCall"};
                yield var3_115;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseApplicableCallCandidateInfo" -> {
                String[] var3_116 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaApplicableCallCandidateInfo"};
                yield var3_116;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseCompoundArrayAccessCall" -> {
                String[] var3_117 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCompoundArrayAccessCall", "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundAccessCall"};
                yield var3_117;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseCompoundAssignOperation" -> {
                String[] var3_118 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCompoundAssignOperation"};
                yield var3_118;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseCompoundUnaryOperation" -> {
                String[] var3_119 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCompoundUnaryOperation"};
                yield var3_119;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseCompoundVariableAccessCall" -> {
                String[] var3_120 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCompoundVariableAccessCall"};
                yield var3_120;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseDelegatedConstructorCall" -> {
                String[] var3_121 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaDelegatedConstructorCall"};
                yield var3_121;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseErrorCallInfo" -> {
                String[] var3_122 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaErrorCallInfo"};
                yield var3_122;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseExplicitReceiverValue" -> {
                String[] var3_123 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaExplicitReceiverValue"};
                yield var3_123;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseImplicitReceiverValue" -> {
                String[] var3_124 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaImplicitReceiverValue"};
                yield var3_124;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseInapplicableCallCandidateInfo" -> {
                String[] var3_125 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaInapplicableCallCandidateInfo"};
                yield var3_125;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBasePartiallyAppliedSymbol" -> {
                String[] var3_126 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaPartiallyAppliedSymbol"};
                yield var3_126;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseSimpleFunctionCall" -> {
                String[] var3_127 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaSimpleFunctionCall"};
                yield var3_127;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseSimpleVariableAccessCall" -> {
                String[] var3_128 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaSimpleVariableAccessCall"};
                yield var3_128;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseSimpleVariableWriteAccess" -> {
                String[] var3_129 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaSimpleVariableAccess$Write"};
                yield var3_129;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseSmartCastedReceiverValue" -> {
                String[] var3_130 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaSmartCastedReceiverValue"};
                yield var3_130;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseSuccessCallInfo" -> {
                String[] var3_131 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaSuccessCallInfo"};
                yield var3_131;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/scopes/KaBaseCompositeScope" -> {
                String[] var3_132 = new String[]{"org/jetbrains/kotlin/analysis/api/scopes/KaScope"};
                yield var3_132;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/scopes/KaBaseCompositeTypeScope" -> {
                String[] var3_133 = new String[]{"org/jetbrains/kotlin/analysis/api/scopes/KaTypeScope"};
                yield var3_133;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/scopes/KaBaseEmptyScope" -> {
                String[] var3_134 = new String[]{"org/jetbrains/kotlin/analysis/api/scopes/KaScope"};
                yield var3_134;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/sessions/KaBaseSessionProvider" -> {
                String[] var3_135 = new String[]{"org/jetbrains/kotlin/analysis/api/session/KaSessionProvider"};
                yield var3_135;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/sessions/KaGlobalSearchScope" -> {
                String[] var3_136 = new String[]{"com/intellij/psi/search/GlobalSearchScope"};
                yield var3_136;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaBasePropertyAccessorSymbolPointer" -> {
                String[] var3_137 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaSymbolPointer"};
                yield var3_137;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaBasePropertyGetterSymbolPointer" -> {
                String[] var3_138 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaBasePropertyAccessorSymbolPointer"};
                yield var3_138;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaBasePropertySetterSymbolPointer" -> {
                String[] var3_139 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaBasePropertyAccessorSymbolPointer"};
                yield var3_139;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaBaseReceiverParameterSymbolPointer" -> {
                String[] var3_140 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaSymbolPointer"};
                yield var3_140;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaBaseValueParameterFromDefaultSetterSymbolPointer" -> {
                String[] var3_141 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaSymbolPointer"};
                yield var3_141;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/types/KaBaseResolvedClassTypeQualifier" -> {
                String[] var3_142 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaResolvedClassTypeQualifier"};
                yield var3_142;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/types/KaBaseStarTypeProjection" -> {
                String[] var3_143 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaStarTypeProjection"};
                yield var3_143;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/types/KaBaseTypeArgumentWithVariance" -> {
                String[] var3_144 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaTypeArgumentWithVariance"};
                yield var3_144;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/types/KaBaseUnresolvedClassTypeQualifier" -> {
                String[] var3_145 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaUnresolvedClassTypeQualifier"};
                yield var3_145;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/util/KaBaseCompiledFileForOutputFile" -> {
                String[] var3_146 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaCompiledFile"};
                yield var3_146;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/util/KaNonBoundToPsiErrorDiagnostic" -> {
                String[] var3_147 = new String[]{"org/jetbrains/kotlin/analysis/api/diagnostics/KaDiagnostic"};
                yield var3_147;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/util/KaSessionCreationContextImpl" -> {
                String[] var3_148 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/util/KaSessionCreationContext"};
                yield var3_148;
            }
            case "org/jetbrains/kotlin/analysis/api/lifetime/KaInaccessibleLifetimeOwnerAccessException" -> {
                String[] var3_149 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaIllegalLifetimeOwnerAccessException"};
                yield var3_149;
            }
            case "org/jetbrains/kotlin/analysis/api/lifetime/KaInvalidLifetimeOwnerAccessException" -> {
                String[] var3_150 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaIllegalLifetimeOwnerAccessException"};
                yield var3_150;
            }
            case "org/jetbrains/kotlin/analysis/api/permissions/KaAnalysisPermissionRegistryImpl" -> {
                String[] var3_151 = new String[]{"org/jetbrains/kotlin/analysis/api/permissions/KaAnalysisPermissionRegistry"};
                yield var3_151;
            }
            case "org/jetbrains/kotlin/analysis/api/platform/lifetime/KaLifetimeTracker" -> {
                String[] var3_152 = new String[]{"org/jetbrains/kotlin/analysis/api/platform/KaEngineService"};
                yield var3_152;
            }
            case "org/jetbrains/kotlin/analysis/api/platform/modification/KaSourceModificationService" -> {
                String[] var3_153 = new String[]{"org/jetbrains/kotlin/analysis/api/platform/KaEngineService"};
                yield var3_153;
            }
            case "org/jetbrains/kotlin/analysis/api/platform/permissions/KaAnalysisPermissionChecker" -> {
                String[] var3_154 = new String[]{"org/jetbrains/kotlin/analysis/api/platform/KaEngineService"};
                yield var3_154;
            }
            case "org/jetbrains/kotlin/analysis/api/platform/projectStructure/KaDanglingFileModuleImpl" -> {
                String[] var3_155 = new String[]{"org/jetbrains/kotlin/analysis/api/projectStructure/KaDanglingFileModule"};
                yield var3_155;
            }
            case "org/jetbrains/kotlin/analysis/api/projectStructure/KaBuiltinsModule" -> {
                String[] var3_156 = new String[]{"org/jetbrains/kotlin/analysis/api/projectStructure/KaModule"};
                yield var3_156;
            }
            case "org/jetbrains/kotlin/analysis/api/projectStructure/KaDanglingFileModule" -> {
                String[] var3_157 = new String[]{"org/jetbrains/kotlin/analysis/api/projectStructure/KaModule"};
                yield var3_157;
            }
            case "org/jetbrains/kotlin/analysis/api/projectStructure/KaLibraryModule" -> {
                String[] var3_158 = new String[]{"org/jetbrains/kotlin/analysis/api/projectStructure/KaModule"};
                yield var3_158;
            }
            case "org/jetbrains/kotlin/analysis/api/projectStructure/KaLibrarySourceModule" -> {
                String[] var3_159 = new String[]{"org/jetbrains/kotlin/analysis/api/projectStructure/KaModule"};
                yield var3_159;
            }
            case "org/jetbrains/kotlin/analysis/api/projectStructure/KaNotUnderContentRootModule" -> {
                String[] var3_160 = new String[]{"org/jetbrains/kotlin/analysis/api/projectStructure/KaModule"};
                yield var3_160;
            }
            case "org/jetbrains/kotlin/analysis/api/projectStructure/KaScriptDependencyModule" -> {
                String[] var3_161 = new String[]{"org/jetbrains/kotlin/analysis/api/projectStructure/KaModule"};
                yield var3_161;
            }
            case "org/jetbrains/kotlin/analysis/api/projectStructure/KaScriptModule" -> {
                String[] var3_162 = new String[]{"org/jetbrains/kotlin/analysis/api/projectStructure/KaModule"};
                yield var3_162;
            }
            case "org/jetbrains/kotlin/analysis/api/projectStructure/KaSourceModule" -> {
                String[] var3_163 = new String[]{"org/jetbrains/kotlin/analysis/api/projectStructure/KaModule"};
                yield var3_163;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KaClassifierBodyWithMembersRenderer" -> {
                String[] var3_164 = new String[]{"org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KaClassifierBodyRenderer"};
                yield var3_164;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaAnnotationCall" -> {
                String[] var3_165 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall"};
                yield var3_165;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaApplicableCallCandidateInfo" -> {
                String[] var3_166 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCallCandidateInfo"};
                yield var3_166;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaCall" -> {
                String[] var3_167 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_167;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaCallCandidateInfo" -> {
                String[] var3_168 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_168;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaCallInfo" -> {
                String[] var3_169 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_169;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaCallableMemberCall" -> {
                String[] var3_170 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCall"};
                yield var3_170;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundArrayAccessCall" -> {
                String[] var3_171 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCall", "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundAccessCall"};
                yield var3_171;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundAssignOperation" -> {
                String[] var3_172 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCompoundOperation"};
                yield var3_172;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundOperation" -> {
                String[] var3_173 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_173;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundUnaryOperation" -> {
                String[] var3_174 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCompoundOperation"};
                yield var3_174;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundVariableAccessCall" -> {
                String[] var3_175 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCall", "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundAccessCall"};
                yield var3_175;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaDelegatedConstructorCall" -> {
                String[] var3_176 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall"};
                yield var3_176;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaErrorCallInfo" -> {
                String[] var3_177 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCallInfo"};
                yield var3_177;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaExplicitReceiverValue" -> {
                String[] var3_178 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaReceiverValue"};
                yield var3_178;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall" -> {
                String[] var3_179 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCallableMemberCall"};
                yield var3_179;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaImplicitReceiverValue" -> {
                String[] var3_180 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaReceiverValue"};
                yield var3_180;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaInapplicableCallCandidateInfo" -> {
                String[] var3_181 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCallCandidateInfo"};
                yield var3_181;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedSymbol" -> {
                String[] var3_182 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_182;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaReceiverValue" -> {
                String[] var3_183 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_183;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaSimpleFunctionCall" -> {
                String[] var3_184 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall"};
                yield var3_184;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaSimpleVariableAccessCall" -> {
                String[] var3_185 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaVariableAccessCall"};
                yield var3_185;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaSmartCastedReceiverValue" -> {
                String[] var3_186 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaReceiverValue"};
                yield var3_186;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaSuccessCallInfo" -> {
                String[] var3_187 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCallInfo"};
                yield var3_187;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaSymbolBasedReference" -> {
                String[] var3_188 = new String[]{"org/jetbrains/kotlin/idea/references/KtReference"};
                yield var3_188;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaVariableAccessCall" -> {
                String[] var3_189 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCallableMemberCall"};
                yield var3_189;
            }
            case "org/jetbrains/kotlin/analysis/api/resolve/extensions/KaResolveExtension" -> {
                String[] var3_190 = new String[]{"com/intellij/openapi/Disposable"};
                yield var3_190;
            }
            case "org/jetbrains/kotlin/analysis/api/scopes/KaScope" -> {
                String[] var3_191 = new String[]{"org/jetbrains/kotlin/analysis/api/scopes/KaScopeLike"};
                yield var3_191;
            }
            case "org/jetbrains/kotlin/analysis/api/scopes/KaScopeLike" -> {
                String[] var3_192 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_192;
            }
            case "org/jetbrains/kotlin/analysis/api/scopes/KaTypeScope" -> {
                String[] var3_193 = new String[]{"org/jetbrains/kotlin/analysis/api/scopes/KaScopeLike"};
                yield var3_193;
            }
            case "org/jetbrains/kotlin/analysis/api/session/KaSessionProvider" -> {
                String[] var3_194 = new String[]{"com/intellij/openapi/Disposable"};
                yield var3_194;
            }
            case "org/jetbrains/kotlin/analysis/api/signatures/KaCallableSignature" -> {
                String[] var3_195 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_195;
            }
            case "org/jetbrains/kotlin/analysis/api/signatures/KaFunctionSignature" -> {
                String[] var3_196 = new String[]{"org/jetbrains/kotlin/analysis/api/signatures/KaCallableSignature"};
                yield var3_196;
            }
            case "org/jetbrains/kotlin/analysis/api/signatures/KaVariableSignature" -> {
                String[] var3_197 = new String[]{"org/jetbrains/kotlin/analysis/api/signatures/KaCallableSignature"};
                yield var3_197;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaAnonymousFunctionSymbol" -> {
                String[] var3_198 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol"};
                yield var3_198;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaAnonymousObjectSymbol" -> {
                String[] var3_199 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol"};
                yield var3_199;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaBackingFieldSymbol" -> {
                String[] var3_200 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaVariableSymbol"};
                yield var3_200;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol" -> {
                String[] var3_201 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol", "org/jetbrains/kotlin/analysis/api/base/KaContextReceiversOwner"};
                yield var3_201;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaClassInitializerSymbol" -> {
                String[] var3_202 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol"};
                yield var3_202;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaClassLikeSymbol" -> {
                String[] var3_203 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaClassifierSymbol"};
                yield var3_203;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol" -> {
                String[] var3_204 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaClassLikeSymbol", "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationContainerSymbol"};
                yield var3_204;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaClassifierSymbol" -> {
                String[] var3_205 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaSymbol", "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol"};
                yield var3_205;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaConstructorSymbol" -> {
                String[] var3_206 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol", "org/jetbrains/kotlin/analysis/api/symbols/markers/KaTypeParameterOwnerSymbol"};
                yield var3_206;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol" -> {
                String[] var3_207 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaSymbol", "org/jetbrains/kotlin/analysis/api/symbols/markers/KaAnnotatedSymbol"};
                yield var3_207;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaDestructuringDeclarationSymbol" -> {
                String[] var3_208 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol"};
                yield var3_208;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaEnumEntryInitializerSymbol" -> {
                String[] var3_209 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationContainerSymbol"};
                yield var3_209;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaEnumEntrySymbol" -> {
                String[] var3_210 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaVariableSymbol"};
                yield var3_210;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaFileSymbol" -> {
                String[] var3_211 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/markers/KaAnnotatedSymbol"};
                yield var3_211;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol" -> {
                String[] var3_212 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol"};
                yield var3_212;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaJavaFieldSymbol" -> {
                String[] var3_213 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaVariableSymbol"};
                yield var3_213;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaKotlinPropertySymbol" -> {
                String[] var3_214 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaPropertySymbol"};
                yield var3_214;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaLocalVariableSymbol" -> {
                String[] var3_215 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaVariableSymbol"};
                yield var3_215;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaNamedClassSymbol" -> {
                String[] var3_216 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol", "org/jetbrains/kotlin/analysis/api/symbols/KaTypeParameterOwnerSymbol", "org/jetbrains/kotlin/analysis/api/symbols/KaNamedSymbol", "org/jetbrains/kotlin/analysis/api/base/KaContextReceiversOwner"};
                yield var3_216;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaNamedFunctionSymbol" -> {
                String[] var3_217 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol", "org/jetbrains/kotlin/analysis/api/symbols/markers/KaNamedSymbol", "org/jetbrains/kotlin/analysis/api/symbols/markers/KaTypeParameterOwnerSymbol"};
                yield var3_217;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaPackageSymbol" -> {
                String[] var3_218 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaSymbol"};
                yield var3_218;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaParameterSymbol" -> {
                String[] var3_219 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaVariableSymbol"};
                yield var3_219;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaPropertyAccessorSymbol" -> {
                String[] var3_220 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol"};
                yield var3_220;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaPropertyGetterSymbol" -> {
                String[] var3_221 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaPropertyAccessorSymbol"};
                yield var3_221;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaPropertySetterSymbol" -> {
                String[] var3_222 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaPropertyAccessorSymbol"};
                yield var3_222;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaPropertySymbol" -> {
                String[] var3_223 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaVariableSymbol", "org/jetbrains/kotlin/analysis/api/symbols/KaTypeParameterOwnerSymbol"};
                yield var3_223;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaReceiverParameterSymbol" -> {
                String[] var3_224 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaParameterSymbol"};
                yield var3_224;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaSamConstructorSymbol" -> {
                String[] var3_225 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol", "org/jetbrains/kotlin/analysis/api/symbols/markers/KaNamedSymbol", "org/jetbrains/kotlin/analysis/api/symbols/markers/KaTypeParameterOwnerSymbol"};
                yield var3_225;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaScriptSymbol" -> {
                String[] var3_226 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol", "org/jetbrains/kotlin/analysis/api/symbols/markers/KaAnnotatedSymbol", "org/jetbrains/kotlin/analysis/api/symbols/markers/KaNamedSymbol", "org/jetbrains/kotlin/analysis/api/symbols/markers/KaDeclarationContainerSymbol"};
                yield var3_226;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaSymbol" -> {
                String[] var3_227 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_227;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaSyntheticJavaPropertySymbol" -> {
                String[] var3_228 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaPropertySymbol"};
                yield var3_228;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaTypeAliasSymbol" -> {
                String[] var3_229 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaClassLikeSymbol", "org/jetbrains/kotlin/analysis/api/symbols/KaNamedSymbol", "org/jetbrains/kotlin/analysis/api/symbols/KaTypeParameterOwnerSymbol"};
                yield var3_229;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaTypeParameterSymbol" -> {
                String[] var3_230 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaClassifierSymbol", "org/jetbrains/kotlin/analysis/api/symbols/KaNamedSymbol"};
                yield var3_230;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaValueParameterSymbol" -> {
                String[] var3_231 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaParameterSymbol", "org/jetbrains/kotlin/analysis/api/symbols/KaAnnotatedSymbol"};
                yield var3_231;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaVariableSymbol" -> {
                String[] var3_232 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol", "org/jetbrains/kotlin/analysis/api/symbols/KaNamedSymbol"};
                yield var3_232;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KaAnnotatedSymbol" -> {
                String[] var3_233 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaSymbol", "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotated"};
                yield var3_233;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KaDeclarationContainerSymbol" -> {
                String[] var3_234 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaSymbol"};
                yield var3_234;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KaPossiblyNamedSymbol" -> {
                String[] var3_235 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaSymbol"};
                yield var3_235;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KaSymbolWithKind" -> {
                String[] var3_236 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaSymbol"};
                yield var3_236;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KaTypeParameterOwnerSymbol" -> {
                String[] var3_237 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaSymbol"};
                yield var3_237;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/pointers/KaPsiBasedSymbolPointer" -> {
                String[] var3_238 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/pointers/KaSymbolPointer"};
                yield var3_238;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaCapturedType" -> {
                String[] var3_239 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaType"};
                yield var3_239;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaClassErrorType" -> {
                String[] var3_240 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaErrorType"};
                yield var3_240;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaClassType" -> {
                String[] var3_241 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaType"};
                yield var3_241;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaClassTypeQualifier" -> {
                String[] var3_242 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_242;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaDefinitelyNotNullType" -> {
                String[] var3_243 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaType"};
                yield var3_243;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaDynamicType" -> {
                String[] var3_244 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaType"};
                yield var3_244;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaErrorType" -> {
                String[] var3_245 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaType"};
                yield var3_245;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaFlexibleType" -> {
                String[] var3_246 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaType"};
                yield var3_246;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaFunctionType" -> {
                String[] var3_247 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaClassType", "org/jetbrains/kotlin/analysis/api/base/KaContextReceiversOwner"};
                yield var3_247;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaIntersectionType" -> {
                String[] var3_248 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaType"};
                yield var3_248;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaResolvedClassTypeQualifier" -> {
                String[] var3_249 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaClassTypeQualifier"};
                yield var3_249;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaStarTypeProjection" -> {
                String[] var3_250 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaTypeProjection"};
                yield var3_250;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaSubstitutor" -> {
                String[] var3_251 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_251;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaType" -> {
                String[] var3_252 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner", "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotated"};
                yield var3_252;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaTypeArgumentWithVariance" -> {
                String[] var3_253 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaTypeProjection"};
                yield var3_253;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaTypeParameterType" -> {
                String[] var3_254 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaType"};
                yield var3_254;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaTypeProjection" -> {
                String[] var3_255 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                yield var3_255;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaUnresolvedClassTypeQualifier" -> {
                String[] var3_256 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaClassTypeQualifier"};
                yield var3_256;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaUsualClassType" -> {
                String[] var3_257 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaClassType"};
                yield var3_257;
            }
            default -> new String[]{};
        };
    }

    private final String mapApi(String key, String oldApi) {
        return switch (key) {
            case "getAnnotations (Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationList;)" -> "";
            case "getAnnotationInfos (Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationList;)" -> "";
            case "getAnalysisSession (Lorg/jetbrains/kotlin/analysis/api/KaSession;)" -> "getUseSiteSession";
            case "getConstantValue (Lorg/jetbrains/kotlin/analysis/api/annotations/ConstantValue;)" -> "getValue";
            case "getAnnotationInfos (Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotated;)" -> "getAnnotations";
            case "getAnnotationsList (Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotated;)" -> "getAnnotations";
            case "annotationsByClassId (Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationList;Lorg/jetbrains/kotlin/name/ClassId;)" -> "get";
            case "getAnnotationClassIds (Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationList;)" -> "getClassIds";
            case "hasAnnotation (Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationList;Lorg/jetbrains/kotlin/name/ClassId;)" -> "contains";
            case "getAnnotationValue (Lorg/jetbrains/kotlin/analysis/api/annotations/NestedAnnotationValue;)" -> "getAnnotation";
            case "renderAsKotlinConstant (Lorg/jetbrains/kotlin/analysis/api/base/KaConstantValue;)" -> "render";
            case "getANY (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)" -> "getAny";
            case "getBOOLEAN (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)" -> "getBoolean";
            case "getBYTE (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)" -> "getByte";
            case "getCHAR (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)" -> "getChar";
            case "getDOUBLE (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)" -> "getDouble";
            case "getFLOAT (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)" -> "getFloat";
            case "getINT (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)" -> "getInt";
            case "getLONG (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)" -> "getLong";
            case "getNOTHING (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)" -> "getNothing";
            case "getNULLABLE_ANY (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)" -> "getNullableAny";
            case "getNULLABLE_NOTHING (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)" -> "getNullableNothing";
            case "getSHORT (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)" -> "getShort";
            case "getSTRING (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)" -> "getString";
            case "getTHROWABLE (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)" -> "getThrowable";
            case "getUNIT (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)" -> "getUnit";
            case "getExitPointSnapshot (Ljava/util/List;)" -> "computeExitPointSnapshot";
            case "collectDiagnosticsForFile (Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/analysis/api/components/KaDiagnosticCheckerFilter;)" -> "collectDiagnostics";
            case "getDiagnostics (Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/analysis/api/components/KaDiagnosticCheckerFilter;)" -> "diagnostic";
            case "getMissingCases (Lorg/jetbrains/kotlin/psi/KtWhenExpression;)" -> "computeMissingCases";
            case "getReturnTargetSymbol (Lorg/jetbrains/kotlin/psi/KtReturnExpression;)" -> "getTargetSymbol";
            case "getFunctionalType (Lorg/jetbrains/kotlin/psi/KtFunction;)" -> "getFunctionType";
            case "getKaType (Lorg/jetbrains/kotlin/psi/KtExpression;)" -> "getExpressionType";
            case "getKtType (Lorg/jetbrains/kotlin/psi/KtExpression;)" -> "getExpressionType";
            case "getReturnKaType (Lorg/jetbrains/kotlin/psi/KtDeclaration;)" -> "getReturnType";
            case "getReturnKtType (Lorg/jetbrains/kotlin/psi/KtDeclaration;)" -> "getReturnType";
            case "analyseImports (Lorg/jetbrains/kotlin/psi/KtFile;)" -> "analyzeImportsToOptimize";
            case "asKtType (Lcom/intellij/psi/PsiType;Lcom/intellij/psi/PsiElement;)" -> "asKaType";
            case "mapTypeToJvmType (Lorg/jetbrains/kotlin/analysis/api/types/KaType;Lorg/jetbrains/kotlin/load/kotlin/TypeMappingMode;)" -> "mapToJvmType";
            case "collectCallCandidates (Lorg/jetbrains/kotlin/psi/KtElement;)" -> "collectCallCandidatesOld";
            case "collectCallCandidatesOld (Lorg/jetbrains/kotlin/psi/KtElement;)" -> "resolveToCallCandidates";
            case "resolveCall (Lorg/jetbrains/kotlin/psi/KtElement;)" -> "resolveToCall";
            case "resolveCallOld (Lorg/jetbrains/kotlin/psi/KtElement;)" -> "resolveToCall";
            case "getScopeContextForPosition (Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/psi/KtElement;)" -> "scopeContext";
            case "getDeprecationStatus (Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;)" -> "deprecationStatus";
            case "getUnwrapFakeOverrides (Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;)" -> "getFakeOverrideOriginal";
            case "getExpandedClassSymbol (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)" -> "getExpandedSymbol";
            case "isAny (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)" -> "isAnyType";
            case "isBoolean (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)" -> "isBooleanType";
            case "isByte (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)" -> "isByteType";
            case "isChar (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)" -> "isCharType";
            case "isCharSequence (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)" -> "isCharSequenceType";
            case "isClassTypeWithClassId (Lorg/jetbrains/kotlin/analysis/api/types/KaType;Lorg/jetbrains/kotlin/name/ClassId;)" -> "isClassType";
            case "isDouble (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)" -> "isDoubleType";
            case "isFloat (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)" -> "isFloatType";
            case "isFunctionalInterfaceType (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)" -> "isFunctionalInterface";
            case "isInt (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)" -> "isIntType";
            case "isLong (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)" -> "isLongType";
            case "isNothing (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)" -> "isNothingType";
            case "isShort (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)" -> "isShortType";
            case "isString (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)" -> "isStringType";
            case "isUByte (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)" -> "isUByteType";
            case "isUInt (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)" -> "isUIntType";
            case "isULong (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)" -> "isULongType";
            case "isUShort (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)" -> "isUShortType";
            case "isUnit (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)" -> "isUnitType";
            case "buildSelfClassType (Lorg/jetbrains/kotlin/analysis/api/symbols/KaNamedClassSymbol;)" -> "getDefaultType";
            case "getAllSuperTypes (Lorg/jetbrains/kotlin/analysis/api/types/KaType;Z)" -> "allSupertypes";
            case "getDirectSuperTypes (Lorg/jetbrains/kotlin/analysis/api/types/KaType;Z)" -> "directSuperTypes";
            case "getImplicitReceiverTypesAtPosition (Lorg/jetbrains/kotlin/psi/KtElement;)" -> "collectImplicitReceiverTypes";
            case "getKaType (Lorg/jetbrains/kotlin/psi/KtTypeReference;)" -> "getType";
            case "getKtType (Lorg/jetbrains/kotlin/psi/KtTypeReference;)" -> "getType";
            case "getReceiverKtType (Lorg/jetbrains/kotlin/psi/KtDoubleColonExpression;)" -> "getReceiverType";
            case "hasCommonSubTypeWith (Lorg/jetbrains/kotlin/analysis/api/types/KaType;Lorg/jetbrains/kotlin/analysis/api/types/KaType;)" -> "hasCommonSubtypeWith";
            case "isEqualTo (Lorg/jetbrains/kotlin/analysis/api/types/KaType;Lorg/jetbrains/kotlin/analysis/api/types/KaType;)" -> "semanticallyEquals";
            case "isEqualTo (Lorg/jetbrains/kotlin/analysis/api/types/KaType;Lorg/jetbrains/kotlin/analysis/api/types/KaType;Lorg/jetbrains/kotlin/analysis/api/components/KaSubtypingErrorTypePolicy;)" -> "semanticallyEquals";
            case "isSubTypeOf (Lorg/jetbrains/kotlin/analysis/api/types/KaType;Lorg/jetbrains/kotlin/analysis/api/types/KaType;Lorg/jetbrains/kotlin/analysis/api/components/KaSubtypingErrorTypePolicy;)" -> "isSubtypeOf";
            case "getAnalysisExtensionFileContextModule (Lcom/intellij/openapi/vfs/VirtualFile;)" -> "getAnalysisContextModule";
            case "getPlatform (Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;)" -> "getTargetPlatform";
            case "getModuleName (Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaSourceModule;)" -> "getName";
            case "getCompoundAccess (Lorg/jetbrains/kotlin/analysis/api/resolution/KaCompoundAccessCall;)" -> "getCompoundOperation";
            case "getPartiallyAppliedSymbol (Lorg/jetbrains/kotlin/analysis/api/resolution/KaCompoundVariableAccessCall;)" -> "getVariablePartiallyAppliedSymbol";
            case "getAllSymbols (Lorg/jetbrains/kotlin/analysis/api/scopes/KaScope;)" -> "getDeclarations";
            case "getCallableSymbols (Lorg/jetbrains/kotlin/analysis/api/scopes/KaScope;Ljava/util/Collection;)" -> "callables";
            case "getCallableSymbols (Lorg/jetbrains/kotlin/analysis/api/scopes/KaScope;Lorg/jetbrains/kotlin/name/Name;)" -> "callables";
            case "getClassifierSymbols (Lorg/jetbrains/kotlin/analysis/api/scopes/KaScope;Ljava/util/Collection;)" -> "classifiers";
            case "getClassifierSymbols (Lorg/jetbrains/kotlin/analysis/api/scopes/KaScope;Lorg/jetbrains/kotlin/name/Name;)" -> "classifiers";
            case "getCallableIdIfNonLocal (Lorg/jetbrains/kotlin/analysis/api/signatures/KaCallableSignature;)" -> "getCallableId";
            case "getCreatePackagePartProvider (Lorg/jetbrains/kotlin/analysis/api/standalone/StandaloneAnalysisAPISession;)" -> "getProject::createPackagePartProvider";
            case "getMockProject (Lorg/jetbrains/kotlin/analysis/api/standalone/StandaloneAnalysisAPISession;)" -> "getProject";
            case "getCallableIdIfNonLocal (Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;)" -> "getCallableId";
            case "getClassIdIfNonLocal (Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassLikeSymbol;)" -> "getClassId";
            case "getContainingClassIdIfNonLocal (Lorg/jetbrains/kotlin/analysis/api/symbols/KaConstructorSymbol;)" -> "getContainingClassId";
            case "getType (Lorg/jetbrains/kotlin/analysis/api/symbols/KaReceiverParameterSymbol;)" -> "getReturnType";
            case "getAnonymousFunctionSymbol (Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;)" -> "getSymbol";
            case "getAnonymousObjectSymbol (Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;)" -> "getSymbol";
            case "getClassOrObjectSymbol (Lorg/jetbrains/kotlin/psi/KtClassOrObject;)" -> "getClassSymbol";
            case "getClassOrObjectSymbolByClassId (Lorg/jetbrains/kotlin/name/ClassId;)" -> "findClass";
            case "getConstructorSymbol (Lorg/jetbrains/kotlin/psi/KtConstructor;)" -> "getSymbol";
            case "getDestructuringDeclarationEntrySymbol (Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;)" -> "getSymbol";
            case "getEnumEntrySymbol (Lorg/jetbrains/kotlin/psi/KtEnumEntry;)" -> "getSymbol";
            case "getFileSymbol (Lorg/jetbrains/kotlin/psi/KtFile;)" -> "getSymbol";
            case "getFunctionLikeSymbol (Lorg/jetbrains/kotlin/psi/KtNamedFunction;)" -> "getSymbol";
            case "getNamedClassOrObjectSymbol (Lorg/jetbrains/kotlin/psi/KtClassOrObject;)" -> "getNamedClassSymbol";
            case "getPackageSymbolIfPackageExists (Lorg/jetbrains/kotlin/name/FqName;)" -> "findPackage";
            case "getParameterSymbol (Lorg/jetbrains/kotlin/psi/KtParameter;)" -> "getSymbol";
            case "getPropertyAccessorSymbol (Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;)" -> "getSymbol";
            case "getROOT_PACKAGE_SYMBOL ()" -> "getRootPackageSymbol";
            case "getScriptSymbol (Lorg/jetbrains/kotlin/psi/KtScript;)" -> "getSymbol";
            case "getTopLevelCallableSymbols (Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/Name;)" -> "findTopLevelCallables";
            case "getTypeAliasByClassId (Lorg/jetbrains/kotlin/name/ClassId;)" -> "findTypeAlias";
            case "getTypeAliasSymbol (Lorg/jetbrains/kotlin/psi/KtTypeAlias;)" -> "getSymbol";
            case "getTypeParameterSymbol (Lorg/jetbrains/kotlin/psi/KtTypeParameter;)" -> "getSymbol";
            case "getVariableSymbol (Lorg/jetbrains/kotlin/psi/KtProperty;)" -> "getSymbol";
            case "getSymbolKind (Lorg/jetbrains/kotlin/analysis/api/symbols/markers/KaSymbolWithKind;)" -> "getLocation";
            case "getAbbreviatedTypeOrSelf (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)" -> "getAbbreviationOrSelf";
            case "getCandidateClassSymbols (Lorg/jetbrains/kotlin/analysis/api/types/KaClassErrorType;)" -> "getCandidateSymbols";
            case "getClassSymbol (Lorg/jetbrains/kotlin/analysis/api/types/KaClassType;)" -> "getSymbol";
            case "getOwnTypeArguments (Lorg/jetbrains/kotlin/analysis/api/types/KaClassType;)" -> "getTypeArguments";
            case "asStringForDebugging (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)" -> "toString";
            case "getAbbreviatedType (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)" -> "getAbbreviation";
            default -> oldApi;
        };
    }

    private final boolean isRelevantMethod(MethodNode methodNode) {
        return this.find(methodNode, (Function1<? super AbstractInsnNode, Boolean>)((Function1)LintJarApiMigration::isRelevantMethod$lambda$3)) != null;
    }

    private final AbstractInsnNode find(MethodNode $this$find, Function1<? super AbstractInsnNode, Boolean> condition) {
        ListIterator listIterator = $this$find.instructions.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)listIterator, (String)"iterator(...)");
        ListIterator listIterator2 = listIterator;
        while (listIterator2.hasNext()) {
            AbstractInsnNode instruction = (AbstractInsnNode)listIterator2.next();
            Intrinsics.checkNotNull((Object)instruction);
            if (!((Boolean)condition.invoke((Object)instruction)).booleanValue()) continue;
            return instruction;
        }
        return null;
    }

    private final byte[] migrateAnalyzeCall(byte[] classBytes) {
        ClassReader cr = new ClassReader(classBytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        boolean modified = false;
        for (MethodNode method : cn.methods) {
            Intrinsics.checkNotNull((Object)method);
            if (this.isRelevantMethod(method)) {
                String before = "";
                modified = this.migrateAnalyzeCall(method) || modified;
            }
            String string2 = cn.name;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
            if (!StringsKt.startsWith$default((String)string2, (String)"androidx/navigation/", (boolean)false, (int)2, null) || !Intrinsics.areEqual((Object)method.name, (Object)"isClassReference") && !Intrinsics.areEqual((Object)method.name, (Object)"isClassReference$default") || !this.handleLintUtilRedirection(method)) continue;
            modified = true;
        }
        if (!modified) {
            return classBytes;
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        byte[] result2 = cw.toByteArray();
        Intrinsics.checkNotNull((Object)result2);
        return result2;
    }

    private final boolean handleLintUtilRedirection(MethodNode method) {
        if (Intrinsics.areEqual((Object)method.name, (Object)"isClassReference") && (Intrinsics.areEqual((Object)method.desc, (Object)"(Lorg/jetbrains/uast/UExpression;)Lkotlin/Pair;") || Intrinsics.areEqual((Object)method.desc, (Object)"(Lorg/jetbrains/uast/UExpression;ZZZ)Lkotlin/Pair;"))) {
            InsnList instructions = method.instructions;
            instructions.clear();
            LabelNode startLabel = new LabelNode();
            instructions.add((AbstractInsnNode)startLabel);
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            if (Intrinsics.areEqual((Object)method.desc, (Object)"(Lorg/jetbrains/uast/UExpression;)Lkotlin/Pair;")) {
                instructions.add((AbstractInsnNode)new InsnNode(4));
                instructions.add((AbstractInsnNode)new InsnNode(4));
                instructions.add((AbstractInsnNode)new InsnNode(4));
            } else if (Intrinsics.areEqual((Object)method.desc, (Object)"(Lorg/jetbrains/uast/UExpression;ZZZ)Lkotlin/Pair;")) {
                instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
                instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
                instructions.add((AbstractInsnNode)new VarInsnNode(21, 3));
            } else {
                return false;
            }
            instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/android/tools/lint/detector/api/UastLintUtilsKt", method.name, "(Lorg/jetbrains/uast/UExpression;ZZZ)Lkotlin/Pair;"));
            instructions.add((AbstractInsnNode)new InsnNode(176));
            LabelNode endLabel = new LabelNode();
            instructions.add((AbstractInsnNode)endLabel);
            method.maxStack = 2;
            method.maxLocals = 4;
            method.tryCatchBlocks.clear();
            method.localVariables.clear();
            method.localVariables.add(new LocalVariableNode("$this$isClassReference", "Lorg/jetbrains/uast/UExpression;", null, startLabel, endLabel, 0));
            return true;
        }
        if (Intrinsics.areEqual((Object)method.name, (Object)"isClassReference$default") && Intrinsics.areEqual((Object)method.desc, (Object)"(Lorg/jetbrains/uast/UExpression;ZZZILjava/lang/Object;)Lkotlin/Pair;")) {
            Object v1;
            block8: {
                InsnList insnList = method.instructions;
                Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
                Iterable $this$firstOrNull$iv = (Iterable)insnList;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    AbstractInsnNode it = (AbstractInsnNode)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!this.isStaticCall(it, "isClassReference", "androidx/navigation/lint/common/LintUtilKt", "(Lorg/jetbrains/uast/UExpression;ZZZ)Lkotlin/Pair;")) continue;
                    v1 = element$iv;
                    break block8;
                }
                v1 = null;
            }
            AbstractInsnNode abstractInsnNode = v1;
            if (abstractInsnNode == null) {
                return false;
            }
            AbstractInsnNode replace = abstractInsnNode;
            ((MethodInsnNode)replace).owner = "com/android/tools/lint/detector/api/UastLintUtilsKt";
            return true;
        }
        return false;
    }

    private final boolean isCall(AbstractInsnNode $this$isCall, String name, String owner, String desc) {
        MethodInsnNode methodInsnNode = $this$isCall instanceof MethodInsnNode ? (MethodInsnNode)$this$isCall : null;
        if (methodInsnNode == null) {
            return false;
        }
        MethodInsnNode curr = methodInsnNode;
        return Intrinsics.areEqual((Object)curr.name, (Object)name) && Intrinsics.areEqual((Object)curr.owner, (Object)owner) && (desc == null || Intrinsics.areEqual((Object)curr.desc, (Object)desc));
    }

    static /* synthetic */ boolean isCall$default(LintJarApiMigration lintJarApiMigration, AbstractInsnNode abstractInsnNode, String string2, String string3, String string4, int n, Object object) {
        if ((n & 4) != 0) {
            string4 = null;
        }
        return lintJarApiMigration.isCall(abstractInsnNode, string2, string3, string4);
    }

    private final boolean isCall(AbstractInsnNode $this$isCall, String owner, String desc) {
        MethodInsnNode methodInsnNode = $this$isCall instanceof MethodInsnNode ? (MethodInsnNode)$this$isCall : null;
        if (methodInsnNode == null) {
            return false;
        }
        MethodInsnNode curr = methodInsnNode;
        return Intrinsics.areEqual((Object)curr.owner, (Object)owner) && (desc == null || Intrinsics.areEqual((Object)curr.desc, (Object)desc));
    }

    static /* synthetic */ boolean isCall$default(LintJarApiMigration lintJarApiMigration, AbstractInsnNode abstractInsnNode, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = null;
        }
        return lintJarApiMigration.isCall(abstractInsnNode, string2, string3);
    }

    private final boolean isVirtualCall(AbstractInsnNode $this$isVirtualCall, String name, String owner, String desc) {
        return $this$isVirtualCall.getOpcode() == 182 && this.isCall($this$isVirtualCall, name, owner, desc);
    }

    static /* synthetic */ boolean isVirtualCall$default(LintJarApiMigration lintJarApiMigration, AbstractInsnNode abstractInsnNode, String string2, String string3, String string4, int n, Object object) {
        if ((n & 4) != 0) {
            string4 = null;
        }
        return lintJarApiMigration.isVirtualCall(abstractInsnNode, string2, string3, string4);
    }

    private final boolean isStaticCall(AbstractInsnNode $this$isStaticCall, String name, String owner, String desc) {
        return $this$isStaticCall.getOpcode() == 184 && this.isCall($this$isStaticCall, name, owner, desc);
    }

    static /* synthetic */ boolean isStaticCall$default(LintJarApiMigration lintJarApiMigration, AbstractInsnNode abstractInsnNode, String string2, String string3, String string4, int n, Object object) {
        if ((n & 4) != 0) {
            string4 = null;
        }
        return lintJarApiMigration.isStaticCall(abstractInsnNode, string2, string3, string4);
    }

    private final boolean isStaticCall(AbstractInsnNode $this$isStaticCall, String owner, String desc) {
        return $this$isStaticCall.getOpcode() == 184 && this.isCall($this$isStaticCall, owner, desc);
    }

    static /* synthetic */ boolean isStaticCall$default(LintJarApiMigration lintJarApiMigration, AbstractInsnNode abstractInsnNode, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = null;
        }
        return lintJarApiMigration.isStaticCall(abstractInsnNode, string2, string3);
    }

    private final boolean migrateAnalyzeCall(MethodNode methodNode) {
        boolean modified = false;
        InsnList instructions = methodNode.instructions;
        Ref.ObjectRef curr = new Ref.ObjectRef();
        curr.element = instructions.getFirst();
        int ktElementVariable = -1;
        while (curr.element != null) {
            AbstractInsnNode end2;
            Object object = curr.element;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
            if (this.isVirtualCall((AbstractInsnNode)object, "beforeEnteringAnalysisContext", "org/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeTokenFactory", "(Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;)V")) {
                end2 = ((AbstractInsnNode)curr.element).getNext();
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "getToken", "org/jetbrains/kotlin/analysis/api/KtAnalysisSession", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                Integer n = LintJarApiMigration.migrateAnalyzeCall$expectAload((Ref.ObjectRef<AbstractInsnNode>)curr);
                if (n == null) break;
                int sessionVariable = n;
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "getTokenFactory", "org/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                Integer n2 = LintJarApiMigration.migrateAnalyzeCall$expectAload((Ref.ObjectRef<AbstractInsnNode>)curr);
                if (n2 == null) break;
                int sessionProviderVariable = n2;
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "beforeEnteringAnalysisContext", "org/jetbrains/kotlin/analysis/api/lifetime/impl/NoWriteActionInAnalyseCallChecker", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "getNoWriteActionInAnalyseCallChecker", "org/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                Integer n3 = LintJarApiMigration.migrateAnalyzeCall$expectAload((Ref.ObjectRef<AbstractInsnNode>)curr);
                if (n3 == null) break;
                int sessionProviderVariable2 = n3;
                Object object2 = curr.element;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"element");
                AbstractInsnNode startReplace = (AbstractInsnNode)object2;
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "getAnalysisSession", "org/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || ((AbstractInsnNode)curr.element).getOpcode() == 192 && LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                Integer n4 = LintJarApiMigration.migrateAnalyzeCall$expectAload((Ref.ObjectRef<AbstractInsnNode>)curr);
                if (n4 == null) break;
                ktElementVariable = n4;
                AbstractInsnNode last = startReplace.getPrevious();
                AbstractInsnNode c = last.getNext();
                while (c != end2) {
                    AbstractInsnNode next = c.getNext();
                    if (!(c instanceof LabelNode) && !(c instanceof LineNumberNode)) {
                        instructions.remove(c);
                    }
                    c = next;
                }
                VarInsnNode i1 = new VarInsnNode(25, sessionProviderVariable);
                VarInsnNode i2 = new VarInsnNode(25, sessionVariable);
                VarInsnNode i3 = new VarInsnNode(25, ktElementVariable);
                MethodInsnNode i4 = new MethodInsnNode(182, "org/jetbrains/kotlin/analysis/api/session/KaSessionProvider", "beforeEnteringAnalysis", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtElement;)V", false);
                instructions.insert(last, (AbstractInsnNode)i1);
                instructions.insert((AbstractInsnNode)i1, (AbstractInsnNode)i2);
                instructions.insert((AbstractInsnNode)i2, (AbstractInsnNode)i3);
                instructions.insert((AbstractInsnNode)i3, (AbstractInsnNode)i4);
                curr.element = end2;
                modified = true;
                continue;
            }
            Object object3 = curr.element;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"element");
            if (LintJarApiMigration.isVirtualCall$default(this, (AbstractInsnNode)object3, "afterLeavingAnalysisContext", "org/jetbrains/kotlin/analysis/api/lifetime/impl/NoWriteActionInAnalyseCallChecker", null, 4, null)) {
                AbstractInsnNode last;
                end2 = ((AbstractInsnNode)curr.element).getNext();
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "getNoWriteActionInAnalyseCallChecker", "org/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                Integer n = LintJarApiMigration.migrateAnalyzeCall$expectAload((Ref.ObjectRef<AbstractInsnNode>)curr);
                if (n == null) break;
                int sessionProviderVariable = n;
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "afterLeavingAnalysisContext", "org/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeTokenFactory", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "getToken", "org/jetbrains/kotlin/analysis/api/KtAnalysisSession", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                Integer n5 = LintJarApiMigration.migrateAnalyzeCall$expectAload((Ref.ObjectRef<AbstractInsnNode>)curr);
                if (n5 == null) break;
                int sessionVariable = n5;
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "getTokenFactory", "org/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                Integer n6 = LintJarApiMigration.migrateAnalyzeCall$expectAload((Ref.ObjectRef<AbstractInsnNode>)curr);
                if (n6 == null) break;
                n6.intValue();
                if (((AbstractInsnNode)curr.element).getPrevious() == null) break;
                AbstractInsnNode c = last.getNext();
                while (c != end2) {
                    AbstractInsnNode next = c.getNext();
                    if (!(c instanceof LabelNode) && !(c instanceof LineNumberNode)) {
                        instructions.remove(c);
                    }
                    c = next;
                }
                VarInsnNode i1 = new VarInsnNode(25, sessionProviderVariable);
                VarInsnNode i2 = new VarInsnNode(25, sessionVariable);
                VarInsnNode i3 = new VarInsnNode(25, ktElementVariable);
                MethodInsnNode i4 = new MethodInsnNode(182, "org/jetbrains/kotlin/analysis/api/session/KaSessionProvider", "afterLeavingAnalysis", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtElement;)V", false);
                instructions.insert(last, (AbstractInsnNode)i1);
                instructions.insert((AbstractInsnNode)i1, (AbstractInsnNode)i2);
                instructions.insert((AbstractInsnNode)i2, (AbstractInsnNode)i3);
                instructions.insert((AbstractInsnNode)i3, (AbstractInsnNode)i4);
                curr.element = end2;
                modified = true;
                continue;
            }
            Object object4 = curr.element;
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"element");
            if (LintJarApiMigration.isStaticCall$default(this, (AbstractInsnNode)object4, "getAllSuperTypes$default", "org/jetbrains/kotlin/analysis/api/components/KtTypeProviderMixIn", null, 4, null)) {
                AbstractInsnNode shouldApproximateLoad;
                AbstractInsnNode aconstNull;
                AbstractInsnNode iconst1;
                AbstractInsnNode checkCast;
                end2 = ((AbstractInsnNode)curr.element).getNext();
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                LintJarApiMigration.migrateAnalyzeCall$expectAload((Ref.ObjectRef<AbstractInsnNode>)curr);
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                AbstractInsnNode sessionLoad = checkCast.getPrevious();
                AbstractInsnNode beforeInvokeStatic = ((AbstractInsnNode)curr.element).getPrevious();
                instructions.remove(checkCast);
                instructions.remove(iconst1);
                instructions.remove(aconstNull);
                MethodInsnNode newCall = new MethodInsnNode(185, "org/jetbrains/kotlin/analysis/api/KaSession", "allSupertypes", "(Lorg/jetbrains/kotlin/analysis/api/types/KaType;Z)Lkotlin/sequences/Sequence;", true);
                instructions.insert(shouldApproximateLoad, (AbstractInsnNode)newCall);
                MethodInsnNode toList = new MethodInsnNode(184, "kotlin/sequences/SequencesKt", "toList", "(Lkotlin/sequences/Sequence;)Ljava/util/List;", false);
                instructions.insert((AbstractInsnNode)newCall, (AbstractInsnNode)toList);
                AbstractInsnNode next = toList.getNext();
                instructions.remove(next);
                curr.element = end2;
                modified = true;
                continue;
            }
            Object object5 = curr.element;
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"element");
            if (LintJarApiMigration.isStaticCall$default(this, (AbstractInsnNode)object5, "org/jetbrains/kotlin/analysis/api/calls/KtCallKt", null, 2, null)) {
                String newOwner;
                MethodInsnNode curr2;
                Object object6 = curr.element;
                if ((object6 instanceof MethodInsnNode ? (MethodInsnNode)object6 : null) == null) break;
                curr2 = curr2;
                curr2.owner = newOwner = Intrinsics.areEqual((Object)curr2.name, (Object)"getSymbol") ? "org/jetbrains/kotlin/analysis/api/resolution/KaCallKt" : "org/jetbrains/kotlin/analysis/api/resolution/KaCallInfoKt";
                modified = true;
                continue;
            }
            if (((AbstractInsnNode)curr.element).getNext() == null) {
                Object cfr_ignored_0 = curr.element;
                break;
            }
            curr.element = curr.element;
        }
        return modified;
    }

    private final Class<?> findClass(String owner) {
        try {
            String className = Type.getObjectType((String)owner).getClassName();
            return Class.forName(className, false, LintJarApiMigration.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private final AbstractInsnNode prev(AbstractInsnNode $this$prev) {
        AbstractInsnNode curr = $this$prev.getPrevious();
        while (curr instanceof LabelNode || curr instanceof LineNumberNode) {
            curr = curr.getPrevious();
        }
        return curr;
    }

    @NotNull
    public final String prettyPrint(@NotNull MethodNode $this$prettyPrint) {
        Intrinsics.checkNotNullParameter((Object)$this$prettyPrint, (String)"<this>");
        return $this$prettyPrint.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isRelevantMethod$lambda$3(AbstractInsnNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!(it instanceof MethodInsnNode)) return false;
        String string2 = ((MethodInsnNode)it).owner;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"owner");
        if (!StringsKt.startsWith$default((String)string2, (String)"org/jetbrains/kotlin/analysis/api/", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final AbstractInsnNode migrateAnalyzeCall$prev(Ref.ObjectRef<AbstractInsnNode> curr, LintJarApiMigration this$0) {
        Object object = curr.element;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
        curr.element = this$0.prev((AbstractInsnNode)object);
        return (AbstractInsnNode)curr.element;
    }

    private static final Integer migrateAnalyzeCall$expectAload(Ref.ObjectRef<AbstractInsnNode> curr) {
        Integer n;
        if (((AbstractInsnNode)curr.element).getOpcode() == 25) {
            Object object = curr.element;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.objectweb.asm.tree.VarInsnNode");
            n = ((VarInsnNode)object).var;
        } else {
            n = null;
        }
        return n;
    }

    private static final AbstractInsnNode migrateAnalyzeCall$expectVirtualCall(LintJarApiMigration this$0, Ref.ObjectRef<AbstractInsnNode> curr, String name, String owner, String desc) {
        Object object = curr.element;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
        return this$0.isVirtualCall((AbstractInsnNode)object, name, owner, desc) ? (AbstractInsnNode)curr.element : null;
    }

    static /* synthetic */ AbstractInsnNode migrateAnalyzeCall$expectVirtualCall$default(LintJarApiMigration lintJarApiMigration, Ref.ObjectRef objectRef, String string2, String string3, String string4, int n, Object object) {
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        return LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall(lintJarApiMigration, (Ref.ObjectRef<AbstractInsnNode>)objectRef, string2, string3, string4);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/client/api/LintJarApiMigration$Companion;", "", "<init>", "()V", "DEBUG", "", "isRelevantType", "s", "", "getMigratedJar", "Ljava/io/File;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "jar", "registryClass", "android.sdktools.lint-api"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isRelevantType(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return StringsKt.startsWith$default((String)s, (String)"org/jetbrains/kotlin/analysis/api/", (boolean)false, (int)2, null);
        }

        @NotNull
        public final File getMigratedJar(@NotNull LintClient client, @NotNull File jar, @NotNull String registryClass) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
            Intrinsics.checkNotNullParameter((Object)registryClass, (String)"registryClass");
            return new LintJarApiMigration(client).getMigratedJar(jar, registryClass);
        }

        public static /* synthetic */ File getMigratedJar$default(Companion companion, LintClient lintClient, File file, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = "";
            }
            return companion.getMigratedJar(lintClient, file, string2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004JE\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\u0010\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/client/api/LintJarApiMigration$SwitchToInterfaceClassVisitor;", "Lorg/objectweb/asm/ClassVisitor;", "chained", "<init>", "(Lcom/android/tools/lint/client/api/LintJarApiMigration;Lorg/objectweb/asm/ClassVisitor;)V", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "access", "", "name", "", "descriptor", "signature", "exceptions", "", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "android.sdktools.lint-api"})
    private final class SwitchToInterfaceClassVisitor
    extends ClassVisitor {
        public SwitchToInterfaceClassVisitor(ClassVisitor chained) {
            Intrinsics.checkNotNullParameter((Object)chained, (String)"chained");
            super(589824, chained);
        }

        @NotNull
        public MethodVisitor visitMethod(int access, @Nullable String name, @Nullable String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
            MethodVisitor methodVisitor2 = super.visitMethod(access, name, descriptor, signature, exceptions);
            Intrinsics.checkNotNullExpressionValue((Object)methodVisitor2, (String)"visitMethod(...)");
            return new SwitchToInterfaceMethodVisitor(methodVisitor2);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/client/api/LintJarApiMigration$SwitchToInterfaceMethodVisitor;", "Lorg/objectweb/asm/MethodVisitor;", "chained", "<init>", "(Lcom/android/tools/lint/client/api/LintJarApiMigration;Lorg/objectweb/asm/MethodVisitor;)V", "visitMethodInsn", "", "opcode", "", "owner", "", "name", "descriptor", "isInterface", "", "android.sdktools.lint-api"})
    private final class SwitchToInterfaceMethodVisitor
    extends MethodVisitor {
        public SwitchToInterfaceMethodVisitor(MethodVisitor chained) {
            Intrinsics.checkNotNullParameter((Object)chained, (String)"chained");
            super(589824, chained);
        }

        public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String descriptor, boolean isInterface) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            if ((opcode == 184 || opcode == 182 || opcode == 185) && Companion.isRelevantType(owner)) {
                Class clz = LintJarApiMigration.this.findClass(owner);
                if (clz == null) {
                    LintJarApiMigration.this.client.log(Severity.WARNING, null, "WARNING: Missing analysis API method " + owner + "#" + name + descriptor, new Object[0]);
                } else {
                    int newOpCode = clz.isInterface() ? 185 : opcode;
                    String newApi = LintJarApiMigration.this.mapApi(owner, name, descriptor);
                    if (((CharSequence)newApi).length() > 0) {
                        super.visitMethodInsn(newOpCode, owner, newApi, descriptor, clz.isInterface());
                    }
                    return;
                }
            }
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }
    }
}

