/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.Lint;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassKind;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KotlinLightMethodUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UExpressionList;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULabeledExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USwitchClauseExpressionWithBody;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UYieldExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastErrorType;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.internal.ImplementationUtilsKt;
import org.jetbrains.uast.kotlin.BaseKotlinUastResolveProviderService;
import org.jetbrains.uast.kotlin.kinds.KotlinSpecialExpressionKinds;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u00a2\u0001\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0006\u001a\u00020\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u000e\u001a\n\u0010\u0018\u001a\u00020\u0010*\u00020\u0010\u001a\f\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u0010\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\u0010\u001a\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u0014*\u00020\u001dH\u0002\u001a\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u0014*\u00020\u001dH\u0002\u001a\f\u0010\u001f\u001a\u0004\u0018\u00010\u001a*\u00020\u0010\u001a\f\u0010 \u001a\u0004\u0018\u00010\u001a*\u00020\u0010\u001a\u001c\u0010!\u001a\u00020\u0001*\u00020\u00102\u0006\u0010\"\u001a\u00020\u00102\b\b\u0002\u0010#\u001a\u00020\u0001\u001a\u001e\u0010!\u001a\u00020\u0001*\u0004\u0018\u00010$2\u0006\u0010\"\u001a\u00020$2\b\b\u0002\u0010#\u001a\u00020\u0001\u001a\f\u0010%\u001a\u0004\u0018\u00010&*\u00020'\u001a\f\u0010(\u001a\u0004\u0018\u00010&*\u00020'\u001a\n\u0010)\u001a\u00020\u0001*\u00020\u000b\u001a\u0012\u0010*\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010+\u001a\u00020,\u001a\u000f\u0010-\u001a\u0004\u0018\u00010.*\u00020,H\u0082\u0010\u001a\n\u0010/\u001a\u00020\u0001*\u00020\u0014\u001a\n\u00100\u001a\u00020\u0001*\u000201\u001a\n\u00102\u001a\u00020\u0001*\u00020\u0003\u001a\n\u00103\u001a\u00020\u0001*\u00020\u0003\u001a\n\u00104\u001a\u00020\u0001*\u00020\u0003\u001a\u0012\u0010:\u001a\u00020;*\u00020<2\u0006\u0010=\u001a\u00020>\u001a\n\u0010?\u001a\u00020\u0001*\u00020@\u001a\n\u0010A\u001a\u00020\u001a*\u00020\u001a\u001a\u0014\u0010B\u001a\u00020;*\u00020<2\u0006\u0010=\u001a\u00020>H\u0002\u001a\n\u0010C\u001a\u00020\u0001*\u00020\u001a\u001a\f\u0010D\u001a\u00020\u0001*\u00020EH\u0002\u001a\u000e\u0010F\u001a\u00020\u00012\u0006\u0010G\u001a\u00020\u0003\u001a\u0018\u0010H\u001a\u0004\u0018\u00010\u00102\u0006\u0010I\u001a\u00020\u00102\u0006\u0010J\u001a\u00020\u0010\u001a\u0010\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\u0010H\u0002\u001a\n\u0010N\u001a\u00020\u0001*\u00020\u0003\u001a6\u0010O\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\b0P*\u00020\u001a2\b\b\u0002\u0010Q\u001a\u00020\u00012\b\b\u0002\u0010R\u001a\u00020\u00012\b\b\u0002\u0010S\u001a\u00020\u0001\"\u0017\u0010\u000f\u001a\u0004\u0018\u00010\b*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\"\u0017\u00105\u001a\u0004\u0018\u00010\u001a*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b6\u00107\"\u0017\u00108\u001a\u0004\u0018\u00010\u001a*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b9\u00107\u00a8\u0006T"}, d2={"isScopingThis", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "isScopingIt", "isReturningContext", "isScopingFunctionName", "name", "", "isScopingFunction", "method", "Lcom/intellij/psi/PsiMethod;", "isReturningLambdaResult", "isReceiver", "Lcom/intellij/psi/PsiParameter;", "nameFromSource", "Lorg/jetbrains/uast/UElement;", "getNameFromSource", "(Lorg/jetbrains/uast/UElement;)Ljava/lang/String;", "typeFromPsi", "Lcom/intellij/psi/PsiType;", "Lorg/jetbrains/uast/UVariable;", "getTypeFromPsi", "(Lorg/jetbrains/uast/UVariable;)Lcom/intellij/psi/PsiType;", "findSelector", "nextStatement", "Lorg/jetbrains/uast/UExpression;", "isIncorrectImplicitReturnInLambda", "getReturnType", "Lorg/jetbrains/uast/ULambdaExpression;", "getLambdaType", "statement", "previousStatement", "isBelow", "parent", "strict", "Lcom/intellij/psi/PsiElement;", "getReceiverOrContainingClass", "Lcom/intellij/psi/PsiClass;", "Lcom/intellij/psi/PsiMember;", "getReceiver", "isAccessor", "isSyntheticAccessor", "sourcePsi", "Lorg/jetbrains/kotlin/psi/KtElement;", "findSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "isErroneous", "isElvisIf", "Lorg/jetbrains/uast/UIfExpression;", "isThisOrSuperConstructorCall", "isSuperConstructorCall", "isThisConstructorCall", "explicitReceiver", "getExplicitReceiver", "(Lorg/jetbrains/uast/UCallExpression;)Lorg/jetbrains/uast/UExpression;", "implicitReceiver", "getImplicitReceiver", "acceptSourceFile", "", "Lorg/jetbrains/uast/UFile;", "visitor", "Lorg/jetbrains/uast/visitor/UastVisitor;", "isDuplicatedOverload", "Lorg/jetbrains/uast/UMethod;", "skipLabeledExpression", "acceptMultiFileClass", "isUnconditionalReturn", "isExhaustive", "Lorg/jetbrains/uast/USwitchExpression;", "callNeverReturns", "call", "findCommonParent", "element1", "element2", "getDepth", "", "element", "isSyntheticJavaGetterSetterCallForPropertyAccess", "isClassReference", "Lkotlin/Pair;", "checkClass", "checkInterface", "checkCompanion", "android.sdktools.lint-api"})
@SourceDebugExtension(value={"SMAP\nUastLintUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UastLintUtils.kt\ncom/android/tools/lint/detector/api/UastLintUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 4 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 5 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1318:1\n1#2:1319\n30#3,2:1320\n30#3,2:1346\n30#3,2:1369\n30#3,2:1386\n35#4,15:1322\n35#4,15:1348\n35#4,15:1371\n35#4,15:1388\n18#5:1337\n1761#6,3:1338\n1761#6,3:1341\n295#6,2:1344\n1761#6,2:1363\n1761#6,3:1365\n1763#6:1368\n1761#6,3:1403\n1761#6,3:1406\n1740#6,3:1409\n1761#6,3:1412\n*S KotlinDebug\n*F\n+ 1 UastLintUtils.kt\ncom/android/tools/lint/detector/api/UastLintUtilsKt\n*L\n819#1:1320,2\n1167#1:1346,2\n1188#1:1369,2\n1296#1:1386,2\n819#1:1322,15\n1167#1:1348,15\n1188#1:1371,15\n1296#1:1388,15\n845#1:1337\n1022#1:1338,3\n1053#1:1341,3\n1060#1:1344,2\n1170#1:1363,2\n1172#1:1365,3\n1170#1:1368\n1129#1:1403,3\n1130#1:1406,3\n1140#1:1409,3\n1149#1:1412,3\n*E\n"})
public final class UastLintUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isScopingThis(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String name = Lint.getMethodName(node);
        if (name == null) return false;
        switch (name.hashCode()) {
            case 3649734: {
                if (name.equals("with")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case 93029230: {
                if (name.equals("apply")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case 113291: {
                if (!name.equals("run")) return false;
                return UastLintUtilsKt.isScopingFunction(node);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isScopingIt(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String name = Lint.getMethodName(node);
        if (name == null) return false;
        switch (name.hashCode()) {
            case 107035: {
                if (name.equals("let")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case 2997191: {
                if (name.equals("also")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case -1066067175: {
                if (name.equals("takeUnless")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case -881117180: {
                if (!name.equals("takeIf")) return false;
                return UastLintUtilsKt.isScopingFunction(node);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isReturningContext(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String name = Lint.getMethodName(node);
        if (name == null) return false;
        switch (name.hashCode()) {
            case 93029230: {
                if (name.equals("apply")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case 2997191: {
                if (name.equals("also")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case -1066067175: {
                if (name.equals("takeUnless")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case -881117180: {
                if (!name.equals("takeIf")) return false;
                return UastLintUtilsKt.isScopingFunction(node);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isScopingFunctionName(String name) {
        String string2 = name;
        if (string2 == null) return false;
        switch (string2.hashCode()) {
            case 3649734: {
                if (string2.equals("with")) return true;
                return false;
            }
            case 93029230: {
                if (string2.equals("apply")) return true;
                return false;
            }
            case 107035: {
                if (string2.equals("let")) return true;
                return false;
            }
            case 113291: {
                if (string2.equals("run")) return true;
                return false;
            }
            case 2997191: {
                if (string2.equals("also")) return true;
                return false;
            }
            case -1066067175: {
                if (string2.equals("takeUnless")) return true;
                return false;
            }
            case -881117180: {
                if (!string2.equals("takeIf")) return false;
                return true;
            }
        }
        return false;
    }

    public static final boolean isScopingFunction(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Object object = node.getMethodIdentifier();
        if (object == null || (object = object.getName()) == null) {
            object = node.getMethodName();
        }
        if (UastLintUtilsKt.isScopingFunctionName((String)object)) {
            PsiMethod psiMethod = node.resolve();
            if (psiMethod == null) {
                return true;
            }
            PsiMethod called = psiMethod;
            return UastLintUtilsKt.isScopingFunction(called);
        }
        return false;
    }

    public static final boolean isScopingFunction(@NotNull PsiMethod method) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (UastLintUtilsKt.isScopingFunctionName(method.getName())) {
            Object object = method.getContainingClass();
            if (object == null || (object = object.getQualifiedName()) == null) {
                return false;
            }
            Object fqName = object;
            bl = Intrinsics.areEqual((Object)fqName, (Object)"kotlin.StandardKt__StandardKt") || Intrinsics.areEqual((Object)fqName, (Object)"kotlin.StandardKt");
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isReturningLambdaResult(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String name = Lint.getMethodName(node);
        if (name == null) return false;
        switch (name.hashCode()) {
            case 3649734: {
                if (name.equals("with")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case 107035: {
                if (name.equals("let")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case 113291: {
                if (!name.equals("run")) return false;
                return UastLintUtilsKt.isScopingFunction(node);
            }
        }
        return false;
    }

    public static final boolean isReceiver(@NotNull PsiParameter $this$isReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$isReceiver, (String)"<this>");
        String string2 = $this$isReceiver.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String name = string2;
        return StringsKt.startsWith$default((String)name, (String)"$this", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"$self", (boolean)false, (int)2, null);
    }

    @Nullable
    public static final String getNameFromSource(@NotNull UElement $this$nameFromSource) {
        Intrinsics.checkNotNullParameter((Object)$this$nameFromSource, (String)"<this>");
        PsiElement psiElement = $this$nameFromSource.getSourcePsi();
        PsiNamedElement psiNamedElement = psiElement instanceof PsiNamedElement ? (PsiNamedElement)psiElement : null;
        return psiNamedElement != null ? psiNamedElement.getName() : null;
    }

    @Nullable
    public static final PsiType getTypeFromPsi(@NotNull UVariable $this$typeFromPsi) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$typeFromPsi, (String)"<this>");
        if ($this$typeFromPsi instanceof UField) {
            object = ((UField)$this$typeFromPsi).getType();
        } else {
            PsiElement psiElement = $this$typeFromPsi.getJavaPsi();
            PsiVariable psiVariable = psiElement instanceof PsiVariable ? (PsiVariable)psiElement : null;
            object = psiVariable != null ? psiVariable.getType() : null;
        }
        return object;
    }

    @NotNull
    public static final UElement findSelector(@NotNull UElement $this$findSelector) {
        Intrinsics.checkNotNullParameter((Object)$this$findSelector, (String)"<this>");
        UElement curr = $this$findSelector;
        while (true) {
            UExpression uExpression;
            UElement uElement;
            if ((uElement = curr) instanceof UQualifiedReferenceExpression) {
                uExpression = ((UQualifiedReferenceExpression)curr).getSelector();
            } else {
                if (!(uElement instanceof UParenthesizedExpression)) break;
                uExpression = ((UParenthesizedExpression)curr).getExpression();
            }
            curr = (UElement)uExpression;
        }
        return curr;
    }

    @Nullable
    public static final UExpression nextStatement(@NotNull UElement $this$nextStatement) {
        Intrinsics.checkNotNullParameter((Object)$this$nextStatement, (String)"<this>");
        UElement prev = $this$nextStatement;
        for (UElement curr = prev.getUastParent(); curr != null; curr = curr.getUastParent()) {
            if (curr instanceof UBlockExpression) {
                List expressions = ((UBlockExpression)curr).getExpressions();
                int index2 = CollectionsKt.indexOf((List)expressions, (Object)prev);
                return index2 != -1 && index2 < expressions.size() - 1 ? (UExpression)expressions.get(index2 + 1) : null;
            }
            prev = curr;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIncorrectImplicitReturnInLambda(@NotNull UElement $this$isIncorrectImplicitReturnInLambda) {
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$isIncorrectImplicitReturnInLambda, (String)"<this>");
        if (!($this$isIncorrectImplicitReturnInLambda instanceof UReturnExpression)) return false;
        if ($this$isIncorrectImplicitReturnInLambda.getSourcePsi() != null) {
            return false;
        }
        if (!($this$isIncorrectImplicitReturnInLambda.getUastParent() instanceof UBlockExpression)) {
            return false;
        }
        UElement uElement = $this$isIncorrectImplicitReturnInLambda.getUastParent();
        Intrinsics.checkNotNull((Object)uElement, (String)"null cannot be cast to non-null type org.jetbrains.uast.UBlockExpression");
        UBlockExpression block = (UBlockExpression)uElement;
        if (!Intrinsics.areEqual((Object)CollectionsKt.lastOrNull((List)block.getExpressions()), (Object)$this$isIncorrectImplicitReturnInLambda)) {
            return false;
        }
        if (!(block.getUastParent() instanceof ULambdaExpression)) {
            return false;
        }
        UElement uElement2 = block.getUastParent();
        Intrinsics.checkNotNull((Object)uElement2, (String)"null cannot be cast to non-null type org.jetbrains.uast.ULambdaExpression");
        ULambdaExpression lambda = (ULambdaExpression)uElement2;
        PsiType psiType = UastLintUtilsKt.getReturnType(lambda);
        if (psiType == null) return false;
        PsiType returnType = psiType;
        boolean bl = false;
        PsiType psiType2 = returnType instanceof PsiWildcardType ? ((PsiWildcardType)returnType).getBound() : returnType;
        if (psiType2 == null) return false;
        String string2 = psiType2.getCanonicalText();
        if (string2 == null) return false;
        String lambdaReturnType = string2;
        switch (lambdaReturnType.hashCode()) {
            case 399092968: {
                if (lambdaReturnType.equals("java.lang.Void")) return true;
                break;
            }
            case -1706826127: {
                if (lambdaReturnType.equals("kotlin.Unit")) return true;
                break;
            }
            case 3625364: {
                if (lambdaReturnType.equals("void")) return true;
                break;
            }
            case -1818355776: {
                if (!lambdaReturnType.equals("kotlin.Nothing")) break;
                return true;
            }
        }
        if (!Intrinsics.areEqual((Object)lambdaReturnType, (Object)"java.lang.Object")) {
            return false;
        }
        string2 = lambda.getSourcePsi();
        if (!(string2 instanceof KtLambdaExpression)) return false;
        KtLambdaExpression ktLambdaExpression = (KtLambdaExpression)string2;
        if (ktLambdaExpression == null) {
            return false;
        }
        KtLambdaExpression ktLambda = ktLambdaExpression;
        KtElement useSiteElement$iv = (KtElement)ktLambda;
        boolean $i$f$analyze = false;
        Project project = useSiteElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        returnType = KaSessionProvider.Companion.getInstance(project);
        KtElement useSiteElement$iv$iv = useSiteElement$iv;
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        try {
            boolean bl2;
            Object lock$iv$iv;
            Object object = lock$iv$iv = new Object();
            synchronized (object) {
                boolean bl3 = false;
                KaSession $this$isIncorrectImplicitReturnInLambda_u24lambda_u241 = analysisSession$iv$iv;
                boolean bl4 = false;
                KaType kaType = $this$isIncorrectImplicitReturnInLambda_u24lambda_u241.getExpectedType((PsiElement)ktLambda);
                bl2 = kaType != null ? $this$isIncorrectImplicitReturnInLambda_u24lambda_u241.isSuspendFunctionType(kaType) : false;
            }
            boolean bl5 = bl2;
            return bl5;
        }
        catch (Throwable throwable$iv$iv) {
            this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
            throw new KotlinNothingValueException();
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        }
    }

    private static final PsiType getReturnType(ULambdaExpression $this$getReturnType) {
        PsiType lambdaType = UastLintUtilsKt.getLambdaType($this$getReturnType);
        return LambdaUtil.getFunctionalInterfaceReturnType((PsiType)lambdaType);
    }

    private static final PsiType getLambdaType(ULambdaExpression $this$getLambdaType) {
        Object object = $this$getLambdaType.getFunctionalInterfaceType();
        if (object == null && (object = $this$getLambdaType.getExpressionType()) == null) {
            UElement uElement = $this$getLambdaType.getUastParent();
            if (uElement != null) {
                UElement it = uElement;
                boolean bl = false;
                UElement uElement2 = it;
                if (uElement2 instanceof UVariable) {
                    object = ((UVariable)it).getType();
                } else if (uElement2 instanceof UCallExpression) {
                    PsiParameter psiParameter = UastUtils.getParameterForArgument((UCallExpression)((UCallExpression)it), (UExpression)((UExpression)$this$getLambdaType));
                    object = psiParameter != null ? psiParameter.getType() : null;
                } else {
                    object = null;
                }
            } else {
                object = null;
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final UExpression statement(@NotNull UElement $this$statement) {
        void $this$getParentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)$this$statement, (String)"<this>");
        UElement uElement = $this$statement;
        boolean strict$iv = false;
        boolean $i$f$getParentOfType = false;
        UExpression uExpression = (UExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UExpression.class, (boolean)strict$iv);
        if (uExpression == null) {
            return null;
        }
        UExpression prev = uExpression;
        UElement curr = prev.getUastParent();
        while (curr != null) {
            if (curr instanceof UBlockExpression || !(curr instanceof UExpression)) {
                return prev instanceof UParenthesizedExpression ? ((UParenthesizedExpression)prev).getExpression() : prev;
            }
            prev = (UExpression)curr;
            curr = ((UExpression)curr).getUastParent();
        }
        return prev;
    }

    @Nullable
    public static final UExpression previousStatement(@NotNull UElement $this$previousStatement) {
        Intrinsics.checkNotNullParameter((Object)$this$previousStatement, (String)"<this>");
        UElement prev = $this$previousStatement;
        for (UElement curr = prev.getUastParent(); curr != null; curr = curr.getUastParent()) {
            if (curr instanceof UBlockExpression) {
                List expressions = ((UBlockExpression)curr).getExpressions();
                int index2 = CollectionsKt.indexOf((List)expressions, (Object)prev);
                return index2 > 0 ? (UExpression)expressions.get(index2 - 1) : null;
            }
            prev = curr;
        }
        return null;
    }

    public static final boolean isBelow(@NotNull UElement $this$isBelow, @NotNull UElement parent, boolean strict) {
        UElement curr;
        Intrinsics.checkNotNullParameter((Object)$this$isBelow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        UElement uElement = curr = strict ? $this$isBelow.getUastParent() : $this$isBelow;
        while (curr != null) {
            if (Intrinsics.areEqual((Object)curr, (Object)parent)) {
                return true;
            }
            curr = curr.getUastParent();
        }
        return false;
    }

    public static /* synthetic */ boolean isBelow$default(UElement uElement, UElement uElement2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UastLintUtilsKt.isBelow(uElement, uElement2, bl);
    }

    public static final boolean isBelow(@Nullable PsiElement $this$isBelow, @NotNull PsiElement parent, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if ($this$isBelow == null) {
            return false;
        }
        return PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)$this$isBelow, (boolean)strict);
    }

    public static /* synthetic */ boolean isBelow$default(PsiElement psiElement, PsiElement psiElement2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UastLintUtilsKt.isBelow(psiElement, psiElement2, bl);
    }

    @Nullable
    public static final PsiClass getReceiverOrContainingClass(@NotNull PsiMember $this$getReceiverOrContainingClass) {
        Intrinsics.checkNotNullParameter((Object)$this$getReceiverOrContainingClass, (String)"<this>");
        PsiClass psiClass = UastLintUtilsKt.getReceiver($this$getReceiverOrContainingClass);
        if (psiClass == null) {
            psiClass = $this$getReceiverOrContainingClass.getContainingClass();
        }
        return psiClass;
    }

    @Nullable
    public static final PsiClass getReceiver(@NotNull PsiMember $this$getReceiver) {
        UTypeReferenceExpression typeReference;
        KtCallableDeclaration ktCallableDeclaration;
        Intrinsics.checkNotNullParameter((Object)$this$getReceiver, (String)"<this>");
        PsiElement unwrapped = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)$this$getReceiver));
        if (unwrapped instanceof KtNamedFunction || unwrapped instanceof KtProperty) {
            ktCallableDeclaration = (KtCallableDeclaration)unwrapped;
        } else if (unwrapped instanceof KtPropertyAccessor) {
            ktCallableDeclaration = (KtCallableDeclaration)PsiTreeUtil.getNonStrictParentOfType((PsiElement)unwrapped, (Class[])new Class[0]);
        } else {
            return null;
        }
        if (ktCallableDeclaration == null) {
            return null;
        }
        KtCallableDeclaration callable = ktCallableDeclaration;
        KtTypeReference ktTypeReference = callable.getReceiverTypeReference();
        UElement uElement = ktTypeReference != null ? UastContextKt.toUElement((PsiElement)((PsiElement)ktTypeReference)) : null;
        UTypeReferenceExpression uTypeReferenceExpression = typeReference = uElement instanceof UTypeReferenceExpression ? (UTypeReferenceExpression)uElement : null;
        PsiType psiType = uTypeReferenceExpression != null ? uTypeReferenceExpression.getType() : null;
        PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        return psiClassType != null ? psiClassType.resolve() : null;
    }

    public static final boolean isAccessor(@NotNull PsiMethod $this$isAccessor) {
        Intrinsics.checkNotNullParameter((Object)$this$isAccessor, (String)"<this>");
        KtLightMethod ktLightMethod = $this$isAccessor instanceof KtLightMethod ? (KtLightMethod)$this$isAccessor : null;
        if (ktLightMethod == null) {
            return false;
        }
        KtLightMethod lightMethod = ktLightMethod;
        return KotlinLightMethodUtilsKt.isAccessor((KtLightMethod)lightMethod, (boolean)true) || KotlinLightMethodUtilsKt.isAccessor((KtLightMethod)lightMethod, (boolean)false);
    }

    public static final boolean isSyntheticAccessor(@NotNull PsiMethod $this$isSyntheticAccessor, @NotNull KtElement sourcePsi) {
        Intrinsics.checkNotNullParameter((Object)$this$isSyntheticAccessor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sourcePsi, (String)"sourcePsi");
        BaseKotlinUastResolveProviderService baseKotlinUastResolveProviderService = (BaseKotlinUastResolveProviderService)ApplicationManager.getApplication().getService(BaseKotlinUastResolveProviderService.class);
        if (baseKotlinUastResolveProviderService == null) {
            return false;
        }
        BaseKotlinUastResolveProviderService uastResolveService = baseKotlinUastResolveProviderService;
        KtSimpleNameExpression ktSimpleNameExpression = UastLintUtilsKt.findSimpleNameExpression(sourcePsi);
        if (ktSimpleNameExpression == null) {
            return false;
        }
        KtSimpleNameExpression simpleNameExpression = ktSimpleNameExpression;
        return Intrinsics.areEqual((Object)uastResolveService.resolveSyntheticJavaPropertyAccessorCall(simpleNameExpression), (Object)$this$isSyntheticAccessor);
    }

    private static final KtSimpleNameExpression findSimpleNameExpression(KtElement $this$findSimpleNameExpression) {
        KtSimpleNameExpression ktSimpleNameExpression;
        block3: {
            KtElement ktElement;
            block4: {
                while (true) {
                    if ((ktElement = $this$findSimpleNameExpression) instanceof KtQualifiedExpression) {
                        KtExpression ktExpression = ((KtQualifiedExpression)$this$findSimpleNameExpression).getSelectorExpression();
                        if (ktExpression != null) {
                            $this$findSimpleNameExpression = (KtElement)ktExpression;
                            continue;
                        }
                        ktSimpleNameExpression = null;
                        break block3;
                    }
                    if (!(ktElement instanceof KtParenthesizedExpression)) break block4;
                    KtExpression ktExpression = ((KtParenthesizedExpression)$this$findSimpleNameExpression).getExpression();
                    if (ktExpression == null) break;
                    $this$findSimpleNameExpression = (KtElement)ktExpression;
                }
                ktSimpleNameExpression = null;
                break block3;
            }
            ktSimpleNameExpression = ktElement instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)$this$findSimpleNameExpression : null;
        }
        return ktSimpleNameExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isErroneous(@NotNull PsiType $this$isErroneous) {
        Intrinsics.checkNotNullParameter((Object)$this$isErroneous, (String)"<this>");
        if ($this$isErroneous instanceof UastErrorType) return true;
        String string2 = $this$isErroneous.getCanonicalText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalText(...)");
        if (!Intrinsics.areEqual((Object)StringsKt.replace$default((String)string2, (String)".", (String)"/", (boolean)false, (int)4, null), (Object)"error/NonExistentClass")) return false;
        return true;
    }

    public static final boolean isElvisIf(@NotNull UIfExpression $this$isElvisIf) {
        Intrinsics.checkNotNullParameter((Object)$this$isElvisIf, (String)"<this>");
        UElement parent = UastUtils.skipParenthesizedExprUp((UElement)$this$isElvisIf.getUastParent());
        return parent instanceof UExpressionList && Intrinsics.areEqual((Object)((UExpressionList)parent).getKind(), (Object)KotlinSpecialExpressionKinds.ELVIS);
    }

    public static final boolean isThisOrSuperConstructorCall(@NotNull UCallExpression $this$isThisOrSuperConstructorCall) {
        Intrinsics.checkNotNullParameter((Object)$this$isThisOrSuperConstructorCall, (String)"<this>");
        return UastLintUtilsKt.isSuperConstructorCall($this$isThisOrSuperConstructorCall) || UastLintUtilsKt.isThisConstructorCall($this$isThisOrSuperConstructorCall);
    }

    public static final boolean isSuperConstructorCall(@NotNull UCallExpression $this$isSuperConstructorCall) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuperConstructorCall, (String)"<this>");
        PsiElement psiElement = $this$isSuperConstructorCall.getSourcePsi();
        return psiElement instanceof KtSuperTypeCallEntry ? true : (psiElement instanceof PsiMethodCallExpression ? Intrinsics.areEqual((Object)$this$isSuperConstructorCall.getMethodName(), (Object)"super") : false);
    }

    public static final boolean isThisConstructorCall(@NotNull UCallExpression $this$isThisConstructorCall) {
        Intrinsics.checkNotNullParameter((Object)$this$isThisConstructorCall, (String)"<this>");
        PsiElement psiElement = $this$isThisConstructorCall.getSourcePsi();
        return psiElement instanceof KtThisExpression ? true : (psiElement instanceof PsiMethodCallExpression ? Intrinsics.areEqual((Object)$this$isThisConstructorCall.getMethodName(), (Object)"this") : false);
    }

    @Nullable
    public static final UExpression getExplicitReceiver(@NotNull UCallExpression $this$explicitReceiver) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$explicitReceiver, (String)"<this>");
        UExpression uExpression = $this$explicitReceiver.getReceiver();
        if (uExpression != null) {
            UExpression uExpression2;
            UExpression it = uExpression2 = uExpression;
            boolean bl = false;
            object = it.getSourcePsi() != null ? uExpression2 : null;
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public static final UExpression getImplicitReceiver(@NotNull UCallExpression $this$implicitReceiver) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$implicitReceiver, (String)"<this>");
        UExpression uExpression = $this$implicitReceiver.getReceiver();
        if (uExpression != null) {
            UExpression uExpression2;
            UExpression it = uExpression2 = uExpression;
            boolean bl = false;
            object = it.getSourcePsi() == null ? uExpression2 : null;
        } else {
            object = null;
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void acceptSourceFile(@NotNull UFile $this$acceptSourceFile, @NotNull UastVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)$this$acceptSourceFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        PsiFile sourcePsi = $this$acceptSourceFile.getSourcePsi();
        if (sourcePsi instanceof KtFile) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = ((KtFile)sourcePsi).getAnnotationEntries();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                        boolean bl2 = false;
                        Name name = it.getShortName();
                        if (!Intrinsics.areEqual((Object)(name != null ? name.asString() : null), (Object)JvmStandardClassIds.INSTANCE.getJVM_MULTIFILE_CLASS_SHORT())) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                UastLintUtilsKt.acceptMultiFileClass($this$acceptSourceFile, visitor2);
                return;
            }
        }
        $this$acceptSourceFile.accept(visitor2);
    }

    public static final boolean isDuplicatedOverload(@NotNull UMethod $this$isDuplicatedOverload) {
        boolean bl;
        KtFunction method;
        block10: {
            Intrinsics.checkNotNullParameter((Object)$this$isDuplicatedOverload, (String)"<this>");
            PsiElement psiElement = $this$isDuplicatedOverload.getSourcePsi();
            KtFunction ktFunction = psiElement instanceof KtFunction ? (KtFunction)psiElement : null;
            if (ktFunction == null) {
                return false;
            }
            method = ktFunction;
            String string2 = method.getName();
            if (string2 != null) {
                String name = string2;
                boolean bl2 = false;
                if (!StringsKt.startsWith$default((String)$this$isDuplicatedOverload.getName(), (String)name, (boolean)false, (int)2, null)) {
                    return false;
                }
            }
            List list2 = method.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAnnotationEntries(...)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                    boolean bl3 = false;
                    Name name = it.getShortName();
                    if (!Intrinsics.areEqual((Object)(name != null ? name.asString() : null), (Object)JvmStandardClassIds.INSTANCE.getJVM_OVERLOADS_FQ_NAME().shortName().asString())) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            UDeclaration uDeclaration;
            UElement uElement = $this$isDuplicatedOverload.getUastParent();
            Object object = uElement instanceof UClass ? (UClass)uElement : null;
            if (object != null && (object = object.getUastDeclarations()) != null) {
                Object v6;
                block11: {
                    Iterable $this$firstOrNull$iv = (Iterable)object;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        UDeclaration it = (UDeclaration)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it.getSourcePsi(), (Object)method)) continue;
                        v6 = element$iv;
                        break block11;
                    }
                    v6 = null;
                }
                uDeclaration = v6;
            } else {
                uDeclaration = null;
            }
            UDeclaration firstMethod = uDeclaration;
            return !Intrinsics.areEqual(firstMethod, (Object)$this$isDuplicatedOverload);
        }
        return false;
    }

    @NotNull
    public static final UExpression skipLabeledExpression(@NotNull UExpression $this$skipLabeledExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$skipLabeledExpression, (String)"<this>");
        UExpression expression = $this$skipLabeledExpression;
        while (expression instanceof ULabeledExpression) {
            expression = ((ULabeledExpression)expression).getExpression();
        }
        return expression;
    }

    private static final void acceptMultiFileClass(UFile $this$acceptMultiFileClass, UastVisitor visitor2) {
        VirtualFile targetFile = $this$acceptMultiFileClass.getSourcePsi().getVirtualFile();
        if (visitor2.visitFile($this$acceptMultiFileClass)) {
            return;
        }
        ImplementationUtilsKt.acceptList((List)$this$acceptMultiFileClass.getUAnnotations(), (UastVisitor)visitor2);
        ImplementationUtilsKt.acceptList((List)$this$acceptMultiFileClass.getImports(), (UastVisitor)visitor2);
        for (UClass uClass : $this$acceptMultiFileClass.getClasses()) {
            if (visitor2.visitClass(uClass)) {
                return;
            }
            ImplementationUtilsKt.acceptList((List)uClass.getUAnnotations(), (UastVisitor)visitor2);
            for (UDeclaration declaration : uClass.getUastDeclarations()) {
                VirtualFile declarationFile;
                PsiElement psiElement = declaration.getSourcePsi();
                VirtualFile virtualFile = psiElement != null && (psiElement = psiElement.getContainingFile()) != null ? psiElement.getVirtualFile() : (declarationFile = null);
                if (declarationFile != null && !Intrinsics.areEqual((Object)declarationFile, (Object)targetFile)) continue;
                declaration.accept(visitor2);
            }
            visitor2.afterVisitClass(uClass);
        }
        visitor2.afterVisitFile($this$acceptMultiFileClass);
    }

    public static final boolean isUnconditionalReturn(@NotNull UExpression $this$isUnconditionalReturn) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnconditionalReturn, (String)"<this>");
        return UastLintUtilsKt.isUnconditionalReturn$check($this$isUnconditionalReturn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isExhaustive(USwitchExpression $this$isExhaustive) {
        boolean bl;
        if (Lint.isKotlin($this$isExhaustive.getBody().getLang())) {
            boolean lock$iv$iv22;
            void this_$iv$iv;
            boolean bl2;
            PsiElement psiElement = $this$isExhaustive.getSourcePsi();
            if (!(psiElement instanceof KtWhenExpression)) return false;
            KtWhenExpression ktWhenExpression = (KtWhenExpression)psiElement;
            if (ktWhenExpression == null) {
                return false;
            }
            KtWhenExpression ktWhen = ktWhenExpression;
            List list2 = ktWhen.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEntries(...)");
            KtWhenEntry ktWhenEntry = (KtWhenEntry)CollectionsKt.lastOrNull((List)list2);
            if (ktWhenEntry != null) {
                if (ktWhenEntry.isElse()) {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) return true;
            KtElement useSiteElement$iv = (KtElement)ktWhen;
            boolean $i$f$analyze = false;
            Project project = useSiteElement$iv.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
            KtElement useSiteElement$iv$iv = useSiteElement$iv;
            boolean $i$f$analyze2 = false;
            KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
            this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
            try {
                boolean bl3;
                Object lock$iv$iv22;
                Object object = lock$iv$iv22 = new Object();
                synchronized (object) {
                    bl3 = false;
                    KaSession $this$isExhaustive_u24lambda_u2412 = analysisSession$iv$iv;
                    boolean bl4 = false;
                    bl3 = $this$isExhaustive_u24lambda_u2412.computeMissingCases(ktWhen).isEmpty();
                }
                lock$iv$iv22 = bl3;
            }
            catch (Throwable throwable$iv$iv) {
                this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
                throw new KotlinNothingValueException();
            }
            finally {
                this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
            }
            if (!lock$iv$iv22) return false;
            return true;
        }
        if (!Lint.isJava($this$isExhaustive.getBody().getLang())) return false;
        Iterable $this$any$iv = $this$isExhaustive.getBody().getExpressions();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            UExpression uExpression = (UExpression)element$iv;
            boolean bl5 = false;
            if (uExpression instanceof USwitchClauseExpressionWithBody) {
                boolean bl6;
                Iterable $this$any$iv2 = ((USwitchClauseExpressionWithBody)uExpression).getCaseValues();
                boolean $i$f$any2 = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    bl6 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv2) {
                        UExpression it = (UExpression)element$iv2;
                        boolean bl7 = false;
                        PsiElement value = it.getSourcePsi();
                        if (value instanceof PsiSwitchLabelStatement && ((PsiSwitchLabelStatement)value).isDefaultCase()) {
                            return true;
                        }
                        boolean bl8 = false;
                        if (!bl8) continue;
                        return true;
                    }
                    bl6 = false;
                }
                if (bl6) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final boolean callNeverReturns(@NotNull UCallExpression call2) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        PsiElement sourcePsi = call2.getSourcePsi();
        if (sourcePsi instanceof KtCallExpression) {
            void this_$iv$iv;
            KtElement useSiteElement$iv = (KtElement)sourcePsi;
            boolean $i$f$analyze = false;
            Project project = useSiteElement$iv.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
            KtElement useSiteElement$iv$iv = useSiteElement$iv;
            boolean $i$f$analyze2 = false;
            KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
            this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
            try {
                Unit unit;
                Object lock$iv$iv;
                Object object = lock$iv$iv = new Object();
                synchronized (object) {
                    block13: {
                        KaType returnType;
                        boolean bl = false;
                        KaSession $this$callNeverReturns_u24lambda_u2415 = analysisSession$iv$iv;
                        boolean bl2 = false;
                        KaCallInfo callInfo = $this$callNeverReturns_u24lambda_u2415.resolveToCall((KtElement)sourcePsi);
                        if (callInfo == null) break block13;
                        KaFunctionCall kaFunctionCall = KaCallInfoKt.singleFunctionCallOrNull((KaCallInfo)callInfo);
                        KaType kaType = kaFunctionCall != null && (kaFunctionCall = (KaFunctionSymbol)KaCallKt.getSymbol((KaCallableMemberCall)((KaCallableMemberCall)kaFunctionCall))) != null ? ((KaCallableSymbol)kaFunctionCall).getReturnType() : (returnType = null);
                        if (returnType == null || !$this$callNeverReturns_u24lambda_u2415.isNothingType(returnType) || returnType.getNullability().isNullable()) break block13;
                        boolean bl3 = true;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 12] lbl28 : MonitorExitStatement: MONITOREXIT : var9_9
                        boolean bl4 = bl3;
                        return bl4;
                    }
                    unit = Unit.INSTANCE;
                }
                Unit unit2 = unit;
            }
            catch (Throwable throwable$iv$iv) {
                this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
                throw new KotlinNothingValueException();
            }
            finally {
                this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
            }
        }
        if (Intrinsics.areEqual((Object)Lint.getMethodName(call2), (Object)"fail")) {
            PsiMethod psiMethod = call2.resolve();
            if (Intrinsics.areEqual((Object)(psiMethod != null ? psiMethod.getReturnType() : null), (Object)PsiTypes.voidType())) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static final UElement findCommonParent(@NotNull UElement element1, @NotNull UElement element2) {
        int depth1;
        Intrinsics.checkNotNullParameter((Object)element1, (String)"element1");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element2");
        if (element1 == element2) {
            return element1;
        }
        int depth2 = UastLintUtilsKt.getDepth(element2);
        UElement parent1 = element1;
        UElement parent2 = element2;
        for (depth1 = UastLintUtilsKt.getDepth(element1); depth1 > depth2; --depth1) {
            UElement uElement = parent1;
            parent1 = uElement != null ? uElement.getUastParent() : null;
        }
        while (depth2 > depth1) {
            UElement uElement = parent2;
            parent2 = uElement != null ? uElement.getUastParent() : null;
            --depth2;
        }
        while (parent1 != null && parent2 != null && !Intrinsics.areEqual((Object)parent1, (Object)parent2)) {
            parent1 = parent1.getUastParent();
            parent2 = parent2.getUastParent();
        }
        if (parent2 == null) {
            return null;
        }
        return parent1;
    }

    private static final int getDepth(UElement element) {
        int depth = 0;
        for (UElement parent = element; parent != null; parent = parent.getUastParent()) {
            ++depth;
        }
        return depth;
    }

    public static final boolean isSyntheticJavaGetterSetterCallForPropertyAccess(@NotNull UCallExpression $this$isSyntheticJavaGetterSetterCallForPropertyAccess) {
        Intrinsics.checkNotNullParameter((Object)$this$isSyntheticJavaGetterSetterCallForPropertyAccess, (String)"<this>");
        return $this$isSyntheticJavaGetterSetterCallForPropertyAccess.getUastParent() instanceof USimpleNameReferenceExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<Boolean, String> isClassReference(@NotNull UExpression $this$isClassReference, boolean checkClass, boolean checkInterface, boolean checkCompanion) {
        Pair pair2;
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$isClassReference, (String)"<this>");
        boolean isSimpleRefExpression = $this$isClassReference instanceof USimpleNameReferenceExpression;
        boolean isQualifiedRefExpression = $this$isClassReference instanceof UQualifiedReferenceExpression;
        if (!isSimpleRefExpression && !isQualifiedRefExpression) {
            return TuplesKt.to((Object)false, null);
        }
        PsiElement psiElement = $this$isClassReference.getSourcePsi();
        KtExpression ktExpression = psiElement instanceof KtExpression ? (KtExpression)psiElement : null;
        if (ktExpression == null) {
            return TuplesKt.to((Object)false, null);
        }
        KtExpression sourcePsi = ktExpression;
        KtElement useSiteElement$iv = (KtElement)sourcePsi;
        boolean $i$f$analyze = false;
        Project project = useSiteElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
        KtElement useSiteElement$iv$iv = useSiteElement$iv;
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        try {
            Pair pair3;
            Object lock$iv$iv;
            Object object = lock$iv$iv = new Object();
            synchronized (object) {
                KaClassSymbol kaClassSymbol;
                block12: {
                    KaSymbol kaSymbol;
                    PsiElement lastChild;
                    boolean bl = false;
                    KaSession $this$isClassReference_u24lambda_u2416 = analysisSession$iv$iv;
                    boolean bl2 = false;
                    KtExpression ktExpression2 = sourcePsi;
                    KaSymbol kaSymbol2 = ktExpression2 instanceof KtDotQualifiedExpression ? ((lastChild = ((KtDotQualifiedExpression)sourcePsi).getLastChild()) instanceof KtReferenceExpression ? $this$isClassReference_u24lambda_u2416.resolveToSymbol(ReferenceUtilsKt.getMainReference((KtReferenceExpression)((KtReferenceExpression)lastChild))) : null) : (kaSymbol = ktExpression2 instanceof KtReferenceExpression ? $this$isClassReference_u24lambda_u2416.resolveToSymbol(ReferenceUtilsKt.getMainReference((KtReferenceExpression)((KtReferenceExpression)sourcePsi))) : null);
                    if ((kaSymbol instanceof KaClassSymbol ? (KaClassSymbol)kaSymbol : null) != null) break block12;
                    Pair pair4 = TuplesKt.to((Object)false, null);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl33 : MonitorExitStatement: MONITOREXIT : var14_15
                    Pair pair5 = pair4;
                    return pair5;
                }
                KaClassSymbol symbol = kaClassSymbol;
                Name name = symbol.getName();
                pair3 = TuplesKt.to((Object)(checkClass && symbol.getClassKind().isClass() || checkInterface && symbol.getClassKind() == KaClassKind.INTERFACE || checkCompanion && symbol.getClassKind() == KaClassKind.COMPANION_OBJECT ? 1 : 0), (Object)(name != null ? name.asString() : null));
            }
            pair2 = pair3;
        }
        catch (Throwable throwable$iv$iv) {
            this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
            throw new KotlinNothingValueException();
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        }
        return pair2;
    }

    public static /* synthetic */ Pair isClassReference$default(UExpression uExpression, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        if ((n & 4) != 0) {
            bl3 = true;
        }
        return UastLintUtilsKt.isClassReference(uExpression, bl, bl2, bl3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isUnconditionalReturn$check(UExpression statement) {
        UExpression uExpression = statement;
        if (uExpression instanceof UBlockExpression) {
            UExpression p0;
            Iterable $this$any$iv = ((UBlockExpression)statement).getExpressions();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                p0 = (UExpression)element$iv;
                boolean bl = false;
            } while (!UastLintUtilsKt.isUnconditionalReturn$check(p0));
            return true;
        }
        if (uExpression instanceof UExpressionList) {
            UExpression p0;
            Iterable $this$any$iv = ((UExpressionList)statement).getExpressions();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                p0 = (UExpression)element$iv;
                boolean bl = false;
            } while (!UastLintUtilsKt.isUnconditionalReturn$check(p0));
            return true;
        }
        if (uExpression instanceof UYieldExpression) {
            v0 = UastLintUtilsKt.isUnconditionalReturn$check(((UYieldExpression)statement).getExpression());
            return v0;
        } else if (uExpression instanceof UParenthesizedExpression) {
            v0 = UastLintUtilsKt.isUnconditionalReturn$check(((UParenthesizedExpression)statement).getExpression());
            return v0;
        } else {
            if (uExpression instanceof UIfExpression) {
                if (UastLintUtilsKt.isUnconditionalReturn$check(((UIfExpression)statement).getCondition())) return true;
                if (!UastLintUtilsKt.isUnconditionalReturn$check(((UIfExpression)statement).getThenExpression())) return false;
                if (!UastLintUtilsKt.isUnconditionalReturn$check(((UIfExpression)statement).getElseExpression())) return false;
                return true;
            }
            if (uExpression instanceof USwitchExpression) {
                boolean bl;
                if (!UastLintUtilsKt.isExhaustive((USwitchExpression)statement)) return false;
                Iterable $this$all$iv = ((USwitchExpression)statement).getBody().getExpressions();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    return true;
                }
                Iterator iterator = $this$all$iv.iterator();
                do {
                    if (!iterator.hasNext()) return true;
                    Object element$iv = iterator.next();
                    UExpression uExpression2 = (UExpression)element$iv;
                    boolean bl2 = false;
                    if (!(uExpression2 instanceof USwitchClauseExpressionWithBody)) return false;
                    if (!UastLintUtilsKt.isUnconditionalReturn$check((UExpression)((USwitchClauseExpressionWithBody)uExpression2).getBody())) return false;
                    bl = true;
                } while (bl);
                return false;
            }
            if (uExpression instanceof UQualifiedReferenceExpression) {
                UElement $this$all$iv = UastLintUtilsKt.findSelector((UElement)statement);
                v0 = UastLintUtilsKt.isUnconditionalReturn$check($this$all$iv instanceof UExpression ? (UExpression)$this$all$iv : null);
                return v0;
            } else {
                UExpression p0;
                if (uExpression instanceof UReturnExpression) return true;
                if (uExpression instanceof UThrowExpression) {
                    return true;
                }
                if (!(uExpression instanceof UCallExpression)) return false;
                if (UastLintUtilsKt.callNeverReturns((UCallExpression)statement)) return true;
                if (UastLintUtilsKt.isUnconditionalReturn$check(((UCallExpression)statement).getReceiver())) return true;
                Iterable $this$any$iv = ((UCallExpression)statement).getValueArguments();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator iterator = $this$any$iv.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                    Object element$iv = iterator.next();
                    p0 = (UExpression)element$iv;
                    boolean bl = false;
                } while (!UastLintUtilsKt.isUnconditionalReturn$check(p0));
                return true;
            }
        }
    }
}

