/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.manifest.parser;

import com.android.tools.manifest.parser.BinaryXmlParser;
import com.android.tools.manifest.parser.XmlNode;
import com.android.tools.manifest.parser.components.ManifestActivityInfo;
import com.android.tools.manifest.parser.components.ManifestReceiverInfo;
import com.android.tools.manifest.parser.components.ManifestServiceInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ManifestInfo {
    private final List<ManifestActivityInfo> activities = new ArrayList<ManifestActivityInfo>();
    private final List<ManifestReceiverInfo> receivers;
    private final List<ManifestServiceInfo> services = new ArrayList<ManifestServiceInfo>();
    private final List<String> sdkLibraries;
    private final List<String> instrumentationTargetPackages;
    private String applicationId = "";
    private String split = null;
    private int versionCode = 0;
    private boolean debuggable = false;
    private String minSdk;
    private String targetSdk;

    private ManifestInfo() {
        this.receivers = new ArrayList<ManifestReceiverInfo>();
        this.sdkLibraries = new ArrayList<String>();
        this.instrumentationTargetPackages = new ArrayList<String>();
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public List<ManifestActivityInfo> activities() {
        return this.activities;
    }

    public List<ManifestReceiverInfo> receivers() {
        return this.receivers;
    }

    public List<ManifestServiceInfo> services() {
        return this.services;
    }

    public List<String> getSdkLibraries() {
        return this.sdkLibraries;
    }

    public List<String> getInstrumentationTargetPackages() {
        return this.instrumentationTargetPackages;
    }

    public String getSplitName() {
        return this.split;
    }

    public int getVersionCode() {
        return this.versionCode;
    }

    public boolean getDebuggable() {
        return this.debuggable;
    }

    public String getMinSdk() {
        return this.minSdk == null ? "1" : this.minSdk;
    }

    public String getTargetSdk() {
        return this.targetSdk == null ? this.getMinSdk() : this.targetSdk;
    }

    private void parseNode(XmlNode node) {
        for (String attribute : node.attributes().keySet()) {
            String value = node.attributes().get(attribute);
            if ("package".equals(attribute)) {
                this.applicationId = value;
                continue;
            }
            if ("split".equals(attribute)) {
                this.split = value;
                continue;
            }
            if (!"versionCode".equals(attribute) || value.isEmpty()) continue;
            this.versionCode = Integer.parseInt(value);
        }
        for (XmlNode child : node.children()) {
            if ("application".equals(child.name())) {
                this.parseApplication(child);
                continue;
            }
            if ("instrumentation".equals(child.name())) {
                this.parseInstrumentation(child);
                continue;
            }
            if (!"uses-sdk".equals(child.name())) continue;
            this.parseUseSdk(child);
        }
    }

    private void parseInstrumentation(XmlNode node) {
        for (String attribute : node.attributes().keySet()) {
            if (!"targetPackage".equals(attribute)) continue;
            this.instrumentationTargetPackages.add(node.attributes().get(attribute));
        }
    }

    private void parseApplication(XmlNode node) {
        this.debuggable = Boolean.parseBoolean(node.attributes().getOrDefault("debuggable", "false"));
        for (XmlNode child : node.children()) {
            if ("activity".equals(child.name()) || "activity-alias".equals(child.name())) {
                this.activities.add(new ManifestActivityInfo(child, this.applicationId));
                continue;
            }
            if ("receiver".equals(child.name())) {
                this.receivers.add(new ManifestReceiverInfo(child, this.applicationId));
                continue;
            }
            if ("service".equals(child.name())) {
                this.services.add(new ManifestServiceInfo(child, this.applicationId));
                continue;
            }
            if (!"sdk-library".equals(child.name())) continue;
            this.sdkLibraries.add(child.attributes().get("name"));
        }
    }

    private void parseUseSdk(XmlNode node) {
        this.minSdk = node.attributes().getOrDefault("minSdkVersion", "1");
        this.targetSdk = node.attributes().getOrDefault("targetSdkVersion", null);
    }

    public static ManifestInfo parseBinaryFromStream(InputStream inputStream2) throws IOException {
        XmlNode node = BinaryXmlParser.parse(inputStream2);
        ManifestInfo manifest = new ManifestInfo();
        manifest.parseNode(node);
        return manifest;
    }
}

