/*
 * Decompiled with CFR 0.152.
 */
package kexter.core;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kexter.core.DexHeaderKt;
import kexter.core.DexReader;
import kexter.core.EndianTag;
import kexter.core.Span;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 -2\u00020\u0001:\u0001-B\u007f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\f\u0012\u0006\u0010\u0010\u001a\u00020\f\u0012\u0006\u0010\u0011\u001a\u00020\f\u0012\u0006\u0010\u0012\u001a\u00020\f\u0012\u0006\u0010\u0013\u001a\u00020\f\u0012\u0006\u0010\u0014\u001a\u00020\f\u00a2\u0006\u0004\b\u0015\u0010\u0016J\b\u0010+\u001a\u00020,H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u0013\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u001d\u0010\u001aR\u0013\u0010\b\u001a\u00020\u0005\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u001e\u0010\u001aR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0013\u0010\r\u001a\u00020\u0005\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b#\u0010\u001aR\u0011\u0010\u000e\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\"R\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\"R\u0011\u0010\u0010\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\"R\u0011\u0010\u0011\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\"R\u0011\u0010\u0012\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\"R\u0011\u0010\u0013\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\"R\u0011\u0010\u0014\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\"\u00a8\u0006."}, d2={"Lkexter/core/DexHeader;", "", "magic", "", "checksum", "Lkotlin/UInt;", "sha1Hash", "fileSize", "headerSize", "endianTag", "Lkexter/core/EndianTag;", "link", "Lkexter/core/Span;", "mapOffset", "stringIds", "typeIds", "protoIds", "fieldIds", "methodsIds", "classDefs", "data", "<init>", "([BI[BIILkexter/core/EndianTag;Lkexter/core/Span;ILkexter/core/Span;Lkexter/core/Span;Lkexter/core/Span;Lkexter/core/Span;Lkexter/core/Span;Lkexter/core/Span;Lkexter/core/Span;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getMagic", "()[B", "getChecksum-pVg5ArA", "()I", "I", "getSha1Hash", "getFileSize-pVg5ArA", "getHeaderSize-pVg5ArA", "getEndianTag", "()Lkexter/core/EndianTag;", "getLink", "()Lkexter/core/Span;", "getMapOffset-pVg5ArA", "getStringIds", "getTypeIds", "getProtoIds", "getFieldIds", "getMethodsIds", "getClassDefs", "getData", "toString", "", "Companion", "android.sdktools.kexter"})
public final class DexHeader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] magic;
    private final int checksum;
    @NotNull
    private final byte[] sha1Hash;
    private final int fileSize;
    private final int headerSize;
    @NotNull
    private final EndianTag endianTag;
    @NotNull
    private final Span link;
    private final int mapOffset;
    @NotNull
    private final Span stringIds;
    @NotNull
    private final Span typeIds;
    @NotNull
    private final Span protoIds;
    @NotNull
    private final Span fieldIds;
    @NotNull
    private final Span methodsIds;
    @NotNull
    private final Span classDefs;
    @NotNull
    private final Span data;
    @NotNull
    private static final String MAGIC_PREFIX = "dex\n";
    @NotNull
    private static final String MAGIC_SUFFIX = "\u0000";

    private DexHeader(byte[] magic, int checksum, byte[] sha1Hash, int fileSize, int headerSize, EndianTag endianTag, Span link, int mapOffset, Span stringIds, Span typeIds, Span protoIds, Span fieldIds, Span methodsIds, Span classDefs, Span data) {
        Intrinsics.checkNotNullParameter((Object)magic, (String)"magic");
        Intrinsics.checkNotNullParameter((Object)sha1Hash, (String)"sha1Hash");
        Intrinsics.checkNotNullParameter((Object)((Object)endianTag), (String)"endianTag");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter((Object)stringIds, (String)"stringIds");
        Intrinsics.checkNotNullParameter((Object)typeIds, (String)"typeIds");
        Intrinsics.checkNotNullParameter((Object)protoIds, (String)"protoIds");
        Intrinsics.checkNotNullParameter((Object)fieldIds, (String)"fieldIds");
        Intrinsics.checkNotNullParameter((Object)methodsIds, (String)"methodsIds");
        Intrinsics.checkNotNullParameter((Object)classDefs, (String)"classDefs");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.magic = magic;
        this.checksum = checksum;
        this.sha1Hash = sha1Hash;
        this.fileSize = fileSize;
        this.headerSize = headerSize;
        this.endianTag = endianTag;
        this.link = link;
        this.mapOffset = mapOffset;
        this.stringIds = stringIds;
        this.typeIds = typeIds;
        this.protoIds = protoIds;
        this.fieldIds = fieldIds;
        this.methodsIds = methodsIds;
        this.classDefs = classDefs;
        this.data = data;
    }

    @NotNull
    public final byte[] getMagic() {
        return this.magic;
    }

    public final int getChecksum-pVg5ArA() {
        return this.checksum;
    }

    @NotNull
    public final byte[] getSha1Hash() {
        return this.sha1Hash;
    }

    public final int getFileSize-pVg5ArA() {
        return this.fileSize;
    }

    public final int getHeaderSize-pVg5ArA() {
        return this.headerSize;
    }

    @NotNull
    public final EndianTag getEndianTag() {
        return this.endianTag;
    }

    @NotNull
    public final Span getLink() {
        return this.link;
    }

    public final int getMapOffset-pVg5ArA() {
        return this.mapOffset;
    }

    @NotNull
    public final Span getStringIds() {
        return this.stringIds;
    }

    @NotNull
    public final Span getTypeIds() {
        return this.typeIds;
    }

    @NotNull
    public final Span getProtoIds() {
        return this.protoIds;
    }

    @NotNull
    public final Span getFieldIds() {
        return this.fieldIds;
    }

    @NotNull
    public final Span getMethodsIds() {
        return this.methodsIds;
    }

    @NotNull
    public final Span getClassDefs() {
        return this.classDefs;
    }

    @NotNull
    public final Span getData() {
        return this.data;
    }

    @NotNull
    public String toString() {
        return StringsKt.trimIndent((String)("\n\t\t\tMagic      : '" + DexHeaderKt.access$toHexString(this.magic) + "'\n\t\t\tChecksum   : " + UInt.toString-impl((int)this.checksum) + "\n\t\t\tSha1 hash  : " + DexHeaderKt.access$toSha1String(this.sha1Hash) + "\n\t\t\tFile size  : " + DexHeaderKt.access$nice-WZ4Q5Ns(this.fileSize) + "\n\t\t\tHeader size: " + DexHeaderKt.access$nice-WZ4Q5Ns(this.headerSize) + "\n\t\t\tEndian Tag : " + this.endianTag + "\n\t\t\tLink       : " + this.link + "\n\t\t\tMap offset : " + UInt.toString-impl((int)this.mapOffset) + "\n\t\t\tString ids : " + this.stringIds + "\n\t\t\tType ids   : " + this.typeIds + "\n\t\t\tProto ids  : " + this.protoIds + "\n\t\t\tField ids  : " + this.fieldIds + "\n\t\t\tMethod ids : " + this.methodsIds + "\n\t\t\tClass defs : " + this.classDefs + "\n\t\t\tData       : " + this.data + "\n\t\t"));
    }

    public /* synthetic */ DexHeader(byte[] magic, int checksum, byte[] sha1Hash, int fileSize, int headerSize, EndianTag endianTag, Span link, int mapOffset, Span stringIds, Span typeIds, Span protoIds, Span fieldIds, Span methodsIds, Span classDefs, Span data, DefaultConstructorMarker $constructor_marker) {
        this(magic, checksum, sha1Hash, fileSize, headerSize, endianTag, link, mapOffset, stringIds, typeIds, protoIds, fieldIds, methodsIds, classDefs, data);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lkexter/core/DexHeader$Companion;", "", "<init>", "()V", "MAGIC_PREFIX", "", "MAGIC_SUFFIX", "parse", "Lkexter/core/DexHeader;", "reader", "Lkexter/core/DexReader;", "android.sdktools.kexter"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DexHeader parse(@NotNull DexReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            byte[] magic = reader.bytes-WZ4Q5Ns(8);
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            String magicString = new String(magic, charset2);
            if (!StringsKt.startsWith$default((String)magicString, (String)DexHeader.MAGIC_PREFIX, (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)magicString, (String)DexHeader.MAGIC_SUFFIX, (boolean)false, (int)2, null)) {
                throw new IllegalStateException("Bad dex magic number ('" + DexHeaderKt.access$toHexString(magic) + "')!");
            }
            int checksum = reader.uint-pVg5ArA();
            byte[] sha1Hash = reader.bytes-WZ4Q5Ns(20);
            int fileSize = reader.uint-pVg5ArA();
            int headerSize = reader.uint-pVg5ArA();
            EndianTag endianTag = EndianTag.Companion.fromUInt-WZ4Q5Ns(reader.uint-pVg5ArA());
            Span link = reader.span();
            int mapOffset = reader.uint-pVg5ArA();
            Span stringIds = reader.span();
            Span typeIds = reader.span();
            Span protoIds = reader.span();
            Span fieldIds = reader.span();
            Span methodsIds = reader.span();
            Span classDefs = reader.span();
            Span data = reader.span();
            return new DexHeader(magic, checksum, sha1Hash, fileSize, headerSize, endianTag, link, mapOffset, stringIds, typeIds, protoIds, fieldIds, methodsIds, classDefs, data, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

