/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.ir.cfg;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.impl.ir.cfg.IrCFGBlockImpl;
import com.intellij.rml.dfa.ir.cfg.IrBoolExprGraph;
import com.intellij.rml.dfa.ir.cfg.IrCFGBlock;
import com.intellij.rml.dfa.ir.cfg.IrCfg;
import com.intellij.rml.dfa.ir.cfg.IrJump;
import com.intellij.rml.dfa.ir.cfg.IrUnconditionalJump;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\tJ\u0016\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006J\u0006\u0010\u0014\u001a\u00020\u0006J\u0016\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006J\u001e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/rml/dfa/impl/ir/cfg/IrCfgCombiner;", "", "<init>", "()V", "blocks", "", "Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;", "jumps", "", "Lcom/intellij/rml/dfa/ir/cfg/IrJump;", "addSubCfg", "", "cfg", "Lcom/intellij/rml/dfa/ir/cfg/IrCfg;", "Lcom/intellij/rml/dfa/ir/cfg/IrBoolExprGraph;", "setJump", "from", "jump", "setUnconditionalJump", "to", "createBlock", "build", "enterBlock", "exitBlock", "conditionEnterNode", "trueBranch", "falseBranch", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nIrCfgCombiner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrCfgCombiner.kt\ncom/intellij/rml/dfa/impl/ir/cfg/IrCfgCombiner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,41:1\n1#2:42\n*E\n"})
public final class IrCfgCombiner {
    @NotNull
    private final Set<IrCFGBlock> blocks = new LinkedHashSet();
    @NotNull
    private final Map<IrCFGBlock, IrJump> jumps = new LinkedHashMap();

    public final void addSubCfg(@NotNull IrCfg cfg2) {
        Intrinsics.checkNotNullParameter((Object)cfg2, (String)"cfg");
        CollectionsKt.addAll((Collection)this.blocks, (Iterable)cfg2.getBlocks());
        this.jumps.putAll(cfg2.getJumps());
    }

    public final void addSubCfg(@NotNull IrBoolExprGraph cfg2) {
        Intrinsics.checkNotNullParameter((Object)cfg2, (String)"cfg");
        CollectionsKt.addAll((Collection)this.blocks, (Iterable)cfg2.getBlocks());
        this.jumps.putAll(cfg2.getJumps());
    }

    public final void setJump(@NotNull IrCFGBlock from, @NotNull IrJump jump) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        if (this.jumps.containsKey(from)) {
            throw new DfaInternalException("Jump from block \n" + from + "\n already exists");
        }
        this.jumps.put(from, jump);
    }

    public final void setUnconditionalJump(@NotNull IrCFGBlock from, @NotNull IrCFGBlock to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.setJump(from, (IrJump)new IrUnconditionalJump(to));
    }

    @NotNull
    public final IrCFGBlock createBlock() {
        IrCFGBlockImpl irCFGBlockImpl;
        IrCFGBlockImpl it = irCFGBlockImpl = new IrCFGBlockImpl(null, 1, null);
        boolean bl = false;
        ((Collection)this.blocks).add(it);
        return irCFGBlockImpl;
    }

    @NotNull
    public final IrCfg build(@NotNull IrCFGBlock enterBlock, @NotNull IrCFGBlock exitBlock) {
        Intrinsics.checkNotNullParameter((Object)enterBlock, (String)"enterBlock");
        Intrinsics.checkNotNullParameter((Object)exitBlock, (String)"exitBlock");
        return new IrCfg(this.blocks, this.jumps, enterBlock, exitBlock);
    }

    @NotNull
    public final IrBoolExprGraph build(@NotNull IrCFGBlock conditionEnterNode, @NotNull IrCFGBlock trueBranch, @NotNull IrCFGBlock falseBranch) {
        Intrinsics.checkNotNullParameter((Object)conditionEnterNode, (String)"conditionEnterNode");
        Intrinsics.checkNotNullParameter((Object)trueBranch, (String)"trueBranch");
        Intrinsics.checkNotNullParameter((Object)falseBranch, (String)"falseBranch");
        return new IrBoolExprGraph(this.blocks, this.jumps, conditionEnterNode, trueBranch, falseBranch);
    }
}

