/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.LibTypes;
import android.databinding.tool.processing.Scope;
import android.databinding.tool.store.GenClassInfoLog;
import android.databinding.tool.store.LayoutInfoInput;
import android.databinding.tool.store.LayoutInfoLog;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.writer.BaseLayoutBinderWriter;
import android.databinding.tool.writer.BaseLayoutModel;
import android.databinding.tool.writer.JavaFileWriter;
import android.databinding.tool.writer.ViewBinder;
import android.databinding.tool.writer.ViewBinderGenerateJavaKt;
import android.databinding.tool.writer.ViewBinderKt;
import com.squareup.javapoet.JavaFile;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001a\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR%\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroid/databinding/tool/BaseDataBinder;", "", "input", "Landroid/databinding/tool/store/LayoutInfoInput;", "getRPackage", "Lkotlin/Function2;", "", "<init>", "(Landroid/databinding/tool/store/LayoutInfoInput;Lkotlin/jvm/functions/Function2;)V", "getInput", "()Landroid/databinding/tool/store/LayoutInfoInput;", "getGetRPackage", "()Lkotlin/jvm/functions/Function2;", "resourceBundle", "Landroid/databinding/tool/store/ResourceBundle;", "generateAll", "", "writer", "Landroid/databinding/tool/writer/JavaFileWriter;", "db-compilerCommon"})
@SourceDebugExtension(value={"SMAP\nBaseDataBinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseDataBinder.kt\nandroid/databinding/tool/BaseDataBinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,104:1\n1869#2,2:105\n1869#2,2:107\n1491#2:109\n1516#2,3:110\n1519#2,3:120\n1869#2:123\n1869#2,2:124\n1870#2:126\n382#3,7:113\n*S KotlinDebug\n*F\n+ 1 BaseDataBinder.kt\nandroid/databinding/tool/BaseDataBinder\n*L\n39#1:105,2\n50#1:107,2\n62#1:109\n62#1:110,3\n62#1:120,3\n90#1:123\n91#1:124,2\n90#1:126\n62#1:113,7\n*E\n"})
public final class BaseDataBinder {
    @NotNull
    private final LayoutInfoInput input;
    @Nullable
    private final Function2<String, String, String> getRPackage;
    @NotNull
    private final ResourceBundle resourceBundle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseDataBinder(@NotNull LayoutInfoInput input, @Nullable Function2<? super String, ? super String, String> getRPackage) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input;
        this.getRPackage = getRPackage;
        this.resourceBundle = new ResourceBundle(this.input.getPackageName(), this.input.getArgs().getUseAndroidX());
        Iterable $this$forEach$iv = this.input.getFilesToConsider();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            Closeable closeable = new FileInputStream(it);
            Throwable throwable = null;
            try {
                FileInputStream it2 = (FileInputStream)closeable;
                boolean bl2 = false;
                ResourceBundle.LayoutFileBundle bundle = ResourceBundle.LayoutFileBundle.fromXML(it2);
                this.resourceBundle.addLayoutBundle(bundle, true);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        this.resourceBundle.addDependencyLayouts(this.input.getExistingBindingClasses());
        this.resourceBundle.validateAndRegisterErrors();
    }

    @NotNull
    public final LayoutInfoInput getInput() {
        return this.input;
    }

    @Nullable
    public final Function2<String, String, String> getGetRPackage() {
        return this.getRPackage;
    }

    /*
     * WARNING - void declaration
     */
    public final void generateAll(@NotNull JavaFileWriter writer) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Object it;
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Iterable $this$forEach$iv = this.input.getInvalidatedClasses();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            writer.deleteFile((String)it);
        }
        LayoutInfoLog myLog = new LayoutInfoLog();
        myLog.addAll(this.input.getUnchangedLog());
        boolean useAndroidX = this.input.getArgs().getUseAndroidX();
        LibTypes libTypes = new LibTypes(useAndroidX);
        Set<ResourceBundle.LayoutFileBundle> set = this.resourceBundle.getAllLayoutFileBundlesInSource();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getAllLayoutFileBundlesInSource(...)");
        it = set;
        boolean $i$f$groupBy = false;
        void var8_8 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ResourceBundle.LayoutFileBundle p0 = (ResourceBundle.LayoutFileBundle)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = p0.getFileName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        SortedMap layoutBindings = MapsKt.toSortedMap((Map)destination$iv$iv);
        layoutBindings.forEach((arg_0, arg_1) -> BaseDataBinder.generateAll$lambda$8((arg_0, arg_1) -> BaseDataBinder.generateAll$lambda$7(this, libTypes, useAndroidX, writer, myLog, arg_0, arg_1), arg_0, arg_1));
        this.input.saveLog(myLog);
        Scope.assertNoError();
    }

    private static final Unit generateAll$lambda$7(BaseDataBinder this$0, LibTypes $libTypes, boolean $useAndroidX, JavaFileWriter $writer, LayoutInfoLog $myLog, String layoutName, List variations) {
        Intrinsics.checkNotNull((Object)variations);
        BaseLayoutModel layoutModel = new BaseLayoutModel(variations, this$0.getRPackage);
        JavaFile javaFile = null;
        GenClassInfoLog.GenClass classInfo = null;
        if (((ResourceBundle.LayoutFileBundle)CollectionsKt.first((List)variations)).isBindingData()) {
            if (!this$0.input.getArgs().getEnableDataBinding()) {
                boolean $i$a$-check-BaseDataBinder$generateAll$2$32 = false;
                String $i$a$-check-BaseDataBinder$generateAll$2$32 = "Data binding is not enabled but found data binding layouts: " + variations;
                throw new IllegalStateException($i$a$-check-BaseDataBinder$generateAll$2$32.toString());
            }
            BaseLayoutBinderWriter binderWriter = new BaseLayoutBinderWriter(layoutModel, $libTypes);
            javaFile = binderWriter.write();
            classInfo = binderWriter.generateClassInfo();
        } else {
            if (!this$0.input.getArgs().getEnableViewBinding()) {
                boolean $i$a$-check-BaseDataBinder$generateAll$2$42 = false;
                String $i$a$-check-BaseDataBinder$generateAll$2$42 = "View binding is not enabled but found non-data binding layouts: " + variations;
                throw new IllegalStateException($i$a$-check-BaseDataBinder$generateAll$2$42.toString());
            }
            ViewBinder viewBinder = ViewBinderKt.toViewBinder(layoutModel);
            javaFile = ViewBinderGenerateJavaKt.toJavaFile(viewBinder, !$useAndroidX);
            classInfo = ViewBinderGenerateJavaKt.generatedClassInfo(viewBinder);
        }
        $writer.writeToFile(javaFile);
        GenClassInfoLog genClassInfoLog = $myLog.getClassInfoLog();
        Intrinsics.checkNotNull((Object)layoutName);
        genClassInfoLog.addMapping(layoutName, classInfo);
        Iterable $this$forEach$iv = variations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResourceBundle.LayoutFileBundle it = (ResourceBundle.LayoutFileBundle)element$iv;
            boolean bl = false;
            List<ResourceBundle.BindingTargetBundle> list = it.getBindingTargetBundles();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getBindingTargetBundles(...)");
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ResourceBundle.BindingTargetBundle bundle = (ResourceBundle.BindingTargetBundle)element$iv2;
                boolean bl2 = false;
                if (!bundle.isBinder()) continue;
                String string = bundle.getIncludedLayout();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIncludedLayout(...)");
                $myLog.addDependency(layoutName, string);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void generateAll$lambda$8(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

