/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils.concurrency;

import com.android.utils.concurrency.AsyncSupplier;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\u0006\u0010\u0014\u001a\u00020\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/utils/concurrency/AsyncSupplierRefresher;", "V", "Lcom/android/utils/concurrency/AsyncSupplier;", "", "asyncSupplier", "refreshDuration", "Ljava/time/Duration;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "<init>", "(Lcom/android/utils/concurrency/AsyncSupplier;Ljava/time/Duration;Ljava/util/concurrent/ScheduledExecutorService;)V", "expensiveValueRef", "Ljava/lang/ref/WeakReference;", "scheduledFutureLock", "Ljava/util/concurrent/locks/ReentrantLock;", "scheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "reschedule", "", "refresh", "cancel", "android.sdktools.common"})
public final class AsyncSupplierRefresher<V extends AsyncSupplier<?>> {
    @NotNull
    private final Duration refreshDuration;
    @NotNull
    private final ScheduledExecutorService executor;
    @NotNull
    private final WeakReference<V> expensiveValueRef;
    @NotNull
    private final ReentrantLock scheduledFutureLock;
    @Nullable
    private ScheduledFuture<?> scheduledFuture;

    public AsyncSupplierRefresher(@NotNull V asyncSupplier, @NotNull Duration refreshDuration, @NotNull ScheduledExecutorService executor) {
        Intrinsics.checkNotNullParameter(asyncSupplier, (String)"asyncSupplier");
        Intrinsics.checkNotNullParameter((Object)refreshDuration, (String)"refreshDuration");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.refreshDuration = refreshDuration;
        this.executor = executor;
        this.expensiveValueRef = new WeakReference<V>(asyncSupplier);
        this.scheduledFutureLock = new ReentrantLock();
        this.reschedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reschedule() {
        Lock lock = this.scheduledFutureLock;
        lock.lock();
        try {
            boolean bl = false;
            ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
            boolean bl2 = scheduledFuture != null ? scheduledFuture.isCancelled() : false;
            if (bl2) {
                return;
            }
            this.scheduledFuture = this.executor.schedule(this::refresh, this.refreshDuration.toMillis(), TimeUnit.MILLISECONDS);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void refresh() {
        AsyncSupplier expensiveValue = (AsyncSupplier)this.expensiveValueRef.get();
        if (expensiveValue != null) {
            expensiveValue.get();
            this.reschedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        Lock lock = this.scheduledFutureLock;
        lock.lock();
        try {
            boolean bl = false;
            ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
            Boolean bl2 = scheduledFuture != null ? Boolean.valueOf(scheduledFuture.cancel(true)) : null;
        }
        finally {
            lock.unlock();
        }
    }
}

