/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.google.common.collect.Sets;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.ModuleState;
import com.google.services.firebase.ModuleStateService;
import com.google.services.firebase.config.AndroidClient;
import com.google.services.firebase.config.FirebaseLocalConfig;
import com.google.services.firebase.config.GradleConfig;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.EdtInvocationManager;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lcom/google/services/firebase/ModuleState;", "", "<init>", "()V", "taskLock", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "myModuleUpdateTask", "Ljava/lang/ref/WeakReference;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "numRequestedStateUpdates", "", "isCompletable", "", "()Z", "setCompletable", "(Z)V", "startRefreshTask", "", "module", "Lcom/intellij/openapi/module/Module;", "runRefreshStateTask", "calculateState", "firebase"})
@SourceDebugExtension(value={"SMAP\nModuleState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleState.kt\ncom/google/services/firebase/ModuleState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1563#2:115\n1634#2,3:116\n*S KotlinDebug\n*F\n+ 1 ModuleState.kt\ncom/google/services/firebase/ModuleState\n*L\n108#1:115\n108#1:116,3\n*E\n"})
public final class ModuleState {
    @NotNull
    private final Object taskLock = new Object();
    @NotNull
    private final Logger log;
    @Nullable
    private WeakReference<Task.Backgroundable> myModuleUpdateTask;
    private int numRequestedStateUpdates;
    private boolean isCompletable;

    public ModuleState() {
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.log = logger;
        this.isCompletable = true;
    }

    public final boolean isCompletable() {
        return this.isCompletable;
    }

    public final void setCompletable(boolean bl) {
        this.isCompletable = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startRefreshTask(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Object object = this.taskLock;
        synchronized (object) {
            boolean bl = false;
            int n = this.numRequestedStateUpdates;
            this.numRequestedStateUpdates = n + 1;
            WeakReference<Task.Backgroundable> weakReference = this.myModuleUpdateTask;
            if ((weakReference != null ? (Task.Backgroundable)weakReference.get() : null) == null) {
                this.myModuleUpdateTask = new WeakReference<Task.Backgroundable>(this.runRefreshStateTask(module));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final Task.Backgroundable runRefreshStateTask(Module module) {
        this.log.debug("Performing refresh task on module: " + module.getName());
        Project project = module.getProject();
        String string = FirebaseBundle.message("firebase.service.action.label.refresh.state.action", new Object[0]);
        Task.Backgroundable refreshTask2 = new Task.Backgroundable(this, module, project, string){
            final /* synthetic */ ModuleState this$0;
            final /* synthetic */ Module $module;
            {
                this.this$0 = $receiver;
                this.$module = $module;
                super($super_call_param$1, $super_call_param$2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ProgressIndicator indicator) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    int numLoops = 0;
                    int numStateUpdates = 0;
                    do {
                        ++numLoops;
                        object = ModuleState.access$getTaskLock$p(this.this$0);
                        ModuleState moduleState = this.this$0;
                        Object object2 = object;
                        synchronized (object2) {
                            boolean $i$a$-synchronized-ModuleState$runRefreshStateTask$refreshTask$1$run$42 = false;
                            ModuleState.access$setNumRequestedStateUpdates$p(moduleState, 0);
                            Unit $i$a$-synchronized-ModuleState$runRefreshStateTask$refreshTask$1$run$42 = Unit.INSTANCE;
                        }
                        ModuleState.access$getLog$p(this.this$0).debug("Running calculateState");
                        try {
                            ModuleStateService.Companion.getInstance().updateModuleState(this.$module, ModuleState.access$calculateState(this.this$0, this.$module));
                        }
                        catch (IllegalStateException e) {
                            ModuleState.access$getLog$p(this.this$0).warn("Gradle model not available, please check your gradle scripts and resync them with Android Studio using the Build menu.", (Throwable)e);
                        }
                        object = ModuleState.access$getTaskLock$p(this.this$0);
                        moduleState = this.this$0;
                        object2 = object;
                        synchronized (object2) {
                            boolean bl = false;
                            numStateUpdates = ModuleState.access$getNumRequestedStateUpdates$p(moduleState);
                            Unit unit = Unit.INSTANCE;
                        }
                    } while (numStateUpdates > 0 && numLoops < 5);
                }
                finally {
                    Object object3 = ModuleState.access$getTaskLock$p(this.this$0);
                    ModuleState moduleState = this.this$0;
                    object = object3;
                    synchronized (object) {
                        boolean bl = false;
                        ModuleState.access$setMyModuleUpdateTask$p(moduleState, null);
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }
        };
        EdtInvocationManager.getInstance().invokeLater(() -> ModuleState.runRefreshStateTask$lambda$1(refreshTask2));
        return refreshTask2;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean calculateState(Module module) {
        void $this$mapTo$iv$iv;
        FirebaseLocalConfig localConfig = FirebaseLocalConfig.fromModule(module);
        if (localConfig == null || localConfig.getConfigErrors() != null) {
            return true;
        }
        GradleConfig gradleConfig = GradleConfig.fromModule(module);
        List<AndroidClient> list = gradleConfig.getVariants();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getVariants(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void obj;
            AndroidClient androidClient = (AndroidClient)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(obj.getPackageName());
        }
        Set variantsPackageNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set<String> set = localConfig.getMyClientsPackageNames();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getMyClientsPackageNames(...)");
        Set<String> registeredPackageNames = set;
        return !Sets.difference((Set)variantsPackageNames, registeredPackageNames).isEmpty();
    }

    private static final void runRefreshStateTask$lambda$1(runRefreshStateTask.refreshTask.1 $refreshTask) {
        ProgressManager.getInstance().run((Task)$refreshTask);
    }

    public static final /* synthetic */ Object access$getTaskLock$p(ModuleState $this) {
        return $this.taskLock;
    }

    public static final /* synthetic */ Logger access$getLog$p(ModuleState $this) {
        return $this.log;
    }

    public static final /* synthetic */ boolean access$calculateState(ModuleState $this, Module module) {
        return $this.calculateState(module);
    }

    public static final /* synthetic */ void access$setNumRequestedStateUpdates$p(ModuleState $this, int n) {
        $this.numRequestedStateUpdates = n;
    }

    public static final /* synthetic */ int access$getNumRequestedStateUpdates$p(ModuleState $this) {
        return $this.numRequestedStateUpdates;
    }

    public static final /* synthetic */ void access$setMyModuleUpdateTask$p(ModuleState $this, WeakReference weakReference) {
        $this.myModuleUpdateTask = weakReference;
    }
}

