/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.config;

import com.android.tools.idea.gradle.model.IdeSigningConfig;
import com.android.tools.idea.gradle.model.IdeVariantCore;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.templates.KeystoreUtils;
import com.google.api.client.util.Maps;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.config.AndroidClient;
import com.google.services.firebase.view.FirebaseUiUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.InvalidDataException;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleConfig {
    public static final String RELEASE_BUILD_TYPE = "release";
    public static final String DEFAULT_ANDROID_DEBUG_BUILD_TYPE = "debug";
    private final List<AndroidClient> myVariants;

    public static GradleConfig fromModule(@NotNull Module androidModule) {
        GradleAndroidModel gradleModel = GradleAndroidModel.get((Module)androidModule);
        if (gradleModel == null) {
            throw new IllegalStateException("Couldn't retrieve Android gradle model for current Android model");
        }
        AndroidFacet appAndroidFacet = AndroidFacet.getInstance((Module)androidModule);
        if (appAndroidFacet == null) {
            throw new IllegalStateException("Could not find Android Facet associated with the Android module");
        }
        List variants = gradleModel.getVariants();
        HashMap signingConfigMap = Maps.newHashMap();
        gradleModel.getAndroidProject().getSigningConfigs().forEach(signingConfig -> signingConfigMap.put(signingConfig.getName(), signingConfig));
        ImmutableList.Builder variantListBuilder = ImmutableList.builder();
        String packageName = gradleModel.getApplicationId();
        if (packageName.equals("uninitialized.application.id")) {
            throw new IllegalStateException("App hasn't been build yet, cannot obtain package name.");
        }
        for (IdeVariantCore variant : variants) {
            GradleConfig.getLog().debug("Found variant to inspect: " + String.valueOf(variant));
            String sha1 = GradleConfig.getSigningCertSha1(androidModule, appAndroidFacet, signingConfigMap, variant);
            GradleConfig.getLog().debug("Sha1 - " + sha1);
            if (Strings.isNullOrEmpty((String)packageName) || Strings.isNullOrEmpty((String)sha1)) {
                GradleConfig.getLog().warn("Ignoring variant because signing config couldn't be found, applicationId: " + packageName + ", buildType: " + variant.getBuildType());
                continue;
            }
            boolean allowVariantRegistration = true;
            if (RELEASE_BUILD_TYPE.equalsIgnoreCase(variant.getBuildType())) {
                GradleConfig.getLog().info("Release variants aren't eligible to be auto-registered, applicationId: " + packageName + ", buildType: " + variant.getBuildType());
                allowVariantRegistration = false;
            }
            GradleConfig.getLog().info("Found variant: package=" + packageName + ", sha1=" + sha1 + ", attemptRegistry=" + allowVariantRegistration);
            try {
                AndroidClient client = new AndroidClient(packageName, sha1, allowVariantRegistration);
                variantListBuilder.add((Object)client);
            }
            catch (InvalidDataException | IllegalArgumentException exception) {
                GradleConfig.getLog().info("Ignoring variant with '" + packageName + "' and cert sha1 '" + sha1 + "'");
            }
        }
        return new GradleConfig((ImmutableList<AndroidClient>)variantListBuilder.build());
    }

    @VisibleForTesting
    GradleConfig(@NotNull ImmutableList<AndroidClient> variants) {
        this.myVariants = variants;
    }

    @Nullable
    private static String getSigningCertSha1(@NotNull Module androidModule, @NotNull AndroidFacet appAndroidFacet, @NotNull Map<String, IdeSigningConfig> signingConfigMap, IdeVariantCore variant) {
        IdeSigningConfig signingConfig = null;
        File storeFile = null;
        String signingConfigName = variant.getMainArtifact().getSigningConfigName();
        if (!Strings.isNullOrEmpty((String)signingConfigName)) {
            signingConfig = signingConfigMap.get(signingConfigName);
            if (signingConfig != null) {
                storeFile = signingConfig.getStoreFile();
            }
        } else if (DEFAULT_ANDROID_DEBUG_BUILD_TYPE.equals(variant.getBuildType())) {
            try {
                storeFile = KeystoreUtils.getDebugKeystore((AndroidFacet)appAndroidFacet);
            }
            catch (Exception e) {
                FirebaseUiUtils.showWarningBalloon(androidModule.getProject(), FirebaseBundle.message("firebaseConnectAction.userError.couldNotFindDefaultDebugKeystore", new Object[0]), e);
            }
        }
        if (storeFile == null) {
            return null;
        }
        if (!storeFile.exists()) {
            FirebaseUiUtils.showWarningBalloon(androidModule.getProject(), FirebaseBundle.message("firebaseConnectAction.userError.keystoreNotPresent", storeFile.getAbsoluteFile(), variant.getBuildType(), ""), null);
            return null;
        }
        try {
            if (signingConfig != null && !Strings.isNullOrEmpty((String)signingConfig.getKeyAlias())) {
                if (!signingConfig.getStoreFile().exists()) {
                    FirebaseUiUtils.showWarningBalloon(androidModule.getProject(), FirebaseBundle.message("firebaseConnectAction.userError.couldNotFindDefaultKeystore", variant.getBuildType(), signingConfig.getStoreFile()), null);
                    return null;
                }
                return KeystoreUtils.sha1((File)signingConfig.getStoreFile(), (String)signingConfig.getKeyAlias(), (String)signingConfig.getStorePassword());
            }
            return KeystoreUtils.sha1((File)storeFile);
        }
        catch (Exception exception) {
            GradleConfig.getLog().warn("Skipping variant; unable to calculate SHA1 of certificate in " + storeFile.getAbsolutePath());
            return null;
        }
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(GradleConfig.class);
    }

    public List<AndroidClient> getVariants() {
        return this.myVariants;
    }
}

