/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.containers.ClassMap;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeService;
import com.jetbrains.cidr.lang.OCTestLineMarkInfo;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCTestFramework {
    public static final ExtensionPointName<OCTestFramework> EP_NAME = ExtensionPointName.create((String)"cidr.lang.testFramework");
    private static final ClassMap<OCTestFramework> frameworksCache = new ClassMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends OCTestFramework> T getInstance(Class<T> clazz) {
        OCTestFramework framework = (OCTestFramework)frameworksCache.get(clazz);
        if (framework == null) {
            ClassMap<OCTestFramework> classMap = frameworksCache;
            synchronized (classMap) {
                framework = (OCTestFramework)frameworksCache.get(clazz);
                if (framework == null) {
                    framework = (OCTestFramework)EP_NAME.findExtension(clazz);
                    frameworksCache.put(clazz, (Object)framework);
                }
            }
        }
        return (T)framework;
    }

    public static boolean canContainsTest(@NotNull PsiFileSystemItem fileOrDirectory) {
        Predicate maybeTestItem;
        if (fileOrDirectory == null) {
            OCTestFramework.$$$reportNull$$$0(0);
        }
        if ((maybeTestItem = CidrTestScopeService.getInstance((Project)fileOrDirectory.getProject()).getTestCandidateChecker()) == null) {
            return true;
        }
        return maybeTestItem.test(fileOrDirectory);
    }

    @Contract(value="null -> true")
    public abstract boolean isAvailable(@Nullable PsiFile var1);

    public boolean hasSuspendedTestIndex(@NotNull PsiFile file) {
        if (file == null) {
            OCTestFramework.$$$reportNull$$$0(1);
        }
        return false;
    }

    public void resumeTestIndex(@NotNull PsiFile file) {
        if (file == null) {
            OCTestFramework.$$$reportNull$$$0(2);
        }
    }

    @Contract(value="null, null, _ -> false")
    public boolean isTestClassOrStruct(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Project project) {
        if (project == null) {
            OCTestFramework.$$$reportNull$$$0(3);
        }
        return false;
    }

    @Contract(value="null, null, _ -> false")
    public boolean isTestMethodOrFunction(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Project project) {
        if (project == null) {
            OCTestFramework.$$$reportNull$$$0(4);
        }
        return false;
    }

    @Contract(value="null, null, _ -> false")
    public boolean isTestNamespace(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Project project) {
        if (project == null) {
            OCTestFramework.$$$reportNull$$$0(5);
        }
        return false;
    }

    @Contract(value="null, null, _ -> false")
    public boolean isTestGlobalVar(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Project project) {
        if (project == null) {
            OCTestFramework.$$$reportNull$$$0(6);
        }
        return false;
    }

    @Contract(value="null -> null")
    public abstract OCTestLineMarkInfo getTestLineMarkInfo(@Nullable PsiElement var1);

    @Nullable
    public CidrTestScopeElement generateVirtualTestScopeElement(String suitePath, String testPath, @NotNull String testSource) {
        if (testSource == null) {
            OCTestFramework.$$$reportNull$$$0(7);
        }
        return null;
    }

    @Nullable
    public String generateTestPath(String suitePath, String testPath, @NotNull String testSource) {
        CidrTestScopeElement Elem;
        if (testSource == null) {
            OCTestFramework.$$$reportNull$$$0(8);
        }
        if ((Elem = this.generateVirtualTestScopeElement(suitePath, testPath, testSource)) != null) {
            return Elem.getTestPath();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDirectory";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testSource";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/OCTestFramework";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canContainsTest";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSuspendedTestIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resumeTestIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestClassOrStruct";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestMethodOrFunction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestNamespace";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestGlobalVar";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "generateVirtualTestScopeElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "generateTestPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

