/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileLangBackendHandler;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderContextCache;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCFileExtensionsSettings;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCNewFileLangBackendHandlerImpl
implements OCNewFileLangBackendHandler {
    private static final String DEFAULT_H_EXT = "h";

    public boolean isProjectLoaded(@NotNull Project project) {
        if (project == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(0);
        }
        return FileSymbolTablesCache.areSymbolsLoaded(project);
    }

    @Nullable
    public VirtualFile getVirtualFile(@Nullable PsiFile file) {
        return OCFileUtil.getVirtualFile(file);
    }

    public void handleCreatedFile(@NotNull PsiFile file) {
        if (file == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(1);
        }
        if (file instanceof OCFile) {
            FileSymbolTable.forFile(file, OCHeaderContextCache.headerContext(file).derive());
        }
    }

    @NotNull
    public LanguageFileType getFileType() {
        OCFileType oCFileType = OCFileType.INSTANCE;
        if (oCFileType == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(2);
        }
        return oCFileType;
    }

    @NotNull
    public Language getLanguage() {
        Language language = LanguageUtils.getInstance().getConfigLanguage();
        if (language == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(3);
        }
        return language;
    }

    public boolean isCppFileExtension(@NotNull String extension, @NotNull Project project) {
        OCLanguageKind kind;
        if (extension == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(4);
        }
        if (project == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(5);
        }
        return (kind = OCLanguageKindCalculator.calculateMinimalKindByExtension(project, extension)) != null && kind.isCpp();
    }

    @NotNull
    public Couple<String> determineExtensions(@NotNull PsiFile sampleFile, @Nullable String preferredSourceExt, @Nullable String preferredHeaderExt) {
        if (sampleFile == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(6);
        }
        Project project = sampleFile.getProject();
        if (!(sampleFile instanceof OCFile)) {
            Couple couple = Couple.of((Object)preferredSourceExt, (Object)preferredHeaderExt);
            if (couple == null) {
                OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(7);
            }
            return couple;
        }
        OCFile ocFile = (OCFile)sampleFile;
        if (preferredSourceExt == null && preferredHeaderExt == null) {
            if (ocFile.isHeader()) {
                preferredHeaderExt = FileUtilRt.getExtension((String)ocFile.getName());
                OCFile implFile = ocFile.getAssociatedFile();
                if (implFile != null) {
                    preferredSourceExt = FileUtilRt.getExtension((String)implFile.getName());
                }
            } else {
                preferredSourceExt = FileUtilRt.getExtension((String)ocFile.getName());
            }
        }
        if (preferredSourceExt == null) {
            preferredSourceExt = OCNewFileLangBackendHandlerImpl.findSourceExt(project, preferredHeaderExt, ocFile.getKind());
        } else if (preferredHeaderExt == null) {
            preferredHeaderExt = OCNewFileLangBackendHandlerImpl.findHeaderExt(project, preferredSourceExt);
        }
        Couple couple = Couple.of((Object)preferredSourceExt, (Object)preferredHeaderExt);
        if (couple == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(8);
        }
        return couple;
    }

    @NotNull
    public String getHeaderGuardStylePattern(@NotNull String filePath, @NotNull Project project) {
        if (filePath == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(9);
        }
        if (project == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(10);
        }
        String string = ((OCCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class)).HEADER_GUARD_STYLE_PATTERN;
        if (string == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private static String findSourceExt(@NotNull Project project, @NotNull String headerExt, @NotNull OCLanguageKind headerKind) {
        if (project == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(12);
        }
        if (headerExt == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(13);
        }
        if (headerKind == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(14);
        }
        for (FileExtensionPair pair : ((OCFileExtensionsSettings)CodeStyle.getSettings((Project)project).getCustomSettings(OCFileExtensionsSettings.class)).FILE_EXTENSION_PAIRS_ORDERED) {
            OCLanguageKind sourceKind;
            if (!pair.myHeaderExt.equals(headerExt) || headerKind != (sourceKind = OCLanguageKindCalculator.calculateMinimalKindByExtension(project, "." + pair.mySourceExt))) continue;
            String string = pair.mySourceExt;
            if (string == null) {
                OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = headerKind.getDefaultSourceExtension();
        if (string == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static String findHeaderExt(@NotNull Project project, @NotNull String sourceExt) {
        if (project == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(17);
        }
        if (sourceExt == null) {
            OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(18);
        }
        for (FileExtensionPair pair : ((OCFileExtensionsSettings)CodeStyle.getSettings((Project)project).getCustomSettings(OCFileExtensionsSettings.class)).FILE_EXTENSION_PAIRS_ORDERED) {
            if (!pair.mySourceExt.equals(sourceExt)) continue;
            String string = pair.myHeaderExt;
            if (string == null) {
                OCNewFileLangBackendHandlerImpl.$$$reportNull$$$0(19);
            }
            return string;
        }
        return DEFAULT_H_EXT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 7, 8, 11, 15, 16, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 11: 
            case 15: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/actions/newFile/OCNewFileLangBackendHandlerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerExt";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerKind";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceExt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/actions/newFile/OCNewFileLangBackendHandlerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "determineExtensions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderGuardStylePattern";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findSourceExt";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findHeaderExt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isProjectLoaded";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleCreatedFile";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 11: 
            case 15: 
            case 16: 
            case 19: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCppFileExtension";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "determineExtensions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getHeaderGuardStylePattern";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findSourceExt";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findHeaderExt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 7, 8, 11, 15, 16, 19 -> new IllegalStateException(string);
        };
    }
}

